/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.decoration.item;

import javax.annotation.Nonnull;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.interf.IExtraVariantHolder;
import vazkii.arl.interf.IItemColorProvider;
import vazkii.arl.item.ItemMod;
import vazkii.quark.base.item.IQuarkItem;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.decoration.entity.EntityColoredItemFrame;
import vazkii.quark.decoration.feature.FlatItemFrames;

public class ItemColoredItemFrame
extends ItemMod
implements IItemColorProvider,
IExtraVariantHolder,
IQuarkItem {
    private static final String[] VARIANTS = new String[]{"colored_item_frame_white", "colored_item_frame_orange", "colored_item_frame_magenta", "colored_item_frame_light_blue", "colored_item_frame_yellow", "colored_item_frame_lime", "colored_item_frame_pink", "colored_item_frame_gray", "colored_item_frame_silver", "colored_item_frame_cyan", "colored_item_frame_purple", "colored_item_frame_blue", "colored_item_frame_brown", "colored_item_frame_green", "colored_item_frame_red", "colored_item_frame_black"};
    private static final String[] EXTRA_VARIANTS = new String[]{"colored_item_frame_normal", "colored_item_frame_wood", "colored_item_frame_map", "colored_item_frame_map_wood"};

    public ItemColoredItemFrame() {
        super("colored_item_frame", VARIANTS);
        this.func_77637_a(CreativeTabs.field_78031_c);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        BlockPos blockpos = pos.func_177972_a(facing);
        if ((ModuleLoader.isFeatureEnabled(FlatItemFrames.class) || facing.func_176740_k() != EnumFacing.Axis.Y) && playerIn.func_175151_a(blockpos, facing, stack)) {
            EntityHanging entityhanging = this.createEntity(worldIn, blockpos, facing, stack.func_77952_i());
            if (entityhanging != null && entityhanging.func_70518_d()) {
                if (!worldIn.field_72995_K) {
                    entityhanging.func_184523_o();
                    worldIn.func_72838_d((Entity)entityhanging);
                }
                stack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    private EntityHanging createEntity(World worldIn, BlockPos pos, EnumFacing clickedSide, int color) {
        return new EntityColoredItemFrame(worldIn, pos, clickedSide, color);
    }

    public String getUniqueModel() {
        return "colored_item_frame";
    }

    public String[] getExtraVariants() {
        return EXTRA_VARIANTS;
    }

    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return new IItemColor(){

            public int func_186726_a(@Nonnull ItemStack stack, int tintIndex) {
                return tintIndex == 1 ? ItemDye.field_150922_c[15 - Math.min(15, stack.func_77952_i())] : 0xFFFFFF;
            }
        };
    }
}

