/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.client.feature;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemShulkerBox;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.module.Feature;
import vazkii.quark.client.feature.ChestSearchBar;

public class ShulkerBoxTooltip
extends Feature {
    public static ResourceLocation WIDGET_RESOURCE = new ResourceLocation("quark", "textures/misc/shulker_widget.png");
    boolean useColors;
    boolean requireShift;

    @Override
    public void setupConfig() {
        this.useColors = this.loadPropBool("Use Colors", "", true);
        this.requireShift = this.loadPropBool("Needs Shift to be visible", "", false);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void makeTooltip(ItemTooltipEvent event) {
        NBTTagCompound cmp;
        if (!event.getItemStack().func_190926_b() && event.getItemStack().func_77973_b() instanceof ItemShulkerBox && event.getItemStack().func_77942_o() && (cmp = ItemNBTHelper.getCompound((ItemStack)event.getItemStack(), (String)"BlockEntityTag", (boolean)true)) != null && cmp.func_150297_b("Items", 9)) {
            List tooltip = event.getToolTip();
            ArrayList tooltipCopy = new ArrayList(tooltip);
            for (int i = 1; i < tooltipCopy.size(); ++i) {
                String s = (String)tooltipCopy.get(i);
                if (s.startsWith("\u00a7") && !s.startsWith("\u00a7o")) continue;
                tooltip.remove(tooltip.indexOf(s));
            }
            if (this.requireShift && !GuiScreen.func_146272_n()) {
                tooltip.add(1, I18n.func_135052_a((String)"quarkmisc.shulkerBoxShift", (Object[])new Object[0]));
            }
        }
    }

    @SubscribeEvent
    public void renderTooltip(RenderTooltipEvent.PostText event) {
        NBTTagCompound cmp;
        if (event.getStack() != null && event.getStack().func_77973_b() instanceof ItemShulkerBox && event.getStack().func_77942_o() && (!this.requireShift || GuiScreen.func_146272_n()) && (cmp = ItemNBTHelper.getCompound((ItemStack)event.getStack(), (String)"BlockEntityTag", (boolean)true)) != null && cmp.func_150297_b("Items", 9)) {
            ScaledResolution res;
            int right;
            ItemStack currentBox = event.getStack();
            int currentX = event.getX() - 5;
            int currentY = event.getY() - 70;
            int texWidth = 172;
            int texHeight = 64;
            if (currentY < 0) {
                currentY = event.getY() + event.getLines().size() * 10 + 5;
            }
            if ((right = currentX + texWidth) > (res = new ScaledResolution(Minecraft.func_71410_x())).func_78326_a()) {
                currentX -= right - res.func_78326_a();
            }
            GlStateManager.func_179094_E();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)700.0f);
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_110434_K().func_110577_a(WIDGET_RESOURCE);
            RenderHelper.func_74518_a();
            if (this.useColors) {
                EnumDyeColor dye = ((BlockShulkerBox)((ItemBlock)currentBox.func_77973_b()).func_179223_d()).func_190956_e();
                int color = ItemDye.field_150922_c[dye.func_176767_b()];
                Color colorObj = new Color(color);
                GlStateManager.func_179124_c((float)((float)colorObj.getRed() / 255.0f), (float)((float)colorObj.getGreen() / 255.0f), (float)((float)colorObj.getBlue() / 255.0f));
            }
            Gui.func_146110_a((int)currentX, (int)currentY, (float)0.0f, (float)0.0f, (int)texWidth, (int)texHeight, (float)256.0f, (float)256.0f);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            NonNullList itemList = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)cmp, (NonNullList)itemList);
            RenderItem render = mc.func_175599_af();
            RenderHelper.func_74520_c();
            GlStateManager.func_179126_j();
            int i = 0;
            for (ItemStack itemstack : itemList) {
                int xp = currentX + 6 + i % 9 * 18;
                int yp = currentY + 6 + i / 9 * 18;
                if (!itemstack.func_190926_b()) {
                    render.func_180450_b(itemstack, xp, yp);
                    render.func_175030_a(mc.field_71466_p, itemstack, xp, yp);
                }
                if (!ChestSearchBar.namesMatch(itemstack, ChestSearchBar.text)) {
                    GlStateManager.func_179097_i();
                    Gui.func_73734_a((int)xp, (int)yp, (int)(xp + 16), (int)(yp + 16), (int)-1442840576);
                }
                ++i;
            }
            GlStateManager.func_179097_i();
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }
}

