/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.client.feature;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.base.module.Feature;

public class MapTooltip
extends Feature {
    private static final ResourceLocation RES_MAP_BACKGROUND = new ResourceLocation("textures/map/map_background.png");
    boolean requireShift;

    @Override
    public void setupConfig() {
        this.requireShift = this.loadPropBool("Needs Shift to be visible", "", false);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void makeTooltip(ItemTooltipEvent event) {
        if (!event.getItemStack().func_190926_b() && event.getItemStack().func_77973_b() instanceof ItemMap && this.requireShift && !GuiScreen.func_146272_n()) {
            event.getToolTip().add(1, I18n.func_135052_a((String)"quarkmisc.mapShift", (Object[])new Object[0]));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderTooltip(RenderTooltipEvent.PostText event) {
        if (event.getStack() != null && event.getStack().func_77973_b() instanceof ItemMap && (!this.requireShift || GuiScreen.func_146272_n())) {
            Minecraft mc = Minecraft.func_71410_x();
            MapData mapdata = Items.field_151098_aY.func_77873_a(event.getStack(), (World)mc.field_71441_e);
            if (mapdata == null) {
                return;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.func_74518_a();
            mc.func_110434_K().func_110577_a(RES_MAP_BACKGROUND);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            int pad = 7;
            float size = 135.0f;
            float scale = 0.5f;
            GlStateManager.func_179109_b((float)event.getX(), (float)((float)event.getY() - size * scale - 5.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b((double)(-pad), (double)size, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            vertexbuffer.func_181662_b((double)size, (double)size, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            vertexbuffer.func_181662_b((double)size, (double)(-pad), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            vertexbuffer.func_181662_b((double)(-pad), (double)(-pad), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            mc.field_71460_t.func_147701_i().func_148250_a(mapdata, false);
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }
}

