/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.arl.util.ItemNBTHelper;

public class ProxiedItemStackHandler
implements IItemHandler,
IItemHandlerModifiable,
ICapabilityProvider {
    protected final ItemStack stack;
    protected final String key;
    protected final int size;

    public ProxiedItemStackHandler(ItemStack stack) {
        this(stack, "Inventory", 1);
    }

    public ProxiedItemStackHandler(ItemStack stack, String key) {
        this(stack, key, 1);
    }

    public ProxiedItemStackHandler(ItemStack stack, int size) {
        this(stack, "Inventory", size);
    }

    public ProxiedItemStackHandler(ItemStack stack, String key, int size) {
        this.stack = stack;
        this.key = key;
        this.size = size;
    }

    private NBTTagList getStackList() {
        NBTTagList list = ItemNBTHelper.getList((ItemStack)this.stack, (String)this.key, (int)10, (boolean)true);
        if (list == null) {
            list = new NBTTagList();
            ItemNBTHelper.setList((ItemStack)this.stack, (String)this.key, (NBTTagList)list);
        }
        while (list.func_74745_c() < this.size) {
            list.func_74742_a((NBTBase)new NBTTagCompound());
        }
        return list;
    }

    private void writeStack(int index, @Nonnull ItemStack stack) {
        stack.func_77955_b(this.getStackList().func_150305_b(index));
        this.onContentsChanged(index);
    }

    private ItemStack readStack(int index) {
        return new ItemStack(this.getStackList().func_150305_b(index));
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.validateSlotIndex(slot);
        this.writeStack(slot, stack);
        this.onContentsChanged(slot);
    }

    public int getSlots() {
        return this.size;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.readStack(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.readStack(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            this.writeStack(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.readStack(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.writeStack(slot, ItemStack.field_190927_a);
            }
            return existing;
        }
        if (!simulate) {
            this.writeStack(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.func_77976_d());
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.size) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.size + ")");
        }
    }

    protected void onContentsChanged(int slot) {
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this) : null);
    }
}

