/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import vazkii.quark.base.client.IParentedGui;
import vazkii.quark.vanity.client.emotes.EmoteDescriptor;
import vazkii.quark.vanity.client.emotes.EmoteHandler;

public class ModKeybinds {
    public static HashMap<KeyBinding, String> emoteKeys = new HashMap();
    public static BiMap<KeyBinding, IParentedGui> keyboundButtons = HashBiMap.create();
    public static KeyBinding lockKey = null;
    public static KeyBinding autoJumpKey = null;
    public static KeyBinding changeHotbarKey = null;
    public static KeyBinding dropoffKey = null;
    public static KeyBinding playerSortKey = null;
    public static KeyBinding chestSortKey = null;
    public static KeyBinding chestDropoffKey = null;
    public static KeyBinding chestMergeKey = null;
    public static KeyBinding chestRestockKey = null;
    public static KeyBinding chestExtractKey = null;
    private static final String MISC_GROUP = "quark.gui.keygroupMisc";
    private static final String INV_GROUP = "quark.gui.keygroupInv";
    private static final String EMOTE_GROUP = "quark.gui.keygroupEmote";

    public static void initEmoteKeybinds() {
        for (String emoteName : EmoteHandler.emoteMap.keySet()) {
            EmoteDescriptor desc = EmoteHandler.emoteMap.get(emoteName);
            KeyBinding key = ModKeybinds.init(desc.getTranslationKey(), 0, EMOTE_GROUP, false);
            emoteKeys.put(key, emoteName);
        }
    }

    public static void initLockKey() {
        lockKey = ModKeybinds.init("lockBuilding", 37, MISC_GROUP);
    }

    public static void initAutoJumpKey() {
        autoJumpKey = ModKeybinds.init("toggleAutojump", 48, MISC_GROUP);
    }

    public static void initChangeHotbarKey() {
        changeHotbarKey = ModKeybinds.init("changeHotbar", 44, MISC_GROUP);
    }

    public static void initDropoffKey() {
        dropoffKey = ModKeybinds.initAndButtonBind("dropoff", 0);
    }

    public static void initPlayerSortingKey() {
        playerSortKey = ModKeybinds.initAndButtonBind("playerSort", 0);
    }

    public static void initChestKeys() {
        chestSortKey = ModKeybinds.initAndButtonBind("chestSort", 0);
        chestDropoffKey = ModKeybinds.initAndButtonBind("chestDropoff", 0);
        chestMergeKey = ModKeybinds.initAndButtonBind("chestMerge", 0);
        chestRestockKey = ModKeybinds.initAndButtonBind("chestRestock", 0);
        chestExtractKey = ModKeybinds.initAndButtonBind("chestExtract", 0);
    }

    public static void keybindButton(KeyBinding key, IParentedGui ipg) {
        if (key != null) {
            keyboundButtons.put((Object)key, (Object)ipg);
        }
    }

    private static KeyBinding initAndButtonBind(String s, int key) {
        KeyBinding kb = ModKeybinds.init(s, key, INV_GROUP);
        new KeybindButtonHandler(kb);
        return kb;
    }

    private static KeyBinding init(String s, int key, String group) {
        return ModKeybinds.init(s, key, group, true);
    }

    private static KeyBinding init(String s, int key, String group, boolean prefix) {
        KeyBinding kb = new KeyBinding(prefix ? "quark.keybind." + s : s, key, group);
        ClientRegistry.registerKeyBinding((KeyBinding)kb);
        return kb;
    }

    public static boolean isKeyDown(KeyBinding keybind) {
        int key = keybind.func_151463_i();
        if (key == 0) {
            return false;
        }
        if (key < 0) {
            int button = 100 + key;
            return Mouse.isButtonDown((int)button);
        }
        try {
            return Keyboard.isKeyDown((int)key);
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    private static class KeybindButtonHandler {
        final KeyBinding ref;
        boolean down;

        public KeybindButtonHandler(KeyBinding ref) {
            this.ref = ref;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onKeyinput(GuiScreenEvent.KeyboardInputEvent.Post event) {
            IParentedGui ipg;
            GuiScreen curr;
            boolean wasDown = this.down;
            this.down = ModKeybinds.isKeyDown(this.ref);
            if (!wasDown && this.down && keyboundButtons.containsKey((Object)this.ref) && (curr = Minecraft.func_71410_x().field_71462_r) == (ipg = (IParentedGui)keyboundButtons.get((Object)this.ref)).getParent()) {
                GuiButton button = (GuiButton)ipg;
                if (button.field_146124_l && button.field_146125_m) {
                    List buttonList = (List)ObfuscationReflectionHelper.getPrivateValue(GuiScreen.class, (Object)curr, (String)"field_146292_n");
                    GuiScreenEvent.ActionPerformedEvent.Pre postEvent = new GuiScreenEvent.ActionPerformedEvent.Pre(curr, button, buttonList);
                    MinecraftForge.EVENT_BUS.post((Event)postEvent);
                }
            }
        }
    }
}

