/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.fluids;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.WorldTools;
import mcjty.xnet.api.channels.IChannelSettings;
import mcjty.xnet.api.channels.IConnectorSettings;
import mcjty.xnet.api.channels.IControllerContext;
import mcjty.xnet.api.gui.IEditorGui;
import mcjty.xnet.api.gui.IndicatorIcon;
import mcjty.xnet.api.helper.DefaultChannelSettings;
import mcjty.xnet.api.keys.SidedConsumer;
import mcjty.xnet.apiimpl.EnumStringTranslators;
import mcjty.xnet.apiimpl.fluids.FluidConnectorSettings;
import mcjty.xnet.config.ConfigSetup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.apache.commons.lang3.tuple.Pair;

public class FluidChannelSettings
extends DefaultChannelSettings
implements IChannelSettings {
    public static final ResourceLocation iconGuiElements = new ResourceLocation("xnet", "textures/gui/guielements.png");
    public static final String TAG_MODE = "mode";
    private ChannelMode channelMode = ChannelMode.DISTRIBUTE;
    private int delay = 0;
    private int roundRobinOffset = 0;
    private Map<SidedConsumer, FluidConnectorSettings> fluidExtractors = null;
    private List<Pair<SidedConsumer, FluidConnectorSettings>> fluidConsumers = null;

    public ChannelMode getChannelMode() {
        return this.channelMode;
    }

    @Override
    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        object.add(TAG_MODE, (JsonElement)new JsonPrimitive(this.channelMode.name()));
        return object;
    }

    @Override
    public void readFromJson(JsonObject data) {
        this.channelMode = EnumStringTranslators.getFluidChannelMode(data.get(TAG_MODE).getAsString());
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.channelMode = ChannelMode.values()[tag.func_74771_c(TAG_MODE)];
        this.delay = tag.func_74762_e("delay");
        this.roundRobinOffset = tag.func_74762_e("offset");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74774_a(TAG_MODE, (byte)this.channelMode.ordinal());
        tag.func_74768_a("delay", this.delay);
        tag.func_74768_a("offset", this.roundRobinOffset);
    }

    @Override
    public void tick(int channel, IControllerContext context) {
        --this.delay;
        if (this.delay <= 0) {
            this.delay = 1200;
        }
        if (this.delay % 10 != 0) {
            return;
        }
        int d = this.delay / 10;
        this.updateCache(channel, context);
        World world = context.getControllerWorld();
        for (Map.Entry<SidedConsumer, FluidConnectorSettings> entry : this.fluidExtractors.entrySet()) {
            FluidStack fetchedFluid;
            FluidStack stack;
            TileEntity te;
            IFluidHandler handler;
            EnumFacing side;
            BlockPos pos;
            BlockPos extractorPos;
            FluidConnectorSettings settings = entry.getValue();
            if (d % settings.getSpeed() != 0 || (extractorPos = context.findConsumerPosition(entry.getKey().getConsumerId())) == null || !WorldTools.chunkLoaded((World)world, (BlockPos)(pos = extractorPos.func_177972_a(side = entry.getKey().getSide()))) || (handler = FluidChannelSettings.getFluidHandlerAt(te = world.func_175625_s(pos), settings.getFacing())) == null || this.checkRedstone(world, settings, extractorPos) || !context.matchColor(settings.getColorsMask())) continue;
            FluidStack extractMatcher = settings.getMatcher();
            int toextract = settings.getRate();
            Integer count = settings.getMinmax();
            if (count != null) {
                int amount = this.countFluid(handler, extractMatcher);
                int canextract = amount - count;
                if (canextract <= 0) continue;
                toextract = Math.min(toextract, canextract);
            }
            if ((stack = this.fetchFluid(handler, true, extractMatcher, toextract)) == null) continue;
            ArrayList<Pair<SidedConsumer, FluidConnectorSettings>> inserted = new ArrayList<Pair<SidedConsumer, FluidConnectorSettings>>();
            int remaining = this.insertFluidSimulate(inserted, context, stack);
            if (inserted.isEmpty() || remaining >= stack.amount || !context.checkAndConsumeRF(ConfigSetup.controllerOperationRFT.get()) || (fetchedFluid = this.fetchFluid(handler, false, extractMatcher, stack.amount - remaining)) == null) continue;
            this.insertFluidReal(context, inserted, fetchedFluid);
        }
    }

    @Override
    public void cleanCache() {
        this.fluidExtractors = null;
        this.fluidConsumers = null;
    }

    private FluidStack fetchFluid(IFluidHandler handler, boolean simulate, @Nullable FluidStack matcher, int rate) {
        return handler.drain(rate, !simulate);
    }

    private int insertFluidSimulate(@Nonnull List<Pair<SidedConsumer, FluidConnectorSettings>> inserted, @Nonnull IControllerContext context, @Nonnull FluidStack stack) {
        World world = context.getControllerWorld();
        if (this.channelMode == ChannelMode.PRIORITY) {
            this.roundRobinOffset = 0;
        }
        int amount = stack.amount;
        for (int j = 0; j < this.fluidConsumers.size(); ++j) {
            EnumFacing side;
            BlockPos pos;
            TileEntity te;
            IFluidHandler handler;
            BlockPos consumerPos;
            int i = (j + this.roundRobinOffset) % this.fluidConsumers.size();
            Pair<SidedConsumer, FluidConnectorSettings> entry = this.fluidConsumers.get(i);
            FluidConnectorSettings settings = (FluidConnectorSettings)entry.getValue();
            if (settings.getMatcher() != null && !settings.getMatcher().equals((Object)stack) || (consumerPos = context.findConsumerPosition(((SidedConsumer)entry.getKey()).getConsumerId())) == null || !WorldTools.chunkLoaded((World)world, (BlockPos)consumerPos) || this.checkRedstone(world, settings, consumerPos) || !context.matchColor(settings.getColorsMask()) || (handler = FluidChannelSettings.getFluidHandlerAt(te = world.func_175625_s(pos = consumerPos.func_177972_a(side = ((SidedConsumer)entry.getKey()).getSide())), settings.getFacing())) == null) continue;
            int toinsert = Math.min(settings.getRate(), amount);
            Integer count = settings.getMinmax();
            if (count != null) {
                int a = this.countFluid(handler, settings.getMatcher());
                int caninsert = count - a;
                if (caninsert <= 0) continue;
                toinsert = Math.min(toinsert, caninsert);
            }
            FluidStack copy = stack.copy();
            copy.amount = toinsert;
            int filled = handler.fill(copy, false);
            if (filled <= 0) continue;
            inserted.add(entry);
            if ((amount -= filled) > 0) continue;
            return 0;
        }
        return amount;
    }

    private int countFluid(IFluidHandler handler, @Nullable FluidStack matcher) {
        int cnt = 0;
        for (IFluidTankProperties properties : handler.getTankProperties()) {
            if (properties.getContents() == null || matcher != null && !matcher.equals((Object)properties.getContents())) continue;
            cnt += properties.getContents().amount;
        }
        return cnt;
    }

    private void insertFluidReal(@Nonnull IControllerContext context, @Nonnull List<Pair<SidedConsumer, FluidConnectorSettings>> inserted, @Nonnull FluidStack stack) {
        int amount = stack.amount;
        for (Pair<SidedConsumer, FluidConnectorSettings> pair : inserted) {
            BlockPos consumerPosition = context.findConsumerPosition(((SidedConsumer)pair.getKey()).getConsumerId());
            EnumFacing side = ((SidedConsumer)pair.getKey()).getSide();
            FluidConnectorSettings settings = (FluidConnectorSettings)pair.getValue();
            BlockPos pos = consumerPosition.func_177972_a(side);
            TileEntity te = context.getControllerWorld().func_175625_s(pos);
            IFluidHandler handler = FluidChannelSettings.getFluidHandlerAt(te, settings.getFacing());
            int toinsert = Math.min(settings.getRate(), amount);
            Integer count = settings.getMinmax();
            if (count != null) {
                int a = this.countFluid(handler, settings.getMatcher());
                int caninsert = count - a;
                if (caninsert <= 0) continue;
                toinsert = Math.min(toinsert, caninsert);
            }
            FluidStack copy = stack.copy();
            copy.amount = toinsert;
            int filled = handler.fill(copy, true);
            if (filled <= 0) continue;
            this.roundRobinOffset = (this.roundRobinOffset + 1) % this.fluidConsumers.size();
            if ((amount -= filled) > 0) continue;
            return;
        }
    }

    private void updateCache(int channel, IControllerContext context) {
        if (this.fluidExtractors == null) {
            FluidConnectorSettings con;
            this.fluidExtractors = new HashMap<SidedConsumer, FluidConnectorSettings>();
            this.fluidConsumers = new ArrayList<Pair<SidedConsumer, FluidConnectorSettings>>();
            Map<SidedConsumer, IConnectorSettings> connectors = context.getConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                con = (FluidConnectorSettings)entry.getValue();
                if (con.getFluidMode() == FluidConnectorSettings.FluidMode.EXT) {
                    this.fluidExtractors.put(entry.getKey(), con);
                    continue;
                }
                this.fluidConsumers.add((Pair<SidedConsumer, FluidConnectorSettings>)Pair.of((Object)entry.getKey(), (Object)con));
            }
            connectors = context.getRoutedConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                con = (FluidConnectorSettings)entry.getValue();
                if (con.getFluidMode() != FluidConnectorSettings.FluidMode.INS) continue;
                this.fluidConsumers.add((Pair<SidedConsumer, FluidConnectorSettings>)Pair.of((Object)entry.getKey(), (Object)con));
            }
            this.fluidConsumers.sort((o1, o2) -> ((FluidConnectorSettings)o2.getRight()).getPriority().compareTo(((FluidConnectorSettings)o1.getRight()).getPriority()));
        }
    }

    @Override
    public boolean isEnabled(String tag) {
        return true;
    }

    @Override
    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(iconGuiElements, 22, 80, 11, 10);
    }

    @Override
    @Nullable
    public String getIndicator() {
        return null;
    }

    @Override
    public void createGui(IEditorGui gui) {
        gui.nl().choices(TAG_MODE, "Fluid distribution mode", this.channelMode, ChannelMode.values());
    }

    @Override
    public void update(Map<String, Object> data) {
        this.channelMode = ChannelMode.valueOf(((String)data.get(TAG_MODE)).toUpperCase());
    }

    @Override
    public int getColors() {
        return 0;
    }

    @Nullable
    public static IFluidHandler getFluidHandlerAt(@Nullable TileEntity te, EnumFacing intSide) {
        IFluidHandler handler;
        if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, intSide) && (handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, intSide)) != null) {
            return handler;
        }
        return null;
    }

    public static enum ChannelMode {
        PRIORITY,
        DISTRIBUTE;

    }
}

