/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.modintegration.ftblib;

import com.feed_the_beast.ftblib.events.player.ForgePlayerLoggedInEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamPlayerJoinedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamPlayerLeftEvent;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.Universe;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import shetiphian.core.internal.modintegration.ftblib.FTBLib_Base;
import shetiphian.core.internal.network.NetworkHandler;
import shetiphian.core.internal.network.PacketFTBMyTeam;

public class FTBLib_v5_Active
extends FTBLib_Base {
    public static void init() {
        if (Universe.class != null) {
            FTBLib_Base.INSTANCE = new FTBLib_v5_Active();
            MinecraftForge.EVENT_BUS.register((Object)new FTBEventHandler());
        }
    }

    @Override
    public String getPlayerTeamID(EntityPlayer player) {
        if (player != null) {
            if (player.field_70170_p.field_72995_K) {
                return this.myTeam;
            }
            try {
                Universe universe = Universe.get();
                UUID uuid = player.func_110124_au();
                ForgePlayer forgePlayer = universe.getPlayer(uuid);
                if (forgePlayer != null) {
                    ForgeTeam team = forgePlayer.team;
                    return team != null ? team.toString() : "";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public String getTeamName(String teamID) {
        try {
            Universe universe = Universe.get();
            ForgeTeam team = universe.getTeam(teamID);
            return team != null ? team.getTitle().func_150254_d() : "";
        }
        catch (Exception exception) {
            return teamID;
        }
    }

    private static class FTBEventHandler {
        private FTBEventHandler() {
        }

        @SubscribeEvent
        public void forgePlayerLoggedIn(ForgePlayerLoggedInEvent event) {
            ForgePlayer forgePlayer = event.getPlayer();
            ForgeTeam team = forgePlayer.team;
            NetworkHandler.sendToPlayer(new PacketFTBMyTeam(team != null ? team.toString() : null), forgePlayer.getPlayer());
        }

        @SubscribeEvent
        public void forgeTeamPlayerJoined(ForgeTeamPlayerJoinedEvent event) {
            ForgePlayer forgePlayer = event.getPlayer();
            ForgeTeam team = event.getTeam();
            NetworkHandler.sendToPlayer(new PacketFTBMyTeam(team != null ? team.toString() : null), forgePlayer.getPlayer());
        }

        @SubscribeEvent
        public void forgeTeamPlayerLeft(ForgeTeamPlayerLeftEvent event) {
            ForgePlayer forgePlayer = event.getPlayer();
            NetworkHandler.sendToPlayer(new PacketFTBMyTeam(null), forgePlayer.getPlayer());
        }
    }
}

