/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.world.data;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.world.CachedWorldData;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.starlight.IIndependentStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.IStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.IStarlightTransmission;
import hellfirepvp.astralsorcery.common.starlight.WorldNetworkHandler;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightTransmissionHandler;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightUpdateHandler;
import hellfirepvp.astralsorcery.common.starlight.network.TransmissionWorldHandler;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionSource;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.SourceClassRegistry;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionClassRegistry;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class LightNetworkBuffer
extends CachedWorldData {
    private Map<ChunkPos, ChunkNetworkData> chunkSortedData = new HashMap<ChunkPos, ChunkNetworkData>();
    private Map<BlockPos, IIndependentStarlightSource> starlightSources = new HashMap<BlockPos, IIndependentStarlightSource>();
    private Collection<Tuple<BlockPos, IIndependentStarlightSource>> cachedSourceTuples = null;
    private List<ChunkPos> queueRemoval = new LinkedList<ChunkPos>();

    public LightNetworkBuffer() {
        super(WorldCacheManager.SaveKey.LIGHT_NETWORK);
    }

    public WorldNetworkHandler getNetworkHandler(World world) {
        return new WorldNetworkHandler(this, world);
    }

    @Override
    public void updateTick(World world) {
        this.cleanupQueuedChunks();
        TransmissionWorldHandler handle = StarlightTransmissionHandler.getInstance().getWorldHandler(world);
        Iterator<Map.Entry<BlockPos, IIndependentStarlightSource>> iterator = this.starlightSources.entrySet().iterator();
        while (iterator.hasNext()) {
            ChunkNetworkData data;
            TileEntity te;
            Map.Entry<BlockPos, IIndependentStarlightSource> entry = iterator.next();
            BlockPos pos = entry.getKey();
            ChunkPos chPos = new ChunkPos(pos);
            IIndependentStarlightSource source = entry.getValue();
            if (!MiscUtils.isChunkLoaded(world, chPos) || (te = world.func_175625_s(pos)) == null) continue;
            if (te instanceof IStarlightSource) {
                if (!((IStarlightSource)te).needToUpdateStarlightSource()) continue;
                source.informTileStateChange((IStarlightSource)te);
                ((IStarlightSource)te).markUpdated();
                if (handle == null) continue;
                handle.breakSourceNetwork(source);
                continue;
            }
            AstralSorcery.log.warn("Cached source at " + pos + " but didn't find the TileEntity!");
            AstralSorcery.log.warn("Purging cache entry and removing erroneous block!");
            IBlockState there = world.func_180495_p(pos);
            AstralSorcery.log.warn("Block that gets purged: " + there.func_177230_c().func_149739_a() + " with meta " + there.func_177230_c().func_176201_c(there));
            iterator.remove();
            if (!world.func_175698_g(pos) || (data = this.getChunkData(chPos)) == null) continue;
            data.removeSourceTile(pos);
        }
    }

    @Override
    public void onLoad(World world) {
        if (Config.performNetworkIntegrityCheck) {
            AstralSorcery.log.info("[LightNetworkIntegrityCheck] Performing StarlightNetwork integrity check for world " + world.field_73011_w.getDimension());
            LinkedList<IPrismTransmissionNode> invalidRemoval = new LinkedList<IPrismTransmissionNode>();
            for (ChunkNetworkData data : this.chunkSortedData.values()) {
                for (ChunkSectionNetworkData secData : data.sections.values()) {
                    for (IPrismTransmissionNode node : secData.getAllTransmissionNodes()) {
                        TileEntity te = world.func_175625_s(node.getLocationPos());
                        if (te == null || !(te instanceof IStarlightTransmission)) {
                            invalidRemoval.add(node);
                            continue;
                        }
                        IStarlightTransmission ism = (IStarlightTransmission)te;
                        IPrismTransmissionNode newNode = ism.provideTransmissionNode(node.getLocationPos());
                        if (!node.getClass().isAssignableFrom(newNode.getClass())) {
                            invalidRemoval.add(node);
                            continue;
                        }
                        if (node.needsUpdate()) {
                            StarlightUpdateHandler.getInstance().addNode(world, node);
                        }
                        node.postLoad(world);
                    }
                }
            }
            AstralSorcery.log.info("[LightNetworkIntegrityCheck] Performed StarlightNetwork integrity check. Found " + invalidRemoval.size() + " invalid transmission nodes.");
            for (IPrismTransmissionNode node : invalidRemoval) {
                this.removeTransmission(node.getLocationPos());
            }
            AstralSorcery.log.info("[LightNetworkIntegrityCheck] Removed invalid transmission nodes from the network.");
        } else {
            for (ChunkNetworkData data : this.chunkSortedData.values()) {
                for (ChunkSectionNetworkData secData : data.sections.values()) {
                    for (IPrismTransmissionNode node : secData.getAllTransmissionNodes()) {
                        if (node.needsUpdate()) {
                            StarlightUpdateHandler.getInstance().addNode(world, node);
                        }
                        node.postLoad(world);
                    }
                }
            }
        }
    }

    private void cleanupQueuedChunks() {
        for (ChunkPos pos : this.queueRemoval) {
            ChunkNetworkData data = this.getChunkData(pos);
            if (data == null || !data.isEmpty()) continue;
            this.chunkSortedData.remove(pos);
        }
        this.queueRemoval.clear();
    }

    @Nullable
    private ChunkNetworkData getChunkData(ChunkPos pos) {
        return this.chunkSortedData.get(pos);
    }

    @Nullable
    public ChunkSectionNetworkData getSectionData(BlockPos pos) {
        return this.getSectionData(new ChunkPos(pos), (pos.func_177956_o() & 0xFF) >> 4);
    }

    @Nullable
    public ChunkSectionNetworkData getSectionData(ChunkPos chPos, int yLevel) {
        ChunkNetworkData data = this.chunkSortedData.get(chPos);
        if (data == null) {
            return null;
        }
        return data.getSection(yLevel);
    }

    @Nullable
    public IIndependentStarlightSource getSource(BlockPos at) {
        return this.starlightSources.get(at);
    }

    public Collection<Tuple<BlockPos, IIndependentStarlightSource>> getAllSources() {
        if (this.cachedSourceTuples == null) {
            LinkedList<Tuple<BlockPos, IIndependentStarlightSource>> cache = new LinkedList<Tuple<BlockPos, IIndependentStarlightSource>>();
            for (Map.Entry<BlockPos, IIndependentStarlightSource> entry : this.starlightSources.entrySet()) {
                cache.add(new Tuple<BlockPos, IIndependentStarlightSource>(entry.getKey(), entry.getValue()));
            }
            this.cachedSourceTuples = Collections.unmodifiableCollection(cache);
        }
        return this.cachedSourceTuples;
    }

    public void createNewChunkData(@Nonnull ChunkPos pos) {
        this.chunkSortedData.put(pos, new ChunkNetworkData());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        int i;
        NBTTagList list;
        this.starlightSources.clear();
        this.chunkSortedData.clear();
        this.cachedSourceTuples = null;
        if (nbt.func_74764_b("chunkSortedData")) {
            list = nbt.func_150295_c("chunkSortedData", 10);
            for (i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound posTag = list.func_150305_b(i);
                int chX = posTag.func_74762_e("chX");
                int chZ = posTag.func_74762_e("chZ");
                ChunkPos pos = new ChunkPos(chX, chZ);
                ChunkNetworkData data = ChunkNetworkData.loadFromNBT(posTag.func_150295_c("netData", 10));
                this.chunkSortedData.put(pos, data);
            }
        }
        if (nbt.func_74764_b("sources")) {
            list = nbt.func_150295_c("sources", 10);
            for (i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound sourcePos = list.func_150305_b(i);
                BlockPos at = NBTHelper.readBlockPosFromNBT(sourcePos);
                ChunkSectionNetworkData section = this.getSectionData(at);
                if (section == null) {
                    AstralSorcery.log.warn("Expected source tile at " + at + " but didn't even find chunk section!");
                    continue;
                }
                IPrismTransmissionNode node = section.getTransmissionNode(at);
                if (node == null) {
                    AstralSorcery.log.warn("Expected source tile at " + at + " but didn't find a transmission node!");
                    continue;
                }
                if (!(node instanceof ITransmissionSource)) {
                    AstralSorcery.log.warn("Expected source tile at " + at + " but transmission node isn't a source!");
                    continue;
                }
                NBTTagCompound comp = sourcePos.func_74775_l("source");
                String identifier = comp.func_74779_i("sTypeId");
                SourceClassRegistry.SourceProvider provider = SourceClassRegistry.getProvider(identifier);
                if (provider == null) {
                    AstralSorcery.log.warn("Couldn't load source tile at " + at + " - invalid identifier: " + identifier);
                    continue;
                }
                IIndependentStarlightSource source = provider.provideEmptySource();
                source.readFromNBT(comp);
                this.starlightSources.put(at, source);
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        this.cleanupQueuedChunks();
        NBTTagList list = new NBTTagList();
        for (ChunkPos pos : this.chunkSortedData.keySet()) {
            ChunkNetworkData data = this.chunkSortedData.get(pos);
            NBTTagCompound posTag = new NBTTagCompound();
            posTag.func_74768_a("chX", pos.field_77276_a);
            posTag.func_74768_a("chZ", pos.field_77275_b);
            NBTTagList netData = new NBTTagList();
            data.writeToNBT(netData);
            posTag.func_74782_a("netData", (NBTBase)netData);
            list.func_74742_a((NBTBase)posTag);
        }
        nbt.func_74782_a("chunkSortedData", (NBTBase)list);
        NBTTagList sourceList = new NBTTagList();
        for (BlockPos pos : this.starlightSources.keySet()) {
            NBTTagCompound sourceTag = new NBTTagCompound();
            NBTHelper.writeBlockPosToNBT(pos, sourceTag);
            NBTTagCompound source = new NBTTagCompound();
            IIndependentStarlightSource sourceNode = this.starlightSources.get(pos);
            try {
                sourceNode.writeToNBT(source);
            }
            catch (Exception exc) {
                AstralSorcery.log.warn("Couldn't write source-node data for network node at " + pos.toString() + "!");
                AstralSorcery.log.warn("This is a major problem. To be perfectly save, consider making a backup, then break or mcedit the tileentity out and place a proper/new one...");
                continue;
            }
            source.func_74778_a("sTypeId", sourceNode.getProvider().getIdentifier());
            sourceTag.func_74782_a("source", (NBTBase)source);
            sourceList.func_74742_a((NBTBase)sourceTag);
        }
        nbt.func_74782_a("sources", (NBTBase)sourceList);
    }

    public void addSource(IStarlightSource source, BlockPos pos) {
        ChunkPos chPos = new ChunkPos(pos);
        ChunkNetworkData data = this.getChunkData(chPos);
        if (data == null) {
            this.createNewChunkData(chPos);
            data = this.getChunkData(chPos);
        }
        data.addSourceTile(pos, source);
        IIndependentStarlightSource newSource = this.addIndependentSource(pos, source);
        if (newSource != null) {
            Map<BlockPos, IIndependentStarlightSource> copyTr = Collections.unmodifiableMap(new HashMap<BlockPos, IIndependentStarlightSource>(this.starlightSources));
            Thread tr = new Thread(() -> this.threadedUpdateSourceProximity(copyTr));
            tr.setName("StarlightNetwork-UpdateThread");
            tr.start();
        }
        this.markDirty();
    }

    private void threadedUpdateSourceProximity(Map<BlockPos, IIndependentStarlightSource> copyTr) {
        try {
            for (Map.Entry<BlockPos, IIndependentStarlightSource> sourceTuple : copyTr.entrySet()) {
                sourceTuple.getValue().threadedUpdateProximity(sourceTuple.getKey(), copyTr);
            }
        }
        catch (Exception exc) {
            AstralSorcery.log.warn("Failed to update proximity status for source nodes.");
            exc.printStackTrace();
        }
    }

    public void addTransmission(IStarlightTransmission transmission, BlockPos pos) {
        ChunkPos chPos = new ChunkPos(pos);
        ChunkNetworkData data = this.getChunkData(chPos);
        if (data == null) {
            this.createNewChunkData(chPos);
            data = this.getChunkData(chPos);
        }
        data.addTransmissionTile(pos, transmission);
        this.markDirty();
    }

    public void removeSource(BlockPos pos) {
        ChunkPos chPos = new ChunkPos(pos);
        ChunkNetworkData data = this.getChunkData(chPos);
        if (data == null) {
            return;
        }
        data.removeSourceTile(pos);
        this.removeIndependentSource(pos);
        Map<BlockPos, IIndependentStarlightSource> copyTr = Collections.unmodifiableMap(new HashMap<BlockPos, IIndependentStarlightSource>(this.starlightSources));
        Thread tr = new Thread(() -> this.threadedUpdateSourceProximity(copyTr));
        tr.setName("StarlightNetwork-UpdateThread");
        tr.start();
        this.checkIntegrity(chPos);
        this.markDirty();
    }

    public void removeTransmission(BlockPos pos) {
        ChunkPos chPos = new ChunkPos(pos);
        ChunkNetworkData data = this.getChunkData(chPos);
        if (data == null) {
            return;
        }
        data.removeTransmissionTile(pos);
        this.checkIntegrity(chPos);
        this.markDirty();
    }

    private void checkIntegrity(ChunkPos chPos) {
        ChunkNetworkData data = this.getChunkData(chPos);
        if (data == null) {
            return;
        }
        data.checkIntegrity();
        if (data.isEmpty()) {
            this.queueRemoval.add(chPos);
        }
    }

    @Nullable
    private IIndependentStarlightSource addIndependentSource(BlockPos pos, IStarlightSource source) {
        this.cachedSourceTuples = null;
        IPrismTransmissionNode node = source.getNode();
        if (node instanceof ITransmissionSource) {
            IIndependentStarlightSource sourceNode = ((ITransmissionSource)node).provideNewIndependentSource(source);
            this.starlightSources.put(pos, sourceNode);
            return sourceNode;
        }
        return null;
    }

    private void removeIndependentSource(BlockPos pos) {
        this.starlightSources.remove(pos);
        this.cachedSourceTuples = null;
    }

    public static class ChunkSectionNetworkData {
        private Map<BlockPos, IPrismTransmissionNode> nodes = new HashMap<BlockPos, IPrismTransmissionNode>();

        private static ChunkSectionNetworkData loadFromNBT(NBTTagList sectionData) {
            ChunkSectionNetworkData netData = new ChunkSectionNetworkData();
            for (int i = 0; i < sectionData.func_74745_c(); ++i) {
                NBTTagCompound nodeComp = sectionData.func_150305_b(i);
                BlockPos pos = NBTHelper.readBlockPosFromNBT(nodeComp);
                NBTTagCompound prismComp = nodeComp.func_74775_l("nodeTag");
                String nodeIdentifier = prismComp.func_74779_i("trNodeId");
                TransmissionClassRegistry.TransmissionProvider provider = TransmissionClassRegistry.getProvider(nodeIdentifier);
                if (provider == null) {
                    AstralSorcery.log.warn("Couldn't load node tile at " + pos + " - invalid identifier: " + nodeIdentifier);
                    continue;
                }
                IPrismTransmissionNode node = provider.provideEmptyNode();
                node.readFromNBT(prismComp);
                netData.nodes.put(pos, node);
            }
            return netData;
        }

        private void writeToNBT(NBTTagList sectionData) {
            for (Map.Entry<BlockPos, IPrismTransmissionNode> node : this.nodes.entrySet()) {
                try {
                    NBTTagCompound nodeComp = new NBTTagCompound();
                    NBTHelper.writeBlockPosToNBT(node.getKey(), nodeComp);
                    NBTTagCompound prismComp = new NBTTagCompound();
                    IPrismTransmissionNode prismNode = node.getValue();
                    prismNode.writeToNBT(prismComp);
                    prismComp.func_74778_a("trNodeId", prismNode.getProvider().getIdentifier());
                    nodeComp.func_74782_a("nodeTag", (NBTBase)prismComp);
                    sectionData.func_74742_a((NBTBase)nodeComp);
                }
                catch (Exception exc) {
                    try {
                        BlockPos at = node.getKey();
                        AstralSorcery.log.warn("Couldn't write node data for network node at " + at.toString() + "!");
                        AstralSorcery.log.warn("This is a major problem. To be perfectly save, consider making a backup, then break or mcedit the tileentity out and place a proper/new one...");
                    }
                    catch (Exception exc2) {
                        try {
                            BlockPos at = node.getValue().getLocationPos();
                            AstralSorcery.log.warn("Couldn't write node data for network node at " + at.toString() + "!");
                            AstralSorcery.log.warn("This is a major problem. To be perfectly save, consider making a backup, then break or mcedit the tileentity out and place a proper/new one...");
                        }
                        catch (Exception exc3) {
                            AstralSorcery.log.warn("Couldn't write node data for a network node! Skipping...");
                        }
                    }
                }
            }
        }

        public boolean isEmpty() {
            return this.nodes.isEmpty();
        }

        public Collection<IPrismTransmissionNode> getAllTransmissionNodes() {
            return Collections.unmodifiableCollection(this.nodes.values());
        }

        @Nullable
        public IPrismTransmissionNode getTransmissionNode(BlockPos at) {
            return this.nodes.get(at);
        }

        private void removeSourceTile(BlockPos pos) {
            this.removeNode(pos);
        }

        private void removeTransmissionTile(BlockPos pos) {
            this.removeNode(pos);
        }

        private void removeNode(BlockPos pos) {
            this.nodes.remove(pos);
        }

        private void addSourceTile(BlockPos pos, IStarlightSource source) {
            this.addNode(pos, source);
        }

        private void addTransmissionTile(BlockPos pos, IStarlightTransmission transmission) {
            this.addNode(pos, transmission);
        }

        private void addNode(BlockPos pos, IStarlightTransmission transmission) {
            this.nodes.put(pos, transmission.provideTransmissionNode(pos));
        }
    }

    public static class ChunkNetworkData {
        private Map<Integer, ChunkSectionNetworkData> sections = new HashMap<Integer, ChunkSectionNetworkData>();

        private static ChunkNetworkData loadFromNBT(NBTTagList netData) {
            ChunkNetworkData data = new ChunkNetworkData();
            for (int i = 0; i < netData.func_74745_c(); ++i) {
                NBTTagCompound section = netData.func_150305_b(i);
                int yLevel = section.func_74762_e("yLevel");
                NBTTagList sectionData = section.func_150295_c("sectionData", 10);
                ChunkSectionNetworkData networkData = ChunkSectionNetworkData.loadFromNBT(sectionData);
                data.sections.put(yLevel, networkData);
            }
            return data;
        }

        private void writeToNBT(NBTTagList netData) {
            for (Integer yLevel : this.sections.keySet()) {
                ChunkSectionNetworkData sectionData = this.sections.get(yLevel);
                NBTTagList sectionTag = new NBTTagList();
                sectionData.writeToNBT(sectionTag);
                NBTTagCompound section = new NBTTagCompound();
                section.func_74768_a("yLevel", yLevel.intValue());
                section.func_74782_a("sectionData", (NBTBase)sectionTag);
                netData.func_74742_a((NBTBase)section);
            }
        }

        @Nullable
        public ChunkSectionNetworkData getSection(int yLevel) {
            return this.sections.get(yLevel);
        }

        public void checkIntegrity() {
            Iterator<Integer> iterator = this.sections.keySet().iterator();
            while (iterator.hasNext()) {
                Integer yLevel = iterator.next();
                ChunkSectionNetworkData data = this.sections.get(yLevel);
                if (!data.isEmpty()) continue;
                iterator.remove();
            }
        }

        public boolean isEmpty() {
            return this.sections.isEmpty();
        }

        private ChunkSectionNetworkData getOrCreateSection(int yLevel) {
            ChunkSectionNetworkData section = this.getSection(yLevel);
            if (section == null) {
                section = new ChunkSectionNetworkData();
                this.sections.put(yLevel, section);
            }
            return section;
        }

        private void removeSourceTile(BlockPos pos) {
            int yLevel = (pos.func_177956_o() & 0xFF) >> 4;
            ChunkSectionNetworkData section = this.getSection(yLevel);
            if (section == null) {
                return;
            }
            section.removeSourceTile(pos);
        }

        private void removeTransmissionTile(BlockPos pos) {
            int yLevel = (pos.func_177956_o() & 0xFF) >> 4;
            ChunkSectionNetworkData section = this.getSection(yLevel);
            if (section == null) {
                return;
            }
            section.removeTransmissionTile(pos);
        }

        private void addSourceTile(BlockPos pos, IStarlightSource source) {
            int yLevel = (pos.func_177956_o() & 0xFF) >> 4;
            ChunkSectionNetworkData section = this.getOrCreateSection(yLevel);
            section.addSourceTile(pos, source);
        }

        private void addTransmissionTile(BlockPos pos, IStarlightTransmission transmission) {
            int yLevel = (pos.func_177956_o() & 0xFF) >> 4;
            ChunkSectionNetworkData section = this.getOrCreateSection(yLevel);
            section.addTransmissionTile(pos, transmission);
        }
    }
}

