/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.item.upgrade;

import com.latmod.yabba.api.UpgradeData;
import com.latmod.yabba.item.upgrade.ItemUpgrade;
import com.latmod.yabba.tile.Barrel;
import com.latmod.yabba.tile.ItemBarrel;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemUpgradeSmelting
extends ItemUpgrade {
    @Override
    public UpgradeData initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new SmeltingUpgradeData(stack);
    }

    public static class SmeltingUpgradeData
    extends UpgradeData {
        public int progress = 0;

        public SmeltingUpgradeData(ItemStack is) {
            super(is);
        }

        @Override
        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74777_a("Progress", (short)this.progress);
            return nbt;
        }

        @Override
        public void deserializeNBT(NBTTagCompound nbt) {
            this.progress = nbt.func_74765_d("Progress");
        }

        @Override
        public void resetData() {
            this.progress = 0;
        }

        @Override
        public boolean canInsert(Barrel barrel, EntityPlayerMP player) {
            return barrel.content instanceof ItemBarrel;
        }

        @Override
        public boolean isTicking(World world) {
            return !world.field_72995_K;
        }

        @Override
        public void onTick(Barrel barrel) {
            TileEntity tileEntity = barrel.block.getBarrelTileEntity();
            if (tileEntity == null || !tileEntity.func_145830_o()) {
                return;
            }
            ++this.progress;
            if (this.progress > 400) {
                ItemStack stack;
                ItemBarrel itemBarrel = (ItemBarrel)barrel.content;
                if (itemBarrel.count > 0 && !(stack = FurnaceRecipes.func_77602_a().func_151395_a(itemBarrel.extractItem(1, 1, true))).func_190926_b()) {
                    itemBarrel.extractItem(1, 1, false);
                    World world = tileEntity.func_145831_w();
                    BlockPos pos = tileEntity.func_174877_v();
                    EnumFacing facing = barrel.block.getBarrelRotation();
                    double x = (double)pos.func_177958_n() + 0.5 + (double)facing.func_82601_c() * 0.63;
                    double y = (double)pos.func_177956_o() + 0.8;
                    double z = (double)pos.func_177952_p() + 0.5 + (double)facing.func_82599_e() * 0.63;
                    EntityItem itemEntity = new EntityItem(world, x, y, z, stack.func_77946_l());
                    itemEntity.field_70159_w = (double)facing.func_82601_c() * 0.1;
                    itemEntity.field_70181_x = 0.0;
                    itemEntity.field_70179_y = (double)facing.func_82599_e() * 0.1;
                    itemEntity.func_174867_a(3);
                    world.func_72838_d((Entity)itemEntity);
                }
                this.progress = 0;
            }
        }
    }
}

