/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbguides.integration;

import com.feed_the_beast.ftbguides.events.ClientGuideEvent;
import com.feed_the_beast.ftbguides.gui.GuidePage;
import com.feed_the_beast.ftbguides.gui.GuideTitlePage;
import com.feed_the_beast.ftbguides.gui.components.HRGuideComponent;
import com.feed_the_beast.ftbguides.gui.components.ImageGuideComponent;
import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.tools.TinkerMaterials;

@Mod.EventBusSubscriber(modid="ftbguides", value={Side.CLIENT})
public class TinkersConstructIntegration {
    @SubscribeEvent
    public static void onGuideEvent(ClientGuideEvent event) {
        if (Loader.isModLoaded((String)"tconstruct")) {
            TinkersConstructIntegration.onGuideEvent0(event);
        }
    }

    private static void onGuideEvent0(ClientGuideEvent event) {
        int i;
        GuideTitlePage page = event.getModPage("tconstruct");
        page.icon = ItemIcon.getItemIcon((String)"tconstruct:toolforge");
        page.println(HRGuideComponent.INSTANCE);
        GuidePage pageIntro = TinkersConstructIntegration.loadPage("intro", page);
        if (pageIntro != null) {
            pageIntro.title = new TextComponentString("Introduction");
            pageIntro.icon = ItemIcon.getItemIcon((String)"tconstruct:tooltables");
            page.addSub(pageIntro);
        }
        GuidePage toolMaterials = page.getSub("materials");
        toolMaterials.title = new TextComponentString("Materials");
        toolMaterials.icon = ItemIcon.getItemIcon((Item)Items.field_151035_b);
        ImmutableList mats = ImmutableList.of((Object)TinkerMaterials.wood, (Object)TinkerMaterials.cobalt, (Object)TinkerMaterials.ardite, (Object)TinkerMaterials.manyullyn);
        for (Object material : TinkerRegistry.getAllMaterials()) {
            if (material.isHidden() || !material.hasItems()) continue;
            GuidePage page1 = toolMaterials.getSub(material.getIdentifier());
            page1.icon = ItemIcon.getItemIcon((ItemStack)material.getRepresentativeItem());
            page1.title = new TextComponentString(material.getLocalizedName());
            for (IMaterialStats stats : material.getAllStats()) {
                TextComponentString component = new TextComponentString(stats.getLocalizedName());
                component.func_150256_b().func_150228_d(Boolean.valueOf(true));
                page1.println((ITextComponent)component);
                i = 0;
                for (IToolPart part : TinkerRegistry.getToolParts()) {
                    if (!part.hasUseForStat(stats.getIdentifier())) continue;
                    page1.components.add(new ImageGuideComponent(ItemIcon.getItemIcon((ItemStack)part.getItemstackWithMaterial((Material)material))));
                    if (++i % 8 != 0) continue;
                    page1.println("");
                }
                for (i = 0; i < stats.getLocalizedInfo().size(); ++i) {
                    TextComponentString component1 = new TextComponentString(TinkersConstructIntegration.transformString((String)stats.getLocalizedInfo().get(i)));
                    component1.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(TinkersConstructIntegration.transformString((String)stats.getLocalizedDesc().get(i)))));
                    page1.println((ITextComponent)component1);
                }
                page1.println("");
            }
        }
        GuidePage modifiers = page.getSub("modifiers");
        modifiers.title = new TextComponentString("Modifiers");
        modifiers.icon = ItemIcon.getItemIcon((Item)Items.field_151137_ax);
        for (IModifier modifier : TinkerRegistry.getAllModifiers()) {
            if (modifier.isHidden() || !modifier.hasItemsToApplyWith()) continue;
            try {
                JsonElement json = DataReader.get((IResource)Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("tconstruct", "book/en_US/modifiers/" + modifier.getIdentifier() + ".json"))).json();
                if (!json.isJsonObject()) continue;
                JsonObject o = json.getAsJsonObject();
                GuidePage page1 = modifiers.getSub(modifier.getIdentifier());
                page1.title = new TextComponentString(modifier.getLocalizedName());
                page1.println(TinkersConstructIntegration.transformString(modifier.getLocalizedDesc()));
                if (o.has("text")) {
                    page1.println("");
                    for (JsonElement e : o.get("text").getAsJsonArray()) {
                        page1.println(JsonUtils.deserializeTextComponent((JsonElement)e));
                    }
                }
                if (o.has("effects")) {
                    page1.println("");
                    page1.println("Effects:");
                    for (JsonElement e : o.get("effects").getAsJsonArray()) {
                        page1.println(JsonUtils.deserializeTextComponent((JsonElement)e));
                    }
                }
                if (!o.has("demoTool")) continue;
                i = 0;
                for (JsonElement e : o.get("demoTool").getAsJsonArray()) {
                    Item item = Item.func_111206_d((String)e.getAsString());
                    if (!(item instanceof ToolCore)) continue;
                    page1.components.add(new ImageGuideComponent(ItemIcon.getItemIcon((ItemStack)((ToolCore)item).buildItemForRendering((List)mats.subList(0, ((ToolCore)item).getRequiredComponents().size())))));
                    if (++i % 8 != 0) continue;
                    page1.println("");
                }
            }
            catch (Exception ex) {
                if (!FTBLibConfig.debugging.print_more_errors) continue;
                ex.printStackTrace();
            }
        }
        modifiers.sort(false);
        GuidePage pageSmeltry = TinkersConstructIntegration.loadPage("smeltery", page);
        if (pageSmeltry != null) {
            pageSmeltry.title = new TextComponentString("Smeltry");
            pageSmeltry.icon = ItemIcon.getItemIcon((String)"tconstruct:toolstation");
            page.addSub(pageSmeltry);
        }
    }

    private static String transformString(String s) {
        return s.replace("\\n", "\n").trim();
    }

    @Nullable
    private static GuidePage loadPage(String id, GuidePage p) {
        return null;
    }
}

