/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbguides.gui.components;

import com.feed_the_beast.ftbguides.gui.components.BulletGuideComponent;
import com.feed_the_beast.ftbguides.gui.components.EmptyGuideComponent;
import com.feed_the_beast.ftbguides.gui.components.GuideComponent;
import com.feed_the_beast.ftbguides.gui.components.TextGuideComponent;
import com.feed_the_beast.ftblib.lib.util.misc.NameMap;
import net.minecraft.util.IStringSerializable;

public enum ListOrdering implements IStringSerializable
{
    NONE("none"){
        private GuideComponent component = new TextGuideComponent("  ");

        @Override
        public GuideComponent createComponent(int index) {
            return this.component;
        }
    }
    ,
    BULLET("bullet"){

        @Override
        public GuideComponent createComponent(int index) {
            return BulletGuideComponent.INSTANCE;
        }
    }
    ,
    NUMBER("number"){

        @Override
        public GuideComponent createComponent(int index) {
            return index < 0 ? BulletGuideComponent.INSTANCE : new TextGuideComponent(Integer.toString(index));
        }
    }
    ,
    LETTER("letter"){
        private TextGuideComponent[] components;

        @Override
        public GuideComponent createComponent(int index) {
            if (this.components == null) {
                int s = 26;
                this.components = new TextGuideComponent[s * 2];
                for (int i = 0; i < s; ++i) {
                    this.components[i] = new TextGuideComponent(Character.toString((char)(97 + index)));
                    this.components[i + s] = new TextGuideComponent(Character.toString((char)(65 + index)));
                }
            }
            return index < 0 || index >= this.components.length ? BulletGuideComponent.INSTANCE : this.components[index];
        }
    };

    public static final NameMap<ListOrdering> NAME_MAP;
    private final String name;

    private ListOrdering(String n2) {
        this.name = n2;
    }

    public String func_176610_l() {
        return this.name;
    }

    public GuideComponent createComponent(int index) {
        return EmptyGuideComponent.INSTANCE;
    }

    static {
        NAME_MAP = NameMap.create((Object)((Object)BULLET), (Object[])ListOrdering.values());
    }
}

