/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbguides.gui;

import com.feed_the_beast.ftbguides.client.FTBGuidesClientConfig;
import com.feed_the_beast.ftbguides.client.GuideTheme;
import com.feed_the_beast.ftbguides.gui.GuideType;
import com.feed_the_beast.ftbguides.gui.SpecialGuideButton;
import com.feed_the_beast.ftbguides.gui.components.GuideComponent;
import com.feed_the_beast.ftbguides.gui.components.ImageGuideComponent;
import com.feed_the_beast.ftbguides.gui.components.LineBreakGuideComponent;
import com.feed_the_beast.ftbguides.gui.components.TextGuideComponent;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.icon.URLImageIcon;
import com.feed_the_beast.ftblib.lib.util.FinalIDObject;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class GuidePage
extends FinalIDObject
implements Comparable<GuidePage> {
    public static final Icon DEFAULT_ICON = ItemIcon.getItemIcon((Item)Items.field_151122_aG);
    public static final Collection<String> STANDARD_KEYS = new HashSet<String>(Arrays.asList("id", "title", "icon", "icon_url", "buttons", "pages"));
    public static final int STATE_NOT_LOADING = 0;
    public static final int STATE_LOADING = 1;
    public static final int STATE_LOADED = 2;
    public final GuidePage parent;
    public final List<GuideComponent> components = new ArrayList<GuideComponent>();
    public final List<GuidePage> pages = new ArrayList<GuidePage>(0);
    public ITextComponent title;
    public Icon icon = DEFAULT_ICON;
    public final List<SpecialGuideButton> specialButtons = new ArrayList<SpecialGuideButton>(0);
    public URI textURI = null;
    public int textLoadingState = 0;
    public final HashMap<String, JsonElement> properties = new HashMap();
    public GuideType type = GuideType.OTHER;
    public Icon background = Icon.EMPTY;
    public Color4I textColor = Icon.EMPTY;
    public Color4I textColorMouseOver = Icon.EMPTY;
    public Color4I lineColor = Icon.EMPTY;

    public GuidePage(String id, @Nullable GuidePage p) {
        super(id);
        this.parent = p;
    }

    public String getPath() {
        return this.parent == null ? "/" : this.parent.getPath() + this.getID() + '/';
    }

    public GuidePage getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }

    public ITextComponent getDisplayName() {
        return this.title == null ? new TextComponentString(this.getID()) : this.title;
    }

    public void println(GuideComponent component) {
        if (!this.components.isEmpty() && component.isInline()) {
            this.components.add(LineBreakGuideComponent.INSTANCE);
        }
        this.components.add(component);
    }

    public void println(String text) {
        this.println(new TextGuideComponent(text));
    }

    public void println(Icon icon) {
        this.println(new ImageGuideComponent(icon));
    }

    public void println(@Nullable ITextComponent component) {
        if (component != null) {
            for (ITextComponent c : component) {
                TextGuideComponent t = new TextGuideComponent(c.func_150261_e());
                this.components.add(t);
            }
        }
        this.components.add(LineBreakGuideComponent.INSTANCE);
    }

    public GuidePage addSub(GuidePage c) {
        Objects.requireNonNull(c, "Page can't be null!");
        this.pages.remove(c);
        this.pages.add(c);
        return c;
    }

    @Nullable
    public GuidePage getSubRaw(String id) {
        for (GuidePage p : this.pages) {
            if (!p.getID().equalsIgnoreCase(id)) continue;
            return p;
        }
        return null;
    }

    public GuidePage getSub(String id) {
        GuidePage p = this.getSubRaw(id);
        if (p == null) {
            p = this.addSub(new GuidePage(id, this));
        }
        return p;
    }

    @Nullable
    public GuidePage getSubFromPath(String path) {
        if (path.isEmpty()) {
            return this;
        }
        int i = path.indexOf(47);
        if (i == -1) {
            return this.getSubRaw(path);
        }
        if (i == 0) {
            return path.length() == 1 ? this.getRoot() : this.getRoot().getSubFromPath(path.substring(1));
        }
        if (i == path.length() - 1) {
            return this.getSubFromPath(path.substring(0, path.length() - 1));
        }
        String s = path.substring(0, i);
        String path1 = path.substring(i + 1);
        if (s.equals(".")) {
            return this.getSubFromPath(path1);
        }
        if (s.equals("..")) {
            return (this.parent == null ? this : this.parent).getSubFromPath(path1);
        }
        GuidePage page1 = this.getSubRaw(s);
        return page1 == null ? null : page1.getSubFromPath(path1);
    }

    public void clear() {
        this.components.clear();
        this.pages.clear();
        this.properties.clear();
    }

    public void cleanup() {
        this.pages.forEach(GuidePage::cleanup);
        this.pages.removeIf(GuidePage::isEmpty);
    }

    public boolean isEmpty() {
        if (!this.pages.isEmpty()) {
            return false;
        }
        for (GuideComponent component : this.components) {
            if (component.isEmpty()) continue;
            return false;
        }
        return this.textURI == null;
    }

    public void sort(boolean tree) {
        this.pages.sort(null);
        if (tree) {
            for (GuidePage p : this.pages) {
                p.sort(true);
            }
        }
    }

    public void readProperties(JsonObject json) {
        this.properties.clear();
        for (Map.Entry entry : json.entrySet()) {
            if (STANDARD_KEYS.contains(entry.getKey())) continue;
            this.properties.put((String)entry.getKey(), (JsonElement)(entry.getValue() == null ? JsonNull.INSTANCE : (JsonElement)entry.getValue()));
        }
    }

    public final JsonElement getProperty(String key) {
        JsonElement json = this.properties.get(key);
        return json == null ? (this.parent == null ? JsonNull.INSTANCE : this.parent.getProperty(key)) : json;
    }

    public void updateCachedProperties(boolean tree) {
        GuideTheme theme = GuideTheme.get(FTBGuidesClientConfig.general.theme);
        JsonElement e = this.getProperty("background");
        this.background = JsonUtils.isNull((JsonElement)e) ? theme.background : Icon.getIcon((JsonElement)e);
        e = this.getProperty("text_color");
        this.textColor = JsonUtils.isNull((JsonElement)e) ? theme.text : Color4I.fromJson((JsonElement)this.getProperty("text_color"));
        e = this.getProperty("text_color_mouse_over");
        this.textColorMouseOver = JsonUtils.isNull((JsonElement)e) ? theme.textMouseOver : Color4I.fromJson((JsonElement)this.getProperty("text_color_mouse_over"));
        e = this.getProperty("line_color");
        Color4I color4I = this.lineColor = JsonUtils.isNull((JsonElement)e) ? theme.lines : Color4I.fromJson((JsonElement)this.getProperty("line_color"));
        if (tree) {
            for (GuidePage page : this.pages) {
                page.updateCachedProperties(true);
            }
        }
    }

    public Icon getIcon(String path) {
        if (path.indexOf(58) == -1 && this.textURI != null) {
            return new URLImageIcon(this.textURI.resolve("./" + path));
        }
        return Icon.getIcon((String)path);
    }

    @Override
    public int compareTo(GuidePage o) {
        int i = this.type.compareTo(o.type);
        return i == 0 ? this.getDisplayName().func_150260_c().compareToIgnoreCase(o.getDisplayName().func_150260_c()) : i;
    }
}

