/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.patch;

import com.therandomlabs.randompatches.core.Patch;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class EntityPatch
extends Patch {
    public static final String ENTITYPATCH = EntityPatch.getName(EntityPatch.class);
    public static final String SET_POSITION = EntityPatch.getName("setPosition", "func_70107_b");

    @Override
    public boolean apply(ClassNode node) {
        EntityPatch.patchWriteToNBT(EntityPatch.findMethod(node, "writeToNBT", "func_189511_e"));
        EntityPatch.patchReadFromNBT(EntityPatch.findMethod(node, "readFromNBT", "func_70020_e"));
        return true;
    }

    public static void writeAABBTag(Entity entity, NBTTagCompound compound) {
        AxisAlignedBB aabb = entity.func_174813_aQ();
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagDouble(aabb.field_72340_a - entity.field_70165_t));
        list.func_74742_a((NBTBase)new NBTTagDouble(aabb.field_72338_b - entity.field_70163_u));
        list.func_74742_a((NBTBase)new NBTTagDouble(aabb.field_72339_c - entity.field_70161_v));
        list.func_74742_a((NBTBase)new NBTTagDouble(aabb.field_72336_d - entity.field_70165_t));
        list.func_74742_a((NBTBase)new NBTTagDouble(aabb.field_72337_e - entity.field_70163_u));
        list.func_74742_a((NBTBase)new NBTTagDouble(aabb.field_72334_f - entity.field_70161_v));
        compound.func_74782_a("RelativeAABB", (NBTBase)list);
    }

    public static void readAABBTag(Entity entity, NBTTagCompound compound) {
        if (!compound.func_74764_b("RelativeAABB")) {
            return;
        }
        NBTTagList aabb = compound.func_150295_c("RelativeAABB", 6);
        entity.func_174826_a(new AxisAlignedBB(entity.field_70165_t + aabb.func_150309_d(0), entity.field_70163_u + aabb.func_150309_d(1), entity.field_70161_v + aabb.func_150309_d(2), entity.field_70165_t + aabb.func_150309_d(3), entity.field_70163_u + aabb.func_150309_d(4), entity.field_70161_v + aabb.func_150309_d(5)));
    }

    private static void patchWriteToNBT(MethodNode method) {
        MethodInsnNode setTag = null;
        for (int i = 0; i < method.instructions.size(); ++i) {
            AbstractInsnNode instruction = method.instructions.get(i);
            if (instruction.getOpcode() != 182) continue;
            setTag = (MethodInsnNode)instruction;
            if ("net/minecraft/nbt/NBTTagCompound".equals(setTag.owner)) break;
            setTag = null;
        }
        VarInsnNode loadThis = new VarInsnNode(25, 0);
        VarInsnNode loadCompound = new VarInsnNode(25, 1);
        MethodInsnNode writeAABBTag = new MethodInsnNode(184, ENTITYPATCH, "writeAABBTag", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/nbt/NBTTagCompound;)V", false);
        method.instructions.insert((AbstractInsnNode)setTag, (AbstractInsnNode)loadThis);
        method.instructions.insert((AbstractInsnNode)loadThis, (AbstractInsnNode)loadCompound);
        method.instructions.insert((AbstractInsnNode)loadCompound, (AbstractInsnNode)writeAABBTag);
    }

    private static void patchReadFromNBT(MethodNode method) {
        LabelNode jumpTo;
        JumpInsnNode jumpIfShouldNotSetPosition = null;
        MethodInsnNode setPosition = null;
        for (int i = method.instructions.size() - 1; i >= 0; --i) {
            AbstractInsnNode instruction = method.instructions.get(i);
            if (setPosition == null) {
                if (instruction.getOpcode() != 182) continue;
                setPosition = (MethodInsnNode)instruction;
                if (SET_POSITION.equals(setPosition.name)) continue;
                setPosition = null;
                continue;
            }
            if (instruction.getOpcode() != 153) continue;
            jumpIfShouldNotSetPosition = (JumpInsnNode)instruction;
            break;
        }
        jumpIfShouldNotSetPosition.label = jumpTo = new LabelNode();
        VarInsnNode loadThis = new VarInsnNode(25, 0);
        VarInsnNode loadCompound = new VarInsnNode(25, 1);
        MethodInsnNode readAABBTag = new MethodInsnNode(184, ENTITYPATCH, "readAABBTag", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/nbt/NBTTagCompound;)V", false);
        method.instructions.insert((AbstractInsnNode)setPosition, (AbstractInsnNode)jumpTo);
        method.instructions.insert((AbstractInsnNode)jumpTo, (AbstractInsnNode)loadThis);
        method.instructions.insert((AbstractInsnNode)loadThis, (AbstractInsnNode)loadCompound);
        method.instructions.insert((AbstractInsnNode)loadCompound, (AbstractInsnNode)readAABBTag);
    }
}

