/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.config;

import com.therandomlabs.randompatches.RandomPatches;
import com.therandomlabs.randompatches.client.WindowIconHandler;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.randomlib.TRLUtils;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.randomlib.config.Config;
import org.lwjgl.opengl.Display;

@Config(value="randompatches")
public final class RPConfig {
    @Config.Category(value={"Options related to boats."})
    public static final Boats boats = null;
    @Config.Category(value={"Options related to client-sided features."})
    public static final Client client = null;
    @Config.Category(value={"Options that don't fit into any other categories."})
    public static final Misc misc = null;
    @Config.Category(value={"Options related to the movement speed limits."})
    public static final SpeedLimits speedLimits = null;
    @Config.Category(value={"Options related to the disconnect timeouts."})
    public static final Timeouts timeouts = null;

    public static final class Window {
        public static final String DEFAULT_ICON;
        @Config.Property(value={"The path to the 16x16 Minecraft window icon.", "Leave this and the 32x32 icon blank to use the default icon."})
        public static String icon16;
        @Config.Property(value={"The path to the 32x32 Minecraft window icon.", "Leave this and the 16x16 icon blank to use the default icon."})
        public static String icon32;
        @Config.Property(value={"The Minecraft window title."})
        public static String title;
        public static boolean setWindowSettings;

        public static void onReload() {
            if (icon16.isEmpty() && !icon32.isEmpty()) {
                icon16 = icon32;
            }
            if (icon32.isEmpty() && !icon16.isEmpty()) {
                icon32 = icon16;
            }
        }

        public static void onReloadClient() {
            if (!Display.isCreated() || RandomPatches.ITLT_INSTALLED) {
                return;
            }
            WindowIconHandler.setWindowIcon();
            Display.setTitle((String)title);
        }

        static {
            icon16 = DEFAULT_ICON = RandomPatches.IS_DEOBFUSCATED ? "../src/main/resources/assets/randompatches/logo.png" : "";
            icon32 = DEFAULT_ICON;
            title = RandomPatches.IS_DEOBFUSCATED ? "RandomPatches" : RandomPatches.DEFAULT_WINDOW_TITLE;
            setWindowSettings = true;
        }
    }

    public static final class Timeouts {
        @Config.RangeInt(min=1)
        @Config.Property(value={"The interval at which the server sends the KeepAlive packet."})
        public static int keepAlivePacketInterval = 15;
        @Config.RangeInt(min=1)
        @Config.Property(value={"The login timeout."})
        public static int loginTimeout = 900;
        @Config.RequiresMCRestart
        @Config.Property(value={"Whether to apply the login timeout."})
        public static boolean patchLoginTimeout = true;
        @Config.RangeInt(min=1)
        @Config.Property(value={"The read timeout.", "This is the time it takes for a player to be disconnected after not responding to a KeepAlive packet.", "This value is automatically rounded up to a product of keepAlivePacketInterval.", "This only works on 1.12 and above."})
        public static int readTimeout = 90;
        public static long keepAlivePacketIntervalMillis;
        public static long keepAlivePacketIntervalLong;
        public static long readTimeoutMillis;

        public static void onReload() {
            if (readTimeout < keepAlivePacketInterval) {
                readTimeout = keepAlivePacketInterval * 2;
            } else if (readTimeout % keepAlivePacketInterval != 0) {
                readTimeout = keepAlivePacketInterval * (readTimeout / keepAlivePacketInterval + 1);
            }
            keepAlivePacketIntervalMillis = (long)keepAlivePacketInterval * 1000L;
            keepAlivePacketIntervalLong = keepAlivePacketInterval;
            readTimeoutMillis = (long)readTimeout * 1000L;
            System.setProperty("fml.readTimeout", Integer.toString(readTimeout));
            System.setProperty("fml.loginTimeout", Integer.toString(loginTimeout));
        }
    }

    public static final class SpeedLimits {
        @Config.RangeDouble(min=1.0)
        @Config.Property(value={"The maximum player speed.", "The vanilla default is 100.0."})
        public static float maxPlayerSpeed = 1000000.0f;
        @Config.RangeDouble(min=1.0)
        @Config.Property(value={"The maximum player elytra speed.", "The vanilla default is 300.0."})
        public static float maxPlayerElytraSpeed = 1000000.0f;
        @Config.RangeDouble(min=1.0)
        @Config.Property(value={"The maximum player vehicle speed.", "The vanilla default is 100.0."})
        public static double maxPlayerVehicleSpeed = 1000000.0;
    }

    public static final class Misc {
        @Config.RequiresMCRestart
        @Config.Property(value={"Fixes the End portal and End gateway break particle textures and improves End portal rendering.", "This only works on Minecraft 1.11 and above."})
        public static boolean endPortalTweaks = true;
        @Config.RequiresMCRestart
        @Config.Property(value={"Fixes MC-2025.", "This only works on 1.10 and above.", "More information can be found here: https://www.reddit.com/r/Mojira/comments/8pgd4q/final_and_proper_fix_to_mc2025_simple_reliable/"})
        public static boolean mc2025Fix = true;
        @Config.RequiresMCRestart
        @Config.Property(value={"Fixes MC-64836, which causes non-player entities to be allowed to control minecarts using their AI."})
        public static boolean minecartAIFix = true;
        @Config.RequiresMCRestart
        @Config.Property(value={"Set this to false to disable the NetHandlerPlayServer patches (the speed limits and disconnect timeouts).", "On 1.8, 1.8.8 and 1.8.9, these patches are always disabled."})
        public static boolean patchNetHandlerPlayServer = true;
        @Config.RequiresMCRestart
        @Config.Property(value={"Fixes MC-11944, which allows players to replace End portals, End gateways and Nether portals using buckets."})
        public static boolean portalBucketReplacementFix = true;
        @Config.Property(value={"Enables the portal bucket replacement fix for Nether portals."})
        public static boolean portalBucketReplacementFixForNetherPortals;
        @Config.RequiresMCRestart
        @Config.Property(value={"Fixes MC-129057, which prevents ingredients with NBT data from being transferred to the crafting grid when a recipe is clicked in the recipe book."})
        public static boolean recipeBookNBTFix;
        @Config.RequiresMCRestart
        @Config.Property(value={"Whether to allow other mods (namely RandomPortals) to replace the default Teleporter on 1.12."})
        public static boolean replaceTeleporter;
        @Config.RequiresWorldReload
        @Config.Property(value={"Enables the /rpreload command."})
        public static boolean rpreload;
        @Config.RequiresMCRestart
        @Config.Property(value={"Fixes player skull stacking."})
        public static boolean skullStackingFix;
        @Config.Property(value={"Whether skull stacking requires the same textures or just the same player profile."})
        public static boolean skullStackingRequiresSameTextures;

        public static boolean areEndPortalTweaksEnabled() {
            return endPortalTweaks && TRLUtils.MC_VERSION_NUMBER > 10 && TRLUtils.IS_CLIENT;
        }

        public static boolean isRecipeBookNBTFixEnabled() {
            return recipeBookNBTFix && TRLUtils.MC_VERSION_NUMBER > 11 && !RandomPatches.VANILLAFIX_INSTALLED;
        }

        static {
            recipeBookNBTFix = true;
            replaceTeleporter = true;
            rpreload = true;
            skullStackingFix = true;
            skullStackingRequiresSameTextures = true;
        }
    }

    public static final class Client {
        @Config.Category(value={"Options related to the Minecraft window."})
        public static final Window window = null;
        @Config.RequiresMCRestart
        @Config.Property(value={"Speeds up language switching."})
        public static boolean fastLanguageSwitch = true;
        @Config.Property(value={"Forces Minecraft to show the title screen after disconnecting rather than the Multiplayer or Realms menu."})
        public static boolean forceTitleScreenOnDisconnect = RandomPatches.IS_DEOBFUSCATED;
        @Config.RequiresMCRestart
        @Config.Property(value={"Whether to add the Toggle Narrator keybind to the controls.", "This only works on 1.12 as the narrator does not exist in previous versions."})
        public static boolean narratorKeybind = true;
        @Config.RequiresMCRestart
        @Config.Property(value={"Set this to false to disable the Minecraft class patches (the Toggle Narrator keybind and custom window title/icon)."})
        public static boolean patchMinecraftClass = true;
        @Config.RequiresMCRestart
        @Config.Property(value={"Set this to false to force disable the \"force title screen on disconnect\" patch."})
        public static boolean patchTitleScreenOnDisconnect = true;
        @Config.RequiresMCRestart
        @Config.Property(value={"Whether to apply the potion glint patch so that the potion glowing effect can be toggled."})
        public static boolean patchPotionGlint = true;
        @Config.Property(value={"Whether to remove the glowing effect from potions."})
        public static boolean removePotionGlint = RandomPatches.IS_DEOBFUSCATED;
        @Config.RequiresWorldReload
        @Config.Property(value={"Enables the /rpreloadclient command."})
        public static boolean rpreloadclient = true;

        public static boolean isNarratorKeybindEnabled() {
            return narratorKeybind && TRLUtils.MC_VERSION_NUMBER > 11 && !RandomPatches.REBIND_INSTALLED && !RandomPatches.REBIND_NARRATOR_INSTALLED && TRLUtils.IS_CLIENT;
        }
    }

    public static final class Boats {
        @Config.RequiresMCRestart
        @Config.Property(value={"Whether to patch EntityBoat.", "This only works on 1.9 and above."})
        public static boolean patchEntityBoat = true;
        @Config.Property(value={"Prevents underwater boat passengers from being ejected after 60 ticks (3 seconds)."})
        public static boolean preventUnderwaterBoatPassengerEjection = RandomPatches.IS_DEOBFUSCATED;
        @Config.Property(value={"The buoyancy of boats when they are under flowing water.", "The vanilla default is -0.0007."})
        public static double underwaterBoatBuoyancy = RandomPatches.IS_DEOBFUSCATED ? 5.0 : 0.023;
    }
}

