/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.soul;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import WayofTime.bloodmagic.entity.mob.EntitySentientSpecter;
import WayofTime.bloodmagic.entity.projectile.EntitySentientArrow;
import WayofTime.bloodmagic.iface.IMultiWillTool;
import WayofTime.bloodmagic.iface.ISentientTool;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.soul.PlayerDemonWillHandler;
import WayofTime.bloodmagic.util.helper.NBTHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSentientBow
extends ItemBow
implements IMultiWillTool,
ISentientTool,
IVariantProvider {
    public static int[] soulBracket = new int[]{16, 60, 200, 400, 1000, 2000, 4000};
    public static double[] defaultDamageAdded = new double[]{0.25, 0.5, 0.75, 1.0, 1.25, 1.5, 1.75};
    public static float[] velocityAdded = new float[]{0.25f, 0.5f, 0.75f, 1.0f, 1.25f, 1.5f, 1.75f};
    public static double[] soulDrainPerSwing = new double[]{0.05, 0.1, 0.2, 0.4, 0.75, 1.0, 1.5};
    public static double[] soulDrop = new double[]{2.0, 4.0, 7.0, 10.0, 13.0, 16.0, 24.0};
    public static double[] staticDrop = new double[]{1.0, 1.0, 2.0, 3.0, 3.0, 3.0, 4.0};
    public static float soullessShotVelocity = 2.5f;

    public ItemSentientBow() {
        this.func_77655_b("bloodmagic.sentientBow");
        this.func_77637_a(BloodMagic.TAB_BM);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World world, EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                return !itemstack.func_190926_b() && itemstack.func_77973_b() == RegistrarBloodMagicItems.SENTIENT_BOW ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World world, EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("type"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World world, EntityLivingBase entityIn) {
                return ((ItemSentientBow)RegistrarBloodMagicItems.SENTIENT_BOW).getCurrentType(stack).ordinal();
            }
        });
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return RegistrarBloodMagicItems.ITEM_DEMON_CRYSTAL == repair.func_77973_b() || super.func_82789_a(toRepair, repair);
    }

    public void recalculatePowers(ItemStack stack, World world, EntityPlayer player) {
        EnumDemonWillType type = PlayerDemonWillHandler.getLargestWillType(player);
        double soulsRemaining = PlayerDemonWillHandler.getTotalDemonWill(type, player);
        this.recalculatePowers(stack, type, soulsRemaining);
    }

    public void recalculatePowers(ItemStack stack, EnumDemonWillType type, double will) {
        this.setCurrentType(stack, will > 0.0 ? type : EnumDemonWillType.DEFAULT);
        int level = this.getLevel(will);
        double drain = level >= 0 ? soulDrainPerSwing[level] : 0.0;
        this.setDrainOfActivatedBow(stack, drain);
        this.setStaticDropOfActivatedBow(stack, level >= 0 ? staticDrop[level] : 1.0);
        this.setDropOfActivatedBow(stack, level >= 0 ? soulDrop[level] : 0.0);
        this.setVelocityOfArrow(stack, level >= 0 ? 3.0f + this.getVelocityModifier(type, level) : soullessShotVelocity);
        this.setDamageAdded(stack, level >= 0 ? this.getDamageModifier(type, level) : 0.0);
    }

    private int getLevel(double soulsRemaining) {
        int lvl = -1;
        for (int i = 0; i < soulBracket.length; ++i) {
            if (!(soulsRemaining >= (double)soulBracket[i])) continue;
            lvl = i;
        }
        return lvl;
    }

    @Override
    public EnumDemonWillType getCurrentType(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        if (!tag.func_74764_b("demonWillType")) {
            return EnumDemonWillType.DEFAULT;
        }
        return EnumDemonWillType.valueOf(tag.func_74779_i("demonWillType").toUpperCase(Locale.ENGLISH));
    }

    public double getDamageModifier(EnumDemonWillType type, int willBracket) {
        switch (type) {
            case VENGEFUL: {
                return 0.0;
            }
            case DEFAULT: 
            case CORROSIVE: 
            case DESTRUCTIVE: 
            case STEADFAST: {
                return defaultDamageAdded[willBracket];
            }
        }
        return 0.0;
    }

    public float getVelocityModifier(EnumDemonWillType type, int willBracket) {
        switch (type) {
            case VENGEFUL: {
                return velocityAdded[willBracket];
            }
        }
        return 0.0f;
    }

    public void setDamageAdded(ItemStack stack, double damage) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74780_a("damage", damage);
    }

    public double getDamageAdded(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74769_h("damage");
    }

    public void setVelocityOfArrow(ItemStack stack, float velocity) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74776_a("velocity", velocity);
    }

    public float getVelocityOfArrow(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        if (tag.func_74764_b("velocity")) {
            return tag.func_74760_g("velocity");
        }
        return 3.0f;
    }

    public void setCurrentType(ItemStack stack, EnumDemonWillType type) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74778_a("demonWillType", type.toString());
    }

    public double getDrainOfActivatedBow(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordActiveDrain");
    }

    public void setDrainOfActivatedBow(ItemStack stack, double drain) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordActiveDrain", drain);
    }

    public double getStaticDropOfActivatedBow(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordStaticDrop");
    }

    public void setStaticDropOfActivatedBow(ItemStack stack, double drop) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordStaticDrop", drop);
    }

    public double getDropOfActivatedBow(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordDrop");
    }

    public void setDropOfActivatedBow(ItemStack stack, double drop) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordDrop", drop);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        this.recalculatePowers(stack, world, player);
        return super.func_77659_a(world, player, hand);
    }

    @Override
    public void gatherVariants(@Nonnull Int2ObjectMap<String> variants) {
        variants.put(0, (Object)"inventory");
    }

    public EntityTippedArrow getArrowEntity(World world, ItemStack stack, EntityLivingBase target, EntityLivingBase user, float velocity) {
        EnumDemonWillType type = this.getCurrentType(stack);
        double amount = user instanceof EntityPlayer ? this.getDropOfActivatedBow(stack) * world.field_73012_v.nextDouble() + this.getStaticDropOfActivatedBow(stack) : 0.0;
        float newArrowVelocity = velocity * this.getVelocityOfArrow(stack);
        double soulsRemaining = user instanceof EntityPlayer ? PlayerDemonWillHandler.getTotalDemonWill(type, (EntityPlayer)user) : 0.0;
        EntitySentientArrow entityArrow = new EntitySentientArrow(world, user, type, amount, this.getLevel(soulsRemaining), (PotionType)null);
        double d0 = target.field_70165_t - user.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityArrow.field_70163_u;
        double d2 = target.field_70161_v - user.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityArrow.func_70186_c(d0, d1 + d3 * 0.05, d2, newArrowVelocity, 0.0f);
        if (newArrowVelocity == 0.0f) {
            world.func_184133_a(null, user.func_180425_c(), SoundEvents.field_187646_bt, SoundCategory.NEUTRAL, 0.4f, 1.0f);
            return null;
        }
        if (velocity == 1.0f) {
            entityArrow.func_70243_d(true);
        }
        int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
        entityArrow.func_70239_b(entityArrow.func_70242_d() + this.getDamageAdded(stack) + (j > 0 ? (double)j * 0.5 + 0.5 : 0.0));
        int k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack);
        if (k > 0) {
            entityArrow.func_70240_a(k);
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
            entityArrow.func_70015_d(100);
        }
        entityArrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
        return entityArrow;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            boolean flag = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack itemstack = this.getFiredArrow(player);
            int i = this.func_77626_a(stack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)((EntityPlayer)entityLiving), (int)i, (itemstack != null || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (itemstack != null || flag) {
                float arrowVelocity;
                if (itemstack == null) {
                    itemstack = new ItemStack(Items.field_151032_g);
                }
                if ((double)(arrowVelocity = ItemSentientBow.func_185059_b((int)i)) >= 0.1) {
                    boolean flag1;
                    boolean bl = flag1 = flag && itemstack.func_77973_b() == Items.field_151032_g;
                    if (!world.field_72995_K) {
                        EntitySentientArrow entityArrow;
                        double soulsRemaining;
                        this.recalculatePowers(stack, world, player);
                        EnumDemonWillType type = this.getCurrentType(stack);
                        ItemArrow itemarrow = (ItemArrow)(itemstack.func_77973_b() instanceof ItemArrow ? itemstack.func_77973_b() : Items.field_151032_g);
                        double amount = this.getDropOfActivatedBow(stack) * world.field_73012_v.nextDouble() + this.getStaticDropOfActivatedBow(stack);
                        float newArrowVelocity = arrowVelocity * this.getVelocityOfArrow(stack);
                        if (itemarrow == Items.field_151032_g) {
                            soulsRemaining = PlayerDemonWillHandler.getTotalDemonWill(type, player);
                            entityArrow = new EntitySentientArrow(world, entityLiving, type, amount, this.getLevel(soulsRemaining), (PotionType)null);
                        } else if (itemarrow == Items.field_185167_i) {
                            soulsRemaining = PlayerDemonWillHandler.getTotalDemonWill(type, player);
                            entityArrow = new EntitySentientArrow(world, entityLiving, type, amount, this.getLevel(soulsRemaining), itemstack);
                        } else if (itemarrow == Items.field_185166_h) {
                            soulsRemaining = PlayerDemonWillHandler.getTotalDemonWill(type, player);
                            entityArrow = new EntitySentientArrow(world, entityLiving, type, amount, this.getLevel(soulsRemaining), new PotionType(new PotionEffect[]{new PotionEffect(MobEffects.field_188423_x, 200, 0)}));
                        } else {
                            soulsRemaining = PlayerDemonWillHandler.getTotalDemonWill(type, player);
                            entityArrow = new EntitySentientArrow(world, entityLiving, type, amount, this.getLevel(soulsRemaining), itemarrow.func_185052_a(world, stack, entityLiving));
                        }
                        entityArrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, newArrowVelocity, 1.0f);
                        if ((float)Float.compare(this.getVelocityOfArrow(stack), soullessShotVelocity) < Float.MIN_NORMAL) {
                            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187646_bt, SoundCategory.NEUTRAL, 0.4f, 1.0f);
                        }
                        if (arrowVelocity == 1.0f) {
                            entityArrow.func_70243_d(true);
                        }
                        int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
                        entityArrow.func_70239_b(entityArrow.func_70242_d() + this.getDamageAdded(stack) + (j > 0 ? (double)j * 0.5 + 0.5 : 0.0));
                        int k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack);
                        if (k > 0) {
                            entityArrow.func_70240_a(k);
                        }
                        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                            entityArrow.func_70015_d(100);
                        }
                        stack.func_77972_a(1, (EntityLivingBase)player);
                        if (flag1) {
                            ((EntityArrow)entityArrow).field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                        }
                        world.func_72838_d((Entity)entityArrow);
                    }
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + arrowVelocity * 0.5f);
                    if (!flag1) {
                        itemstack.func_190918_g(1);
                        if (itemstack.func_190926_b()) {
                            player.field_71071_by.func_184437_d(itemstack);
                        }
                    }
                    player.func_71029_a(StatList.func_188057_b((Item)this));
                }
            }
        }
    }

    protected ItemStack getFiredArrow(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    @Override
    public boolean spawnSentientEntityOnDrop(ItemStack droppedStack, EntityPlayer player) {
        World world = player.func_130014_f_();
        if (!world.field_72995_K) {
            this.recalculatePowers(droppedStack, world, player);
            EnumDemonWillType type = this.getCurrentType(droppedStack);
            double soulsRemaining = PlayerDemonWillHandler.getTotalDemonWill(type, player);
            if (soulsRemaining < 1024.0) {
                return false;
            }
            PlayerDemonWillHandler.consumeDemonWill(type, player, 100.0);
            EntitySentientSpecter specterEntity = new EntitySentientSpecter(world);
            specterEntity.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            world.func_72838_d((Entity)specterEntity);
            specterEntity.func_184201_a(EntityEquipmentSlot.MAINHAND, droppedStack.func_77946_l());
            specterEntity.setType(this.getCurrentType(droppedStack));
            specterEntity.setOwner(player);
            specterEntity.setTamed(true);
            return true;
        }
        return false;
    }
}

