/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.block.fertilizermixer;

import com.gendeathrow.hatchery.Hatchery;
import com.gendeathrow.hatchery.block.fertilizermixer.FertilizerMixerTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class FertilizerMixer
extends BlockContainer
implements ITileEntityProvider {
    public FertilizerMixer() {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149663_c("fertilizer_mixer");
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (heldItem.func_190926_b() && heldItem.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) {
            boolean notnull;
            FertilizerMixerTileEntity tileentity = (FertilizerMixerTileEntity)worldIn.func_175625_s(pos);
            IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)heldItem);
            boolean hasFluid = FluidUtil.getFluidContained((ItemStack)heldItem) != null && FluidUtil.getFluidContained((ItemStack)heldItem).getFluid() == FluidRegistry.WATER;
            boolean bl = notnull = tileentity != null && handler != null;
            if (notnull && hasFluid && tileentity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) {
                FluidUtil.tryFluidTransfer((IFluidHandler)tileentity.getWaterTank(), (IFluidHandler)handler, (int)tileentity.getWaterTank().getCapacity(), (boolean)true);
            } else if (notnull) {
                FluidUtil.tryFillContainerAndStow((ItemStack)heldItem, (IFluidHandler)tileentity.getFertilizerTank(), (IItemHandler)new InvWrapper((IInventory)playerIn.field_71071_by), (int)tileentity.getFertilizerTank().getCapacity(), (EntityPlayer)playerIn);
            } else {
                playerIn.openGui((Object)Hatchery.INSTANCE, 2, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        } else {
            playerIn.openGui((Object)Hatchery.INSTANCE, 2, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof FertilizerMixerTileEntity) {
            ((FertilizerMixerTileEntity)te).inputInventory.dropInventory(worldIn, pos);
            ((FertilizerMixerTileEntity)te).outputInventory.dropInventory(worldIn, pos);
            ((FertilizerMixerTileEntity)te).upgradeStorage.dropInventory(worldIn, pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return true;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (!(tileentity instanceof FertilizerMixerTileEntity)) {
            return 0;
        }
        FertilizerMixerTileEntity tile = (FertilizerMixerTileEntity)tileentity;
        return (int)Math.round((double)tile.getFertilizerTank().getFluidAmount() / (double)tile.getFertilizerTank().getCapacity() * 15.0);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new FertilizerMixerTileEntity();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isFullyOpaque(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
}

