/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.impl;

import com.google.common.base.Preconditions;
import java.util.UUID;
import javax.annotation.Nonnull;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.proxy.ITransmutationProxy;
import moze_intel.projecte.impl.TransmutationOffline;
import moze_intel.projecte.utils.WorldTransmutations;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.relauncher.Side;

public class TransmutationProxyImpl
implements ITransmutationProxy {
    public static final ITransmutationProxy instance = new TransmutationProxyImpl();

    private TransmutationProxyImpl() {
    }

    @Override
    public boolean registerWorldTransmutation(@Nonnull IBlockState origin, @Nonnull IBlockState result1, IBlockState result2) {
        Preconditions.checkNotNull((Object)origin);
        Preconditions.checkNotNull((Object)result1);
        Preconditions.checkState((boolean)Loader.instance().isInState(LoaderState.POSTINITIALIZATION), (Object)String.format("Mod %s tried to register world transmutation at an invalid time!", Loader.instance().activeModContainer().getModId()));
        if (WorldTransmutations.getWorldTransmutation(origin, false) != null) {
            return false;
        }
        WorldTransmutations.register(origin, result1, result2);
        return true;
    }

    @Override
    @Nonnull
    public IKnowledgeProvider getKnowledgeProviderFor(@Nonnull UUID playerUUID) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            Preconditions.checkState((PECore.proxy.getClientPlayer() != null ? 1 : 0) != 0, (Object)"Client player doesn't exist!");
            return PECore.proxy.getClientTransmutationProps();
        }
        Preconditions.checkNotNull((Object)playerUUID);
        Preconditions.checkState((boolean)Loader.instance().hasReachedState(LoaderState.SERVER_STARTED), (Object)"Server must be running to query knowledge!");
        EntityPlayer player = this.findOnlinePlayer(playerUUID);
        if (player != null) {
            return (IKnowledgeProvider)player.getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY, null);
        }
        return TransmutationOffline.forPlayer(playerUUID);
    }

    private EntityPlayer findOnlinePlayer(UUID playerUUID) {
        for (EntityPlayer player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            if (!player.func_110124_au().equals(playerUUID)) continue;
            return player;
        }
        return null;
    }
}

