/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.item.IItemCharge;
import moze_intel.projecte.api.item.IModeChanger;
import moze_intel.projecte.gameObjs.items.ItemPE;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemMode
extends ItemPE
implements IModeChanger,
IItemCharge {
    private final byte numModes;
    private final int numCharge;
    private final String[] modes;

    public ItemMode(String unlocalName, int numCharge, String[] modeDescrp) {
        this.numCharge = numCharge;
        this.func_77655_b(unlocalName);
        this.func_77625_d(1);
        this.numModes = (byte)modeDescrp.length;
        this.modes = modeDescrp;
    }

    @Override
    public byte getMode(@Nonnull ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74771_c("Mode") : (byte)0;
    }

    private String getUnlocalizedMode(ItemStack stack) {
        return this.modes[stack.func_77978_p().func_74771_c("Mode")];
    }

    protected void changeMode(ItemStack stack) {
        byte newMode = (byte)(this.getMode(stack) + 1);
        stack.func_77978_p().func_74774_a("Mode", newMode > this.numModes - 1 ? (byte)0 : newMode);
    }

    @Override
    public boolean changeMode(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, EnumHand hand) {
        if (this.numModes == 0) {
            return false;
        }
        this.changeMode(stack);
        TextComponentTranslation modeName = new TextComponentTranslation(this.modes[this.getMode(stack)], new Object[0]);
        player.func_145747_a((ITextComponent)new TextComponentTranslation("pe.item.mode_switch", new Object[]{modeName}));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag advanced) {
        if (stack.func_77942_o() && this.numModes > 0) {
            list.add(I18n.func_135052_a((String)"pe.item.mode", (Object[])new Object[0]) + ": " + TextFormatting.AQUA + I18n.func_135052_a((String)this.getUnlocalizedMode(stack), (Object[])new Object[0]));
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getCharge(stack) / (double)this.numCharge;
    }

    @Override
    public int getNumCharges(@Nonnull ItemStack stack) {
        return this.numCharge;
    }
}

