/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tools.engineering;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.stagingapi.ISignalMeterData;
import pl.asie.charset.lib.stagingapi.ISignalMeterDataProvider;
import pl.asie.charset.lib.stagingapi.ISignalMeterDataRemoteProvider;
import pl.asie.charset.lib.utils.MultipartUtils;

public class SignalMeterProviderHandler {
    public static SignalMeterProviderHandler INSTANCE = new SignalMeterProviderHandler();
    private final List<ISignalMeterDataRemoteProvider> remoteProviderBeforeList = new ArrayList<ISignalMeterDataRemoteProvider>();
    private final List<ISignalMeterDataRemoteProvider> remoteProviderAfterList = new ArrayList<ISignalMeterDataRemoteProvider>();

    protected SignalMeterProviderHandler() {
    }

    public void registerRemoteProvider(ISignalMeterDataRemoteProvider provider, boolean runBeforeCaps) {
        (runBeforeCaps ? this.remoteProviderBeforeList : this.remoteProviderAfterList).add(provider);
    }

    protected Optional<ISignalMeterData> getRemoteData(List<ISignalMeterDataRemoteProvider> list, IBlockAccess world, BlockPos pos, RayTraceResult result) {
        return list.stream().map(v -> v.getSignalMeterData(world, pos, result)).filter(Objects::nonNull).findFirst();
    }

    public Optional<ISignalMeterData> getSignalMeterData(IBlockAccess world, BlockPos pos, RayTraceResult result) {
        Optional<ISignalMeterData> dataPre = this.getRemoteData(this.remoteProviderBeforeList, world, pos, result);
        if (dataPre.isPresent()) {
            return dataPre;
        }
        MultipartUtils.ExtendedRayTraceResult extResult = MultipartUtils.INSTANCE.getTrueResult(result);
        TileEntity tileEntity = extResult.getTile(world);
        if (tileEntity != null && tileEntity.hasCapability(Capabilities.SIGNAL_METER_DATA_PROVIDER, null)) {
            return Optional.ofNullable(((ISignalMeterDataProvider)tileEntity.getCapability(Capabilities.SIGNAL_METER_DATA_PROVIDER, null)).getSignalMeterData(result));
        }
        return this.getRemoteData(this.remoteProviderAfterList, world, pos, result);
    }
}

