/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.block;

import com.google.common.collect.Lists;
import elec332.core.block.IAbstractBlock;
import elec332.core.util.IndexedAABB;
import elec332.core.util.RayTraceHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class BlockMethods {
    public static <B extends Block> String createUnlocalizedName(B block) {
        return "tile." + block.getRegistryName().toString().replace(":", ".").toLowerCase();
    }

    public static <B extends Block> RayTraceResult collisionRayTrace(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end, B block) {
        ArrayList boxes = Lists.newArrayList();
        ((IAbstractBlock)block).addSelectionBoxes(state, world, pos, boxes);
        return boxes.stream().reduce(null, (prev, box) -> {
            RayTraceResult hit = RayTraceHelper.rayTrace(pos, start, end, box);
            if (hit != null && box instanceof IndexedAABB) {
                hit.subHit = ((IndexedAABB)box).index;
            }
            return prev != null && (hit == null || start.func_72436_e(prev.field_72307_f) < start.func_72436_e(hit.field_72307_f)) ? prev : hit;
        }, (a, b) -> b);
    }

    public static <B extends Block> void addCollisionBoxToList(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState, B block) {
        entityBox = entityBox.func_186670_a(BlockPos.field_177992_a.func_177973_b((Vec3i)pos));
        ArrayList list = Lists.newArrayList();
        ((IAbstractBlock)block).addCollisionBoxes(state, world, pos, list);
        for (AxisAlignedBB box : list) {
            if (!box.func_72326_a(entityBox)) continue;
            collidingBoxes.add(box.func_186670_a(pos));
        }
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public static <B extends Block> AxisAlignedBB getSelectedBoundingBox(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, B block) {
        return BlockMethods.getSelectedBoundingBox(state, world, pos, RayTraceHelper.retraceBlock(state, world, pos, (EntityPlayer)Minecraft.func_71410_x().field_71439_g), block).func_186670_a(pos);
    }

    @SideOnly(value=Side.CLIENT)
    public static <B extends Block> AxisAlignedBB getSelectedBoundingBox(IBlockState state, World world, BlockPos pos, RayTraceResult hit, B block) {
        ArrayList list = Lists.newArrayList();
        ((IAbstractBlock)block).addSelectionBoxes(state, world, pos, list);
        if (!list.isEmpty()) {
            AxisAlignedBB aabb = null;
            for (AxisAlignedBB box : list) {
                if (aabb == null) {
                    aabb = box;
                    continue;
                }
                aabb = aabb.func_111270_a(box);
            }
            return aabb;
        }
        return state.func_185900_c((IBlockAccess)world, pos);
    }

    public static <B extends Block> boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ, B block) {
        RayTraceResult hit = RayTraceHelper.retraceBlock(state, world, pos, player);
        return hit != null && ((IAbstractBlock)block).onBlockActivated(world, pos, state, player, hand, hit);
    }

    public static <B extends Block> boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest, B block) {
        if (!((IAbstractBlock)block).canBreak(world, pos, player)) {
            if (player.field_71075_bZ.field_75098_d) {
                block.func_180649_a(world, pos, player);
            }
            return false;
        }
        block.func_176208_a(world, pos, state, player);
        return world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
    }
}

