/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.collect.ImmutableSet;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.IThreadListener;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import openmods.Log;

public class NetUtils {
    public static final ChannelFutureListener LOGGING_LISTENER = future -> {
        if (!future.isSuccess()) {
            Throwable cause = future.cause();
            Log.severe(cause, "Crash in pipeline handler", new Object[0]);
        }
    };

    public static NetworkDispatcher getPlayerDispatcher(EntityPlayerMP player) {
        NetworkDispatcher dispatcher = (NetworkDispatcher)player.field_71135_a.field_147371_a.channel().attr(NetworkDispatcher.FML_DISPATCHER).get();
        return dispatcher;
    }

    public static Set<EntityPlayerMP> getPlayersWatchingEntity(WorldServer server, Entity entity) {
        EntityTracker tracker = server.func_73039_n();
        Set trackingPlayers = tracker.getTrackingPlayers(entity);
        return ImmutableSet.copyOf((Collection)trackingPlayers);
    }

    public static Set<EntityPlayerMP> getPlayersWatchingChunk(WorldServer world, int chunkX, int chunkZ) {
        PlayerChunkMapEntry playerChunkMap = world.func_184164_w().func_187301_b(chunkX, chunkZ);
        if (playerChunkMap == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Collection)playerChunkMap.getWatchingPlayers());
    }

    public static Set<EntityPlayerMP> getPlayersWatchingBlock(WorldServer world, int blockX, int blockZ) {
        return NetUtils.getPlayersWatchingChunk(world, blockX >> 4, blockZ >> 4);
    }

    public static void executeSynchronized(ChannelHandlerContext ctx, Runnable runnable) {
        IThreadListener thread = FMLCommonHandler.instance().getWorldThread((INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get());
        if (!thread.func_152345_ab()) {
            thread.func_152344_a(runnable);
        } else {
            runnable.run();
        }
    }
}

