/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.types;

import WayofTime.bloodmagic.altar.AltarComponent;
import WayofTime.bloodmagic.altar.AltarTier;
import WayofTime.bloodmagic.altar.ComponentType;
import WayofTime.bloodmagic.block.BlockBloodRune;
import WayofTime.bloodmagic.core.RegistrarBloodMagicBlocks;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.util.BlockStack;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@RitualRegister(value="altar_builder")
public class RitualAltarBuilder
extends Ritual {
    private Iterator<AltarComponent> altarComponentsIterator = new ArrayList<AltarComponent>(AltarTier.values()[AltarTier.MAXTIERS - 1].getAltarComponents()).iterator();
    private boolean cycleDone = false;
    private AltarComponent currentComponent;
    private BlockPos currentPos;

    public RitualAltarBuilder() {
        super("ritualAltarBuilder", 0, 450, "ritual.bloodmagic.altarBuilderRitual");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        TileEntity tileEntity = world.func_175625_s(masterRitualStone.getBlockPos().func_177984_a());
        BlockPos altarPos = masterRitualStone.getBlockPos().func_177981_b(2);
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        if (this.cycleDone) {
            this.altarComponentsIterator = new ArrayList<AltarComponent>(AltarTier.values()[AltarTier.MAXTIERS - 1].getAltarComponents()).iterator();
        }
        if (world.func_180495_p(altarPos).func_177230_c().func_176200_f((IBlockAccess)world, altarPos) && this.hasItem(tileEntity, Item.func_150898_a((Block)RegistrarBloodMagicBlocks.ALTAR), 0, true)) {
            world.func_175656_a(altarPos, RegistrarBloodMagicBlocks.ALTAR.func_176223_P());
            this.lightning(world, altarPos);
            masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
        }
        if (this.altarComponentsIterator.hasNext()) {
            this.currentComponent = this.altarComponentsIterator.next();
            this.currentPos = altarPos.func_177971_a((Vec3i)this.currentComponent.getOffset());
            if (!world.func_180495_p(this.currentPos).func_177230_c().func_176200_f((IBlockAccess)world, this.currentPos)) return;
            switch (this.currentComponent.getComponent()) {
                case NOTAIR: {
                    BlockStack blockStack = this.getMundaneBlock(tileEntity);
                    if (blockStack == null) return;
                    world.func_180501_a(this.currentPos, blockStack.getState(), 3);
                    this.lightning(world, this.currentPos);
                    masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
                    return;
                }
                case BLOODRUNE: {
                    BlockStack blockStack = this.getBloodRune(tileEntity);
                    if (blockStack == null) return;
                    world.func_180501_a(this.currentPos, blockStack.getState(), 3);
                    this.lightning(world, this.currentPos);
                    masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
                    return;
                }
                default: {
                    BlockStack blockStack = new BlockStack(Utils.getBlockForComponent(this.currentComponent.getComponent()), 0);
                    if (!this.hasItem(tileEntity, Item.func_150898_a((Block)blockStack.getBlock()), blockStack.getMeta(), true)) return;
                    world.func_180501_a(this.currentPos, blockStack.getState(), 3);
                    this.lightning(world, this.currentPos);
                    masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
                    return;
                }
            }
        } else {
            this.cycleDone = true;
        }
    }

    @Override
    public int getRefreshCost() {
        return 75;
    }

    @Override
    public int getRefreshTime() {
        return 12;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        int i;
        for (i = -12; i <= -8; ++i) {
            this.addRune(components, i, -6, 13, EnumRuneType.AIR);
            this.addRune(components, i, -6, -13, EnumRuneType.FIRE);
            this.addRune(components, 13, -6, i, EnumRuneType.EARTH);
            this.addRune(components, -13, -6, i, EnumRuneType.WATER);
            this.addRune(components, i, 5, 13, EnumRuneType.AIR);
            this.addRune(components, i, 5, -13, EnumRuneType.FIRE);
            this.addRune(components, 13, 5, i, EnumRuneType.EARTH);
            this.addRune(components, -13, 5, i, EnumRuneType.WATER);
        }
        for (i = 8; i <= 12; ++i) {
            this.addRune(components, i, -6, 13, EnumRuneType.AIR);
            this.addRune(components, i, -6, -13, EnumRuneType.FIRE);
            this.addRune(components, 13, -6, i, EnumRuneType.EARTH);
            this.addRune(components, -13, -6, i, EnumRuneType.WATER);
            this.addRune(components, i, 5, 13, EnumRuneType.AIR);
            this.addRune(components, i, 5, -13, EnumRuneType.FIRE);
            this.addRune(components, 13, 5, i, EnumRuneType.EARTH);
            this.addRune(components, -13, 5, i, EnumRuneType.WATER);
        }
        for (i = -6; i <= -4; ++i) {
            this.addCornerRunes(components, 13, i, EnumRuneType.DUSK);
        }
        for (i = 3; i <= 5; ++i) {
            this.addCornerRunes(components, 13, i, EnumRuneType.DUSK);
        }
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualAltarBuilder();
    }

    public void lightning(World world, BlockPos blockPos) {
        world.func_72942_c((Entity)new EntityLightningBolt(world, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), true));
    }

    public boolean hasItem(TileEntity tileEntity, Item item, int damage, boolean consumeItem) {
        block4: {
            block5: {
                if (tileEntity == null) break block4;
                if (!tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) break block5;
                IItemHandler itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
                if (itemHandler.getSlots() <= 0) {
                    return false;
                }
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    if (itemHandler.getStackInSlot(i).func_190926_b() || itemHandler.getStackInSlot(i).func_77973_b() != item || itemHandler.getStackInSlot(i).func_77952_i() != damage || itemHandler.extractItem(i, 1, !consumeItem).func_190926_b()) continue;
                    return true;
                }
                break block4;
            }
            if (!(tileEntity instanceof IInventory)) break block4;
            IInventory inv = (IInventory)tileEntity;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_70301_a(0).func_190926_b() || inv.func_70301_a(i).func_77973_b() != item || inv.func_70301_a(i).func_77952_i() != damage) continue;
                if (consumeItem) {
                    inv.func_70298_a(i, 1);
                }
                return true;
            }
        }
        return false;
    }

    public BlockStack getBloodRune(TileEntity tileEntity) {
        block3: {
            block4: {
                if (tileEntity == null) break block3;
                if (!tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) break block4;
                IItemHandler itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
                if (itemHandler.getSlots() <= 0) {
                    return null;
                }
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    if (itemHandler.getStackInSlot(i).func_190926_b() || !(itemHandler.getStackInSlot(i).func_77973_b() instanceof ItemBlock) || !(Block.func_149634_a((Item)itemHandler.getStackInSlot(i).func_77973_b()) instanceof BlockBloodRune) || itemHandler.extractItem(i, 1, true) == null) continue;
                    BlockStack blockStack = new BlockStack(Utils.getBlockForComponent(ComponentType.BLOODRUNE), itemHandler.getStackInSlot(i).func_77952_i());
                    itemHandler.extractItem(i, 1, false);
                    return blockStack;
                }
                break block3;
            }
            if (!(tileEntity instanceof IInventory)) break block3;
            IInventory inv = (IInventory)tileEntity;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_70301_a(i).func_190926_b() || !(inv.func_70301_a(i).func_77973_b() instanceof ItemBlock) || !(Block.func_149634_a((Item)inv.func_70301_a(i).func_77973_b()) instanceof BlockBloodRune)) continue;
                BlockStack blockStack = new BlockStack(Utils.getBlockForComponent(ComponentType.BLOODRUNE), inv.func_70301_a(i).func_77952_i());
                inv.func_70298_a(i, 1);
                return blockStack;
            }
        }
        return null;
    }

    public BlockStack getMundaneBlock(TileEntity tileEntity) {
        block3: {
            block4: {
                if (tileEntity == null) break block3;
                if (!tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) break block4;
                IItemHandler itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
                if (itemHandler.getSlots() <= 0) {
                    return null;
                }
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    Block block;
                    if (itemHandler.getStackInSlot(i).func_190926_b() || !(itemHandler.getStackInSlot(i).func_77973_b() instanceof ItemBlock) || Block.func_149634_a((Item)itemHandler.getStackInSlot(i).func_77973_b()) instanceof BlockBloodRune || itemHandler.extractItem(i, 1, true).func_190926_b() || (block = Block.func_149634_a((Item)itemHandler.getStackInSlot(i).func_77973_b())) == Blocks.field_150350_a || block == Blocks.field_150426_aN || block == RegistrarBloodMagicBlocks.DECORATIVE_BRICK) continue;
                    BlockStack blockStack = new BlockStack(block, itemHandler.getStackInSlot(i).func_77952_i());
                    itemHandler.extractItem(i, 1, false);
                    return blockStack;
                }
                break block3;
            }
            if (!(tileEntity instanceof IInventory)) break block3;
            IInventory inv = (IInventory)tileEntity;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                Block block;
                if (inv.func_70301_a(i).func_190926_b() || !(inv.func_70301_a(i).func_77973_b() instanceof ItemBlock) || Block.func_149634_a((Item)inv.func_70301_a(i).func_77973_b()) instanceof BlockBloodRune || (block = Block.func_149634_a((Item)inv.func_70301_a(i).func_77973_b())) == Blocks.field_150426_aN || block == RegistrarBloodMagicBlocks.DECORATIVE_BRICK) continue;
                BlockStack blockStack = new BlockStack(block, inv.func_70301_a(i).func_77952_i());
                inv.func_70298_a(i, 1);
                return blockStack;
            }
        }
        return null;
    }
}

