/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks.lighting;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.api.ToolManager;
import reborncore.common.BaseTileBlock;
import reborncore.common.blocks.BlockWrenchEventHandler;
import reborncore.common.items.WrenchHelper;
import techreborn.tiles.lighting.TileLamp;
import techreborn.utils.TechRebornCreativeTab;

public class BlockLamp
extends BaseTileBlock {
    public static PropertyDirection FACING;
    public static PropertyBool ACTIVE;
    private AxisAlignedBB[] bbs;
    private int cost;
    private int brightness;

    public BlockLamp(int brightness, int cost, double depth, double width) {
        super(Material.field_151591_t);
        this.func_149647_a(TechRebornCreativeTab.instance);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.bbs = BlockLamp.GenBoundingBoxes(depth, width);
        this.cost = cost;
        this.brightness = brightness;
        ShootingStar.registerModel((ModelCompound)new ModelCompound("techreborn", (Block)this, "machines/lighting", new IProperty[0]));
        BlockWrenchEventHandler.wrenableBlocks.add(this);
    }

    private static AxisAlignedBB[] GenBoundingBoxes(double depth, double width) {
        AxisAlignedBB[] bb = new AxisAlignedBB[]{new AxisAlignedBB(width, 1.0 - depth, width, 1.0 - width, 1.0, 1.0 - width), new AxisAlignedBB(width, 0.0, width, 1.0 - width, depth, 1.0 - width), new AxisAlignedBB(width, width, 1.0 - depth, 1.0 - width, 1.0 - width, 1.0), new AxisAlignedBB(width, width, 0.0, 1.0 - width, 1.0 - width, depth), new AxisAlignedBB(1.0 - depth, width, width, 1.0, 1.0 - width, 1.0 - width), new AxisAlignedBB(0.0, width, width, depth, 1.0 - width, 1.0 - width)};
        return bb;
    }

    public static boolean isActive(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ACTIVE);
    }

    public static EnumFacing getFacing(IBlockState state) {
        if (!state.func_177228_b().containsKey((Object)FACING)) {
            return EnumFacing.NORTH;
        }
        return (EnumFacing)state.func_177229_b((IProperty)FACING);
    }

    public static void setFacing(EnumFacing facing, World world, BlockPos pos) {
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)FACING, (Comparable)facing));
    }

    public static void setActive(Boolean active, World world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        IBlockState state = world.func_180495_p(pos).func_177226_a((IProperty)ACTIVE, (Comparable)active).func_177226_a((IProperty)FACING, (Comparable)facing);
        world.func_180501_a(pos, state, 3);
    }

    public int getCost() {
        return this.cost;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileLamp();
    }

    protected BlockStateContainer func_180661_e() {
        FACING = PropertyDirection.func_177714_a((String)"facing");
        ACTIVE = PropertyBool.func_177716_a((String)"active");
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? this.brightness : 0;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess access, IBlockState state, BlockPos pos, EnumFacing facing) {
        if (BlockLamp.getFacing(state).func_176734_d() == facing) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.bbs[BlockLamp.getFacing(state).func_176745_a()];
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(EnumHand.MAIN_HAND);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity == null) {
            return false;
        }
        if (!stack.func_190926_b() && ToolManager.INSTANCE.canHandleTool(stack) && WrenchHelper.handleWrench((ItemStack)stack, (World)worldIn, (BlockPos)pos, (EntityPlayer)playerIn, (EnumFacing)side)) {
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    public int func_176201_c(IBlockState state) {
        int facingInt = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        int activeInt = (Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 8 : 0;
        return facingInt + activeInt;
    }

    public IBlockState func_176203_a(int meta) {
        Boolean active = (meta & 8) == 8;
        EnumFacing facing = EnumFacing.func_82600_a((int)(meta & 7));
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)ACTIVE, (Comparable)active);
    }
}

