/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalinnovation.item;

import cofh.core.init.CoreEnchantments;
import cofh.core.item.IAOEBreakItem;
import cofh.core.item.ItemMulti;
import cofh.core.key.KeyBindingItemMultiMode;
import cofh.core.render.IModelRegister;
import cofh.core.util.RayTracer;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.ColorHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalfoundation.init.TFProps;
import cofh.thermalfoundation.item.ItemMaterial;
import cofh.thermalinnovation.ThermalInnovation;
import cofh.thermalinnovation.item.ItemMultiRFTool;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSaw
extends ItemMultiRFTool
implements IInitializer,
IAOEBreakItem {
    private static Int2ObjectOpenHashMap<TypeEntry> typeMap = new Int2ObjectOpenHashMap();
    public static final int SINGLE = 0;
    public static final int TUNNEL_3 = 1;
    public static final int AREA_3 = 2;
    public static final int CUBE_3 = 3;
    public static final int AREA_5 = 4;
    public static final int[] HARVEST_LEVEL = new int[]{2, 2, 3, 3, 4};
    public static final float[] EFFICIENCY = new float[]{6.0f, 7.5f, 9.0f, 10.5f, 12.0f};
    public static final float[] ATTACK_DAMAGE = new float[]{4.0f, 4.5f, 5.0f, 5.5f, 6.0f};
    public static final int[] ENCHANTABILITY = new int[]{10, 10, 15, 15, 20};
    public static final int[] CAPACITY = new int[]{1, 3, 6, 10, 15};
    public static final int[] XFER = new int[]{1, 4, 9, 16, 25};
    public static final int[] NUM_MODES = new int[]{2, 3, 3, 4, 5};
    public static final float[] MODE_EFF = new float[]{0.0f, 1.0f, 2.0f, 4.0f, 4.0f};
    public static boolean enable = true;
    public static ItemStack sawBasic;
    public static ItemStack sawHardened;
    public static ItemStack sawReinforced;
    public static ItemStack sawSignalum;
    public static ItemStack sawResonant;
    public static ItemStack sawCreative;

    public ItemSaw() {
        super("thermalinnovation");
        this.func_77655_b("saw");
        this.func_77637_a(ThermalInnovation.tabTools);
        this.toolClasses.add((Object)"axe");
        this.toolClasses.add((Object)"sword");
        this.toolClasses.add((Object)"saw");
        this.effectiveBlocks.addAll((Collection)ItemAxe.field_150917_c);
        this.effectiveBlocks.add((Object)Blocks.field_150321_G);
        this.effectiveBlocks.add((Object)Blocks.field_150395_bd);
        this.effectiveBlocks.add((Object)Blocks.field_150362_t);
        this.effectiveBlocks.add((Object)Blocks.field_150361_u);
        this.effectiveMaterials.add((Object)Material.field_151575_d);
        this.effectiveMaterials.add((Object)Material.field_151570_A);
        this.effectiveMaterials.add((Object)Material.field_151572_C);
        this.effectiveMaterials.add((Object)Material.field_151584_j);
        this.effectiveMaterials.add((Object)Material.field_151585_k);
        this.effectiveMaterials.add((Object)Material.field_151582_l);
        this.effectiveMaterials.add((Object)Material.field_151569_G);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        tooltip.add(StringHelper.getInfoText((String)"info.thermalinnovation.saw.a.0"));
        tooltip.add(StringHelper.localize((String)("info.thermalinnovation.saw.c." + this.getMode(stack))));
        tooltip.add(StringHelper.localizeFormat((String)"info.thermalinnovation.saw.b.0", (Object[])new Object[]{StringHelper.getKeyName((int)KeyBindingItemMultiMode.INSTANCE.getKey())}));
        if (ItemSaw.isCreative((ItemStack)stack)) {
            tooltip.add(StringHelper.localize((String)"info.cofh.charge") + ": 1.21G RF");
        } else {
            tooltip.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.getScaledNumber((long)this.getEnergyStored(stack)) + " / " + StringHelper.getScaledNumber((long)this.getMaxEnergyStored(stack)) + " RF");
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (enable && this.func_194125_a(tab)) {
            Iterator iterator = this.itemList.iterator();
            while (iterator.hasNext()) {
                int metadata = (Integer)iterator.next();
                if (metadata != 32000) {
                    if (TFProps.showEmptyItems) {
                        items.add((Object)this.setDefaultTag(new ItemStack((Item)this, 1, metadata), 0));
                    }
                    if (!TFProps.showFullItems) continue;
                    items.add((Object)this.setDefaultTag(new ItemStack((Item)this, 1, metadata), this.getBaseCapacity(metadata)));
                    continue;
                }
                if (!TFProps.showCreativeItems) continue;
                items.add((Object)this.setDefaultTag(new ItemStack((Item)this, 1, metadata), this.getBaseCapacity(metadata)));
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        if (!this.isActive(stack)) {
            return;
        }
        long activeTime = stack.func_77978_p().func_74763_f("Active");
        if (entity.field_70170_p.func_82737_E() > activeTime) {
            stack.func_77978_p().func_82580_o("Active");
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (EnumEnchantmentType.BREAKABLE.equals((Object)enchantment.field_77351_y)) {
            return enchantment.equals(Enchantments.field_185307_s);
        }
        return enchantment.field_77351_y.func_77557_a((Item)this) || enchantment.func_92089_a(new ItemStack(Items.field_151036_c));
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        if (ServerHelper.isClientWorld((World)entity.field_70170_p)) {
            return false;
        }
        if (entity instanceof IShearable) {
            IShearable target = (IShearable)entity;
            BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (target.isShearable(stack, (IBlockAccess)entity.field_70170_p, pos)) {
                List drops = target.onSheared(stack, (IBlockAccess)entity.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack));
                entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 1.0f);
                for (ItemStack drop : drops) {
                    EntityItem ent = entity.func_70099_a(drop, 1.0f);
                    ent.field_70181_x += (double)(MathHelper.RANDOM.nextFloat() * 0.05f);
                    ent.field_70159_w += (double)((MathHelper.RANDOM.nextFloat() - MathHelper.RANDOM.nextFloat()) * 0.1f);
                    ent.field_70179_y += (double)((MathHelper.RANDOM.nextFloat() - MathHelper.RANDOM.nextFloat()) * 0.1f);
                }
                this.setActive(stack, (EntityLivingBase)player);
                if (!player.field_71075_bZ.field_75098_d) {
                    this.useEnergy(stack, 1, false);
                }
            }
            return true;
        }
        return false;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185887_b(world, pos) == 0.0f) {
            return false;
        }
        if (!this.canHarvestBlock(state, stack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, 1, false);
            }
            return false;
        }
        if (player.func_70093_af()) {
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, 1, false);
            }
            return false;
        }
        float refStrength = state.func_185903_a(player, world, pos);
        if (refStrength != 0.0f) {
            RayTraceResult traceResult = RayTracer.retrace((EntityPlayer)player, (boolean)false);
            if (traceResult == null || traceResult.field_178784_b == null) {
                return false;
            }
            int count = 1;
            int mode = this.getMode(stack);
            switch (mode) {
                case 0: {
                    break;
                }
                case 1: {
                    count += this.breakTunnel3(player, world, pos, traceResult, refStrength);
                    break;
                }
                case 2: {
                    count += this.breakArea3(player, world, pos, traceResult, refStrength);
                    break;
                }
                case 3: {
                    count += this.breakCube3(player, world, pos, traceResult, refStrength);
                    break;
                }
                case 4: {
                    count += this.breakArea5(player, world, pos, traceResult, refStrength);
                }
            }
            if (count > 0 && !player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, count, false);
            }
        }
        return false;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        this.setActive(stack, entityLiving);
        return true;
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return !oldStack.equals(newStack) && (this.getEnergyStored(oldStack) > 0 != this.getEnergyStored(newStack) > 0 || this.isActive(oldStack) != this.isActive(newStack));
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.getEnchantability(stack);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (this.getEnergyStored(stack) < this.energyPerUse) {
            return 1.0f;
        }
        return this.effectiveMaterials.contains((Object)state.func_185904_a()) || this.effectiveBlocks.contains((Object)state) ? this.getEfficiency(stack) - MODE_EFF[this.getMode(stack)] : 1.0f;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            if (this.getEnergyStored(stack) >= this.energyPerUse) {
                multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -2.0, 0));
                multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.getAttackDamage(stack), 0));
            } else {
                multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)-3.2f, 0));
                multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", 0.0, 0));
            }
        }
        return multimap;
    }

    protected int getCapacity(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        int capacity = ((TypeEntry)ItemSaw.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).capacity;
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack);
        return capacity + capacity * enchant / 2;
    }

    protected int getReceive(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        return ((TypeEntry)ItemSaw.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).recv;
    }

    public int getBaseCapacity(int metadata) {
        if (!typeMap.containsKey(metadata)) {
            return 0;
        }
        return ((TypeEntry)ItemSaw.typeMap.get((int)metadata)).capacity;
    }

    public int getEnchantability(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        return ((TypeEntry)ItemSaw.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).enchantability;
    }

    @Override
    public int getHarvestLevel(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack)) || this.getEnergyStored(stack) <= this.energyPerUse) {
            return -1;
        }
        return ((TypeEntry)ItemSaw.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).harvestLevel;
    }

    public float getAttackDamage(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0.0f;
        }
        if (this.getEnergyStored(stack) < this.energyPerUse * 2) {
            return 0.0f;
        }
        return ((TypeEntry)ItemSaw.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).attackDamage;
    }

    public float getEfficiency(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0.0f;
        }
        return ((TypeEntry)ItemSaw.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).efficiency;
    }

    public ImmutableList<BlockPos> getAOEBlocks(ItemStack stack, BlockPos pos, EntityPlayer player) {
        ArrayList<BlockPos> area = new ArrayList<BlockPos>();
        World world = player.func_130014_f_();
        int mode = this.getMode(stack);
        RayTraceResult traceResult = RayTracer.retrace((EntityPlayer)player, (boolean)false);
        if (traceResult == null || traceResult.field_178784_b == null || !this.canHarvestBlock(world.func_180495_p(pos), stack) || player.func_70093_af()) {
            return ImmutableList.copyOf(area);
        }
        switch (mode) {
            case 0: {
                break;
            }
            case 1: {
                this.getAOEBlocksTunnel3(stack, world, player, pos, traceResult, area);
                break;
            }
            case 2: {
                this.getAOEBlocksArea3(stack, world, pos, traceResult, area);
                break;
            }
            case 3: {
                this.getAOEBlocksCube3(stack, world, pos, traceResult, area);
                break;
            }
            case 4: {
                this.getAOEBlocksArea5(stack, world, pos, traceResult, area);
            }
        }
        return ImmutableList.copyOf(area);
    }

    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return super.canEnchant(stack, enchantment) || enchantment == CoreEnchantments.insight || enchantment == CoreEnchantments.smelting || enchantment == CoreEnchantments.vorpal;
    }

    public int getNumModes(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        return ((TypeEntry)ItemSaw.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).numModes;
    }

    public void onModeChange(EntityPlayer player, ItemStack stack) {
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187750_dc, SoundCategory.PLAYERS, 0.6f, 1.0f - 0.1f * (float)this.getMode(stack));
        ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("info.thermalinnovation.saw.c." + this.getMode(stack), new Object[0]));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            Object[] objectArray = new Object[3];
            objectArray[0] = ColorHelper.hasColor0((ItemStack)stack) ? 1 : 0;
            objectArray[1] = this.getEnergyStored(stack) > 0 ? (this.isActive(stack) ? "active" : "charged") : "drained";
            objectArray[2] = ((TypeEntry)ItemSaw.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).name;
            return new ModelResourceLocation(this.getRegistryName(), String.format("color0=%s,state=%s,type=%s", objectArray));
        });
        String[] states = new String[]{"charged", "active", "drained"};
        for (Map.Entry entry : this.itemMap.entrySet()) {
            for (int color0 = 0; color0 < 2; ++color0) {
                for (int state = 0; state < 3; ++state) {
                    ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(this.getRegistryName(), String.format("color0=%s,state=%s,type=%s", color0, states[state], ((ItemMulti.ItemEntry)entry.getValue()).name))});
                }
            }
        }
    }

    public boolean preInit() {
        ForgeRegistries.ITEMS.register(this.setRegistryName("saw"));
        ThermalInnovation.proxy.addIModelRegister((IModelRegister)this);
        ItemSaw.config();
        sawBasic = this.addEntryItem(0, "standard0", EnumRarity.COMMON);
        sawHardened = this.addEntryItem(1, "standard1", EnumRarity.COMMON);
        sawReinforced = this.addEntryItem(2, "standard2", EnumRarity.UNCOMMON);
        sawSignalum = this.addEntryItem(3, "standard3", EnumRarity.UNCOMMON);
        sawResonant = this.addEntryItem(4, "standard4", EnumRarity.RARE);
        sawCreative = this.addEntryItem(32000, "creative", HARVEST_LEVEL[4], EFFICIENCY[4], ATTACK_DAMAGE[4], ENCHANTABILITY[4], CAPACITY[4], 0, NUM_MODES[4], EnumRarity.EPIC);
        return true;
    }

    public boolean initialize() {
        if (!enable) {
            return false;
        }
        RecipeHelper.addShapedRecipe((ItemStack)sawBasic, (Object[])new Object[]{" X ", "ICI", "YGY", Character.valueOf('C'), ItemMaterial.partToolCasing, Character.valueOf('G'), "gearIron", Character.valueOf('I'), "ingotSilver", Character.valueOf('X'), ItemMaterial.partSawBlade, Character.valueOf('Y'), "ingotTin"});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)sawHardened, (Object[])new Object[]{" R ", "IXI", "RGR", Character.valueOf('G'), "gearInvar", Character.valueOf('I'), "ingotInvar", Character.valueOf('R'), "ingotCopper", Character.valueOf('X'), sawBasic});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)sawReinforced, (Object[])new Object[]{" R ", "IXI", "RGR", Character.valueOf('G'), "gearElectrum", Character.valueOf('I'), "ingotElectrum", Character.valueOf('R'), "gemDiamond", Character.valueOf('X'), sawHardened});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)sawSignalum, (Object[])new Object[]{" R ", "IXI", "RGR", Character.valueOf('G'), "gearSignalum", Character.valueOf('I'), "ingotSignalum", Character.valueOf('R'), "dustAerotheum", Character.valueOf('X'), sawReinforced});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)sawResonant, (Object[])new Object[]{" R ", "IXI", "RGR", Character.valueOf('G'), "gearEnderium", Character.valueOf('I'), "ingotEnderium", Character.valueOf('R'), "ingotLumium", Character.valueOf('X'), sawSignalum});
        RecipeHelper.addColorRecipe((ItemStack)sawBasic, (Object[])new Object[]{sawBasic, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)sawHardened, (Object[])new Object[]{sawHardened, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)sawReinforced, (Object[])new Object[]{sawReinforced, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)sawSignalum, (Object[])new Object[]{sawSignalum, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)sawResonant, (Object[])new Object[]{sawResonant, "dye"});
        RecipeHelper.addColorRemoveRecipe((ItemStack)sawBasic, (Object[])new Object[]{sawBasic});
        RecipeHelper.addColorRemoveRecipe((ItemStack)sawHardened, (Object[])new Object[]{sawHardened});
        RecipeHelper.addColorRemoveRecipe((ItemStack)sawReinforced, (Object[])new Object[]{sawReinforced});
        RecipeHelper.addColorRemoveRecipe((ItemStack)sawSignalum, (Object[])new Object[]{sawSignalum});
        RecipeHelper.addColorRemoveRecipe((ItemStack)sawResonant, (Object[])new Object[]{sawResonant});
        return true;
    }

    private static void config() {
        String category = "Item.Saw";
        enable = ThermalInnovation.CONFIG.get(category, "Enable", true);
        int capacity = 40000;
        String comment = "Adjust this value to change the amount of Energy (in RF) stored by a Basic Fluxsaw. This base value will scale with item level.";
        capacity = ThermalInnovation.CONFIG.getConfiguration().getInt("BaseCapacity", category, capacity, 10000, 10000000, comment);
        int xfer = 1000;
        comment = "Adjust this value to change the amount of Energy (in RF/t) that can be received by a Basic Fluxsaw. This base value will scale with item level.";
        xfer = ThermalInnovation.CONFIG.getConfiguration().getInt("BaseReceive", category, xfer, 100, 1000000, comment);
        int i = 0;
        while (i < CAPACITY.length) {
            int n = i;
            CAPACITY[n] = CAPACITY[n] * capacity;
            int n2 = i++;
            XFER[n2] = XFER[n2] * xfer;
        }
    }

    private void addEntry(int metadata, String name, int harvestLevel, float efficiency, float attackDamage, int enchantability, int capacity, int xfer, int numModes) {
        typeMap.put(metadata, (Object)new TypeEntry(name, harvestLevel, efficiency, attackDamage, enchantability, capacity, xfer, numModes));
    }

    private ItemStack addEntryItem(int metadata, String name, EnumRarity rarity) {
        this.addEntry(metadata, name, HARVEST_LEVEL[metadata], EFFICIENCY[metadata], ATTACK_DAMAGE[metadata], ENCHANTABILITY[metadata], CAPACITY[metadata], XFER[metadata], NUM_MODES[metadata]);
        return this.addItem(metadata, name, rarity);
    }

    private ItemStack addEntryItem(int metadata, String name, int harvestLevel, float efficiency, float attackDamage, int enchantability, int capacity, int xfer, int numModes, EnumRarity rarity) {
        this.addEntry(metadata, name, harvestLevel, efficiency, attackDamage, enchantability, capacity, xfer, numModes);
        return this.addItem(metadata, name, rarity);
    }

    public class TypeEntry {
        public final String name;
        public final int harvestLevel;
        public final float efficiency;
        public final float attackDamage;
        public final int enchantability;
        public final int capacity;
        public final int recv;
        public final int numModes;

        TypeEntry(String name, int harvestLevel, float efficiency, float attackDamage, int enchantability, int capacity, int recv, int numModes) {
            this.name = name;
            this.harvestLevel = harvestLevel;
            this.efficiency = efficiency;
            this.attackDamage = attackDamage;
            this.enchantability = enchantability;
            this.capacity = capacity;
            this.recv = recv;
            this.numModes = numModes;
        }
    }
}

