/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.tile;

import com.latmod.yabba.api.BarrelContentType;
import com.latmod.yabba.tile.IBarrelConnector;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class BarrelNetwork
implements ICapabilityProvider {
    @CapabilityInject(value=BarrelNetwork.class)
    public static Capability<BarrelNetwork> CAP;
    public final World world;
    public final List<IBarrelConnector> connectors = new ArrayList<IBarrelConnector>();
    private boolean refresh = true;

    public static BarrelNetwork get(World world) {
        return (BarrelNetwork)world.getCapability(CAP, null);
    }

    public BarrelNetwork(World w) {
        this.world = w;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CAP;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CAP ? this : null);
    }

    public void refresh() {
        this.refresh = true;
    }

    public void barrelUpdated(BarrelContentType type) {
        for (IBarrelConnector connector : this.connectors) {
            if (connector.getContentType() != type) continue;
            connector.updateBarrels();
        }
    }

    public void tick() {
        if (this.refresh) {
            this.connectors.clear();
            for (TileEntity tileEntity : this.world.field_147482_g) {
                if (tileEntity.func_145837_r() || !(tileEntity instanceof IBarrelConnector)) continue;
                this.connectors.add((IBarrelConnector)tileEntity);
            }
            for (IBarrelConnector connector : this.connectors) {
                connector.updateBarrels();
            }
            this.refresh = false;
        }
    }
}

