/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.block;

import com.feed_the_beast.ftblib.lib.util.BlockUtils;
import com.latmod.yabba.YabbaConfig;
import com.latmod.yabba.YabbaItems;
import com.latmod.yabba.api.UpgradeData;
import com.latmod.yabba.block.BlockDecorativeBlock;
import com.latmod.yabba.item.ItemHammer;
import com.latmod.yabba.item.ItemPainter;
import com.latmod.yabba.tile.TileBarrel;
import com.latmod.yabba.util.BarrelLook;
import com.latmod.yabba.util.EnumBarrelModel;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockBarrel
extends BlockDecorativeBlock {
    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileBarrel();
    }

    @Override
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this));
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (world.field_72995_K || player.field_71075_bZ.field_75098_d) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileBarrel) {
            long time = world.func_82737_E();
            TileBarrel barrel = (TileBarrel)tileEntity;
            if (time - barrel.lastClick < 3L) {
                return;
            }
            barrel.lastClick = time;
            ((TileBarrel)tileEntity).barrel.content.removeItem((EntityPlayerMP)player, player.func_70093_af() == YabbaConfig.general.sneak_left_click_extracts_stack);
            player.field_71071_by.func_70296_d();
            if (player.field_71070_bA != null) {
                player.field_71070_bA.func_75142_b();
            }
        }
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (Block.func_149634_a((Item)heldItem.func_77973_b()) instanceof BlockBarrel) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        if (heldItem.func_77973_b() == YabbaItems.HAMMER || heldItem.func_77973_b() == YabbaItems.PAINTER) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileBarrel) {
                TileBarrel barrel = (TileBarrel)tileEntity;
                if (heldItem.func_77973_b() == YabbaItems.HAMMER) {
                    barrel.barrel.setLook(BarrelLook.get(ItemHammer.getModel(heldItem), barrel.barrel.getLook().skin));
                } else {
                    barrel.barrel.setLook(BarrelLook.get(barrel.barrel.getLook().model, ItemPainter.getSkin(heldItem)));
                }
            }
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBarrel) {
            TileBarrel barrel = (TileBarrel)tile;
            if (player.func_70093_af()) {
                barrel.barrel.openGui((EntityPlayerMP)player);
            } else if (heldItem.hasCapability(UpgradeData.CAPABILITY, null)) {
                int i;
                ItemStack upgradeStack;
                UpgradeData data;
                if (!barrel.barrel.hasUpgrade(heldItem.func_77973_b()) && (data = (UpgradeData)(upgradeStack = ItemHandlerHelper.copyStackWithSize((ItemStack)heldItem, (int)1)).getCapability(UpgradeData.CAPABILITY, null)) != null && data.canInsert(barrel.barrel, (EntityPlayerMP)player) && (i = barrel.barrel.findFreeUpgradeSlot()) != -1) {
                    data.onInserted(barrel.barrel, (EntityPlayerMP)player);
                    heldItem.func_190918_g(1);
                    barrel.barrel.setUpgrade(i, data);
                    barrel.markBarrelDirty(true);
                }
            } else {
                long time = world.func_82737_E();
                if (time - barrel.lastClick <= 8L) {
                    barrel.barrel.content.addAllItems((EntityPlayerMP)player, hand);
                } else if (!heldItem.func_190926_b()) {
                    barrel.barrel.content.addItem((EntityPlayerMP)player, hand);
                }
                barrel.lastClick = time;
            }
        }
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileBarrel && side == state.func_177229_b((IProperty)BlockHorizontal.field_185512_D) && ((TileBarrel)tile).barrel.hasUpgrade(YabbaItems.UPGRADE_REDSTONE_OUT);
    }

    @Deprecated
    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileBarrel && side == state.func_177229_b((IProperty)BlockHorizontal.field_185512_D) ? ((TileBarrel)tile).barrel.content.redstoneOutput() : 0;
    }

    @Override
    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBarrel) {
            return ((TileBarrel)tile).getAABB();
        }
        return field_185505_j;
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBarrel && ((TileBarrel)tile).barrel.hasUpgrade(YabbaItems.UPGRADE_OBSIDIAN_SHELL)) {
            return Float.MAX_VALUE;
        }
        return 8.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (world != null && BlockUtils.hasData((ItemStack)stack)) {
            TileBarrel barrel = (TileBarrel)this.createTileEntity(world, this.func_176223_P());
            barrel.readFromItem(stack);
            BarrelLook look = barrel.barrel.getLook();
            tooltip.add(ItemHammer.getModelTooltip(look.model));
            tooltip.add(ItemPainter.getSkinTooltip(look.skin));
            barrel.barrel.content.addInformation(tooltip, flag);
        } else {
            tooltip.add(ItemHammer.getModelTooltip(EnumBarrelModel.BARREL));
            tooltip.add(ItemPainter.getSkinTooltip(""));
        }
    }
}

