/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.teamislands.data;

import com.feed_the_beast.ftblib.events.universe.UniverseClosedEvent;
import com.feed_the_beast.ftblib.events.universe.UniverseLoadedEvent;
import com.feed_the_beast.ftblib.events.universe.UniverseSavedEvent;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.mods.teamislands.TeamIslandsConfig;
import com.feed_the_beast.mods.teamislands.data.Island;
import com.feed_the_beast.mods.teamislands.data.IslandTemplate;
import com.feed_the_beast.mods.teamislands.data.TeamIslandsTeamData;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="teamislands")
public class TeamIslandsUniverseData {
    public static TeamIslandsUniverseData INSTANCE;
    public final Universe universe;
    private final Island lobby;
    public final List<Island> islands;
    public final List<IslandTemplate> islandTemplates;
    public final Map<String, IslandTemplate> islandTemplateMap;

    public TeamIslandsUniverseData(Universe u, NBTTagCompound nbt) {
        this.universe = u;
        this.lobby = new Island(this, 0, 0, 0, "server");
        this.lobby.spawned = true;
        this.islands = new ArrayList<Island>();
        this.islands.add(this.lobby);
        this.islandTemplates = new ArrayList<IslandTemplate>();
        this.islandTemplateMap = new HashMap<String, IslandTemplate>();
        for (String s : TeamIslandsConfig.islands.structure_files) {
            File file;
            Template template = this.universe.world.func_72860_G().func_186340_h().func_186237_a(this.universe.server, new ResourceLocation("teamislands", "custom/" + this.islandTemplates.size()));
            File folder = Loader.instance().getConfigDir();
            if ((s = s.trim()).startsWith("/")) {
                folder = folder.getParentFile();
                s = s.substring(1);
            }
            if (!(file = new File(folder, s)).exists() || !file.isFile()) continue;
            try (FileInputStream fis = new FileInputStream(file);){
                template.func_186256_b(CompressedStreamTools.func_74796_a((InputStream)fis));
                this.islandTemplates.add(new IslandTemplate(file.getName(), s, template));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.islandTemplates.isEmpty()) {
            Template template = this.universe.world.func_72860_G().func_186340_h().func_186237_a(this.universe.server, new ResourceLocation("teamislands", "teamislands_island"));
            this.islandTemplates.add(new IslandTemplate("default", "default", template));
        }
        for (IslandTemplate t : this.islandTemplates) {
            t.spawn = new BlockPos(t.template.func_186259_a().func_177958_n() / 2, t.template.func_186259_a().func_177956_o(), t.template.func_186259_a().func_177952_p() / 2);
            for (Map.Entry entry : t.template.func_186258_a(BlockPos.field_177992_a, new PlacementSettings()).entrySet()) {
                if (((String)entry.getValue()).equals("SPAWN_POINT")) {
                    t.spawn = (BlockPos)entry.getKey();
                    continue;
                }
                if (((String)entry.getValue()).startsWith("DISPLAY_NAME=")) {
                    try {
                        t.displayName = ITextComponent.Serializer.func_186877_b((String)((String)entry.getValue()).substring(13));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                if (!((String)entry.getValue()).startsWith("ICON=")) continue;
                t.icon = ((String)entry.getValue()).substring(5);
            }
        }
        for (IslandTemplate template : this.islandTemplates) {
            this.islandTemplateMap.put(template.path, template);
        }
        NBTTagList islandsTag = nbt.func_150295_c("Islands", 10);
        for (int i = 0; i < islandsTag.func_74745_c(); ++i) {
            this.islands.add(new Island(this, i + 1, islandsTag.func_150305_b(i)));
        }
    }

    public Island getLobby() {
        return this.lobby;
    }

    public Island getIsland(int id) {
        Island island;
        if (id == 0) {
            return this.getLobby();
        }
        Island island2 = island = id < 0 || id >= this.islands.size() ? null : this.islands.get(id);
        if (island == null) {
            ChunkPos pos = MathUtils.getSpiralPoint((int)(id + 1));
            island = new Island(this, this.islands.size(), pos.field_77276_a, pos.field_77275_b, "server");
            this.islands.add(island);
            this.universe.markDirty();
        }
        return island;
    }

    public Island getIsland(@Nullable ForgeTeam team) {
        if (team == null) {
            return this.lobby;
        }
        return ((TeamIslandsTeamData)team.getData().get("teamislands")).getIsland();
    }

    @SubscribeEvent
    public static void onUniverseLoaded(UniverseLoadedEvent.Pre event) {
        INSTANCE = new TeamIslandsUniverseData(event.getUniverse(), event.getData("teamislands"));
    }

    @SubscribeEvent
    public static void onUniverseSaved(UniverseSavedEvent event) {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList islands = new NBTTagList();
        for (Island island : TeamIslandsUniverseData.INSTANCE.islands) {
            if (island.isLobby()) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            island.writeToNBT(nbt1);
            islands.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("Islands", (NBTBase)islands);
        event.setData("teamislands", nbt);
    }

    @SubscribeEvent
    public static void onUniverseUnloaded(UniverseClosedEvent event) {
        INSTANCE = null;
    }
}

