/*
 * Decompiled with CFR 0.152.
 */
package modmuss50.hcmr;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import modmuss50.hcmr.GuiMapList;
import modmuss50.hcmr.LevelUtils;
import modmuss50.hcmr.ResetMaps;
import modmuss50.hcmr.WorldInfo;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.IOUtils;

public class WorldZip
extends WorldInfo {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private String name;
    private WorldInfo.AuthorData author;
    private File saveFile;
    private ZipFile zipFile;

    public static WorldZip loadZip(File input) {
        try {
            ZipFile zipFile = new ZipFile(input);
            WorldInfo.AuthorData authorData = new WorldInfo.AuthorData();
            ZipEntry aDataEntry = zipFile.getEntry("info.json");
            if (aDataEntry != null) {
                InputStream aDataIS = zipFile.getInputStream(aDataEntry);
                String aDataJson = IOUtils.toString((InputStream)aDataIS, (Charset)Charsets.UTF_8);
                aDataIS.close();
                authorData = (WorldInfo.AuthorData)GSON.fromJson(aDataJson, WorldInfo.AuthorData.class);
            }
            InputStream levelIS = zipFile.getInputStream(zipFile.getEntry("level.dat"));
            NBTTagCompound levelDat = LevelUtils.readLevel(levelIS).func_74775_l("Data");
            levelIS.close();
            String worldName = levelDat.func_74779_i("LevelName");
            return new WorldZip(worldName, authorData, input, zipFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public WorldZip(String name, WorldInfo.AuthorData author, File saveFile, ZipFile zipFile) {
        this.name = name;
        this.author = author;
        this.saveFile = saveFile;
        this.zipFile = zipFile;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public WorldInfo.AuthorData getAuthorData() {
        return this.author;
    }

    @Override
    public File getSaveFile() {
        return this.saveFile;
    }

    @Override
    public BufferedImage getIconImage() {
        try {
            InputStream iconIS = this.zipFile.getInputStream(this.zipFile.getEntry(this.getAuthorData().thumbnail));
            BufferedImage bufferedImage = ImageIO.read(iconIS);
            iconIS.close();
            return bufferedImage;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void copy(GuiMapList mapList) {
        ResetMaps.copyZipWorld(this, mapList.folderString, mapList);
    }

    @Override
    public Optional<String> valid() {
        return Optional.empty();
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }
}

