/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.clipboard.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.shadowfacts.clipboard.Clipboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001eB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lnet/shadowfacts/clipboard/network/PacketUpdateClipboardItem;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "stack", "Lnet/minecraft/item/ItemStack;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/EnumHand;)V", "()V", "getHand", "()Lnet/minecraft/util/EnumHand;", "setHand", "(Lnet/minecraft/util/EnumHand;)V", "Ljava/util/UUID;", "getPlayer", "()Ljava/util/UUID;", "setPlayer", "(Ljava/util/UUID;)V", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "getTag", "()Lnet/minecraft/nbt/NBTTagCompound;", "setTag", "(Lnet/minecraft/nbt/NBTTagCompound;)V", "fromBytes", "", "buf", "Lio/netty/buffer/ByteBuf;", "toBytes", "Handler", "Clipboard_main"})
public final class PacketUpdateClipboardItem
implements IMessage {
    @NotNull
    public UUID player;
    @NotNull
    public EnumHand hand;
    @NotNull
    public NBTTagCompound tag;

    @NotNull
    public final UUID getPlayer() {
        UUID uUID = this.player;
        if (uUID == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"player");
        }
        return uUID;
    }

    public final void setPlayer(@NotNull UUID uUID) {
        Intrinsics.checkParameterIsNotNull((Object)uUID, (String)"<set-?>");
        this.player = uUID;
    }

    @NotNull
    public final EnumHand getHand() {
        EnumHand enumHand = this.hand;
        if (enumHand == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hand");
        }
        return enumHand;
    }

    public final void setHand(@NotNull EnumHand enumHand) {
        Intrinsics.checkParameterIsNotNull((Object)enumHand, (String)"<set-?>");
        this.hand = enumHand;
    }

    @NotNull
    public final NBTTagCompound getTag() {
        NBTTagCompound nBTTagCompound = this.tag;
        if (nBTTagCompound == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tag");
        }
        return nBTTagCompound;
    }

    public final void setTag(@NotNull NBTTagCompound nBTTagCompound) {
        Intrinsics.checkParameterIsNotNull((Object)nBTTagCompound, (String)"<set-?>");
        this.tag = nBTTagCompound;
    }

    public void toBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        UUID uUID = this.player;
        if (uUID == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"player");
        }
        buf.writeLong(uUID.getMostSignificantBits());
        UUID uUID2 = this.player;
        if (uUID2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"player");
        }
        buf.writeLong(uUID2.getLeastSignificantBits());
        EnumHand enumHand = this.hand;
        if (enumHand == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hand");
        }
        buf.writeInt(enumHand.ordinal());
        NBTTagCompound nBTTagCompound = this.tag;
        if (nBTTagCompound == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tag");
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nBTTagCompound);
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        this.player = new UUID(buf.readLong(), buf.readLong());
        this.hand = EnumHand.values()[buf.readInt()];
        NBTTagCompound nBTTagCompound = ByteBufUtils.readTag((ByteBuf)buf);
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        this.tag = nBTTagCompound;
    }

    public PacketUpdateClipboardItem() {
    }

    public PacketUpdateClipboardItem(@NotNull ItemStack stack, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        this();
        UUID uUID = player.func_110124_au();
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"player.uniqueID");
        this.player = uUID;
        this.hand = hand;
        NBTTagCompound nBTTagCompound = stack.func_77978_p();
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        this.tag = nBTTagCompound;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lnet/shadowfacts/clipboard/network/PacketUpdateClipboardItem$Handler;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessageHandler;", "Lnet/shadowfacts/clipboard/network/PacketUpdateClipboardItem;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "()V", "onMessage", "message", "ctx", "Lnet/minecraftforge/fml/common/network/simpleimpl/MessageContext;", "Clipboard_main"})
    public static final class Handler
    implements IMessageHandler<PacketUpdateClipboardItem, IMessage> {
        @Nullable
        public IMessage onMessage(@NotNull PacketUpdateClipboardItem message, @Nullable MessageContext ctx) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(message.getPlayer());
            ItemStack stack = player.func_184586_b(message.getHand());
            if (Intrinsics.areEqual((Object)stack.func_77973_b(), (Object)((Object)Clipboard.INSTANCE.getClipboard()))) {
                ItemStack itemStack = stack;
                if (itemStack == null) {
                    Intrinsics.throwNpe();
                }
                itemStack.func_77982_d(message.getTag());
            }
            return null;
        }
    }
}

