/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.boneappetit;

import com.latmod.mods.boneappetit.SoilType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="boneappetit")
@Config(modid="boneappetit", category="")
public class BoneAppetitConfig {
    public static final General general = new General();
    public static final Soils soils = new Soils();
    private static final Map<SoilType, List<PlantEntry>> CACHE = new HashMap<SoilType, List<PlantEntry>>();

    public static IBlockState getState(SoilType type, Random random) {
        List<PlantEntry> list = CACHE.get((Object)type);
        if (list == null) {
            list = new ArrayList<PlantEntry>();
            CACHE.put(type, list);
            String[] s = type == SoilType.SOUL_SAND ? BoneAppetitConfig.soils.soul_sand : (type == SoilType.END_STONE ? BoneAppetitConfig.soils.end_stone : BoneAppetitConfig.soils.sand);
            for (String s1 : s) {
                String[] s2 = s1.split("x ", 2);
                if (s2.length != 2) continue;
                try {
                    int w = Integer.parseInt(s2[0]);
                    if (w <= 0) continue;
                    Block block = Block.func_149684_b((String)s2[1]);
                    list.add(new PlantEntry((block == null ? Blocks.field_150350_a : block).func_176223_P(), w));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (list.isEmpty()) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return ((PlantEntry)WeightedRandom.func_76271_a((Random)random, list)).state;
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("boneappetit")) {
            ConfigManager.sync((String)"boneappetit", (Config.Type)Config.Type.INSTANCE);
            CACHE.clear();
        }
    }

    private static class PlantEntry
    extends WeightedRandom.Item {
        private final IBlockState state;

        public PlantEntry(IBlockState s, int w) {
            super(w);
            this.state = s;
        }
    }

    public static class Soils {
        public final String[] sand = new String[]{"100x minecraft:air", "3x minecraft:cactus", "3x minecraft:reeds", "1x thaumcraft:cinderpearl"};
        public final String[] soul_sand = new String[]{"30x minecraft:air", "1x minecraft:nether_wart"};
        public final String[] end_stone = new String[]{"60x minecraft:air", "4x minecraft:chorus_flower", "1x extrautils2:enderlilly"};
    }

    public static class General {
        @Config.RangeInt(min=0, max=15)
        public int radius = 2;
    }
}

