/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.container;

import com.inventorypets.InventoryPets;
import com.inventorypets.container.ContainerChests;
import com.inventorypets.container.InventoryDoubleChestPet;
import com.inventorypets.container.NBTHelper;
import com.inventorypets.container.StackUtils;
import com.inventorypets.pets.petDoubleChest;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class DoubleChestContainer
extends ContainerChests {
    public static int DOUBLELines = 6;
    public static int DOUBLEColumns = 9;
    int startX = 0;
    int startY = 0;
    private final EntityPlayer entityPlayer;
    public final InventoryDoubleChestPet inventoryChest;
    private int blockedSlot;
    private int chestInventoryRows;
    private int chestInventoryColumns;
    boolean foid = false;

    public DoubleChestContainer(EntityPlayer entityPlayer, InventoryDoubleChestPet inventoryChest) {
        this.entityPlayer = entityPlayer;
        this.inventoryChest = inventoryChest;
        this.chestInventoryRows = DOUBLELines;
        this.chestInventoryColumns = DOUBLEColumns;
        this.startX = 8;
        this.startY = -7;
        int i = 0;
        for (int chestRowIndex = 0; chestRowIndex < this.chestInventoryRows; ++chestRowIndex) {
            for (int chestColumnIndex = 0; chestColumnIndex < this.chestInventoryColumns; ++chestColumnIndex) {
                this.func_75146_a(new SlotDoubleChest(this, inventoryChest, entityPlayer, chestColumnIndex + chestRowIndex * this.chestInventoryColumns, this.startX + chestColumnIndex * 18, this.startY + chestRowIndex * 18));
                ++i;
            }
        }
        for (int inventoryRowIndex = 0; inventoryRowIndex < 3; ++inventoryRowIndex) {
            for (int inventoryColumnIndex = 0; inventoryColumnIndex < 9; ++inventoryColumnIndex) {
                this.func_75146_a(new Slot((IInventory)entityPlayer.field_71071_by, inventoryColumnIndex + inventoryRowIndex * 9 + 9, 8 + inventoryColumnIndex * 18, 114 + inventoryRowIndex * 18));
            }
        }
        for (int actionBarSlotIndex = 0; actionBarSlotIndex < 9; ++actionBarSlotIndex) {
            this.func_75146_a(new Slot((IInventory)entityPlayer.field_71071_by, actionBarSlotIndex, 8 + actionBarSlotIndex * 18, 172));
        }
        this.blockedSlot = entityPlayer.field_71071_by.field_70461_c + 27 + i;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!player.field_70170_p.field_72995_K) {
            InventoryPlayer invPlayer = player.field_71071_by;
            for (ItemStack itemStack : invPlayer.field_70462_a) {
                if (itemStack == ItemStack.field_190927_a || !NBTHelper.hasTag(itemStack, "chestOpen")) continue;
                NBTHelper.removeTag(itemStack, "chestOpen");
            }
            this.saveInventory(player);
        }
    }

    public boolean isItemStackParent(ItemStack itemStack) {
        if (NBTHelper.hasUUID(itemStack)) {
            UUID stackUUID = new UUID(itemStack.func_77978_p().func_74763_f("UUIDMostSig"), itemStack.func_77978_p().func_74763_f("UUIDLeastSig"));
            return this.inventoryChest.matchesUUID(stackUUID);
        }
        return false;
    }

    public ItemStack func_82846_b(EntityPlayer p, int slotIndex) {
        if (!this.foid) {
            ItemStack newItemStack = ItemStack.field_190927_a;
            Slot slot = (Slot)this.field_75151_b.get(slotIndex);
            if (slot != null && slot.func_75216_d()) {
                ItemStack itemStack = slot.func_75211_c();
                newItemStack = itemStack.func_77946_l();
                if (slotIndex < this.chestInventoryRows * this.chestInventoryColumns ? !this.func_75135_a(itemStack, this.chestInventoryRows * this.chestInventoryColumns, this.field_75151_b.size(), false) : (itemStack.func_77973_b() instanceof petDoubleChest ? (slotIndex < this.chestInventoryRows * this.chestInventoryColumns + 27 ? !this.func_75135_a(itemStack, this.chestInventoryRows * this.chestInventoryColumns + 27, this.field_75151_b.size(), false) : !this.func_75135_a(itemStack, this.chestInventoryRows * this.chestInventoryColumns, this.chestInventoryRows * this.chestInventoryColumns + 27, false)) : !this.func_75135_a(itemStack, 0, this.chestInventoryRows * this.chestInventoryColumns, false))) {
                    return ItemStack.field_190927_a;
                }
                if (itemStack.func_190916_E() == 0) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75218_e();
            }
            return newItemStack;
        }
        return this.transferVoid(p, slotIndex);
    }

    private ItemStack transferVoid(EntityPlayer player, int slotIndex) {
        ItemStack originalStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        int numSlots = this.field_75151_b.size();
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            originalStack = stackInSlot.func_77946_l();
            if ((slotIndex < numSlots - 36 || !this.tryShiftItem(stackInSlot, numSlots)) && (slotIndex >= numSlots - 36 && slotIndex < numSlots - 9 ? !this.shiftItemStack(stackInSlot, numSlots - 9, numSlots) : (slotIndex >= numSlots - 9 && slotIndex < numSlots ? !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots - 9) : !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots)))) {
                return ItemStack.field_190927_a;
            }
            slot.func_75220_a(stackInSlot, originalStack);
            if (stackInSlot.func_190916_E() <= 0) {
                return ItemStack.field_190927_a;
            }
            slot.func_75218_e();
            if (stackInSlot.func_190916_E() == originalStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stackInSlot);
        }
        return originalStack;
    }

    private boolean tryShiftItem(ItemStack stackToShift, int numSlots) {
        for (int machineIndex = 0; machineIndex < numSlots - 36; ++machineIndex) {
            Slot slot = (Slot)this.field_75151_b.get(machineIndex);
            if (!slot.func_75214_a(stackToShift) || !this.shiftItemStack(stackToShift, machineIndex, machineIndex + 1)) continue;
            return true;
        }
        return false;
    }

    protected boolean shiftItemStack(ItemStack stackToShift, int start, int end) {
        ItemStack stackInSlot;
        Slot slot;
        int slotIndex;
        boolean changed = false;
        if (stackToShift.func_77985_e()) {
            for (slotIndex = start; stackToShift.func_190916_E() > 0 && slotIndex < end; ++slotIndex) {
                int max;
                slot = (Slot)this.field_75151_b.get(slotIndex);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot == ItemStack.field_190927_a || !StackUtils.isIdenticalItem(stackInSlot, stackToShift)) continue;
                int resultingstacksize = stackInSlot.func_190916_E() + stackToShift.func_190916_E();
                if (resultingstacksize <= (max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a()))) {
                    stackToShift.func_190920_e(0);
                    stackInSlot.func_190920_e(resultingstacksize);
                    slot.func_75218_e();
                    changed = true;
                    continue;
                }
                if (stackInSlot.func_190916_E() >= max) continue;
                stackToShift.func_190920_e(-max - stackInSlot.func_190916_E());
                stackInSlot.func_190920_e(max);
                slot.func_75218_e();
                changed = true;
            }
        }
        if (stackToShift.func_190916_E() > 0) {
            for (slotIndex = start; stackToShift.func_190916_E() > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot != ItemStack.field_190927_a) continue;
                int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
                stackInSlot = stackToShift.func_77946_l();
                stackInSlot.func_190920_e(Math.min(stackToShift.func_190916_E(), max));
                stackToShift.func_190920_e(-stackInSlot.func_190916_E());
                slot.func_75215_d(stackInSlot);
                slot.func_75218_e();
                changed = true;
            }
        }
        return changed;
    }

    public void saveInventory(EntityPlayer player) {
        this.inventoryChest.onGuiSaved(player);
    }

    public int getNumColumns() {
        return this.chestInventoryRows;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (slotId == this.blockedSlot) {
            return ItemStack.field_190927_a;
        }
        if (clickTypeIn == ClickType.QUICK_MOVE) {
            clickTypeIn = ClickType.PICKUP;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    private class SlotDoubleChest
    extends Slot {
        private final EntityPlayer entityPlayer;
        private DoubleChestContainer containerChest;

        public SlotDoubleChest(DoubleChestContainer containerChest, IInventory inventory, EntityPlayer entityPlayer, int slotIndex, int x, int y) {
            super(inventory, slotIndex, x, y);
            this.entityPlayer = entityPlayer;
            this.containerChest = containerChest;
        }

        public void func_75218_e() {
            super.func_75218_e();
            if (!DoubleChestContainer.this.foid && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                this.containerChest.saveInventory(this.entityPlayer);
            }
        }

        public boolean func_75214_a(ItemStack itemStack) {
            if (itemStack == ItemStack.field_190927_a) {
                return true;
            }
            itemStack = itemStack.func_77946_l();
            itemStack.func_190920_e(1);
            return itemStack.func_77973_b() != InventoryPets.feedBag && itemStack.func_77973_b() != InventoryPets.petChest && itemStack.func_77973_b() != InventoryPets.petDoubleChest && itemStack.func_77973_b() != InventoryPets.petEnderChest;
        }
    }
}

