/*
 * Decompiled with CFR 0.152.
 */
package ftblag.thaumicgrid.network;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.IStorageTracker;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.stack.GridStackItem;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import ftblag.thaumicgrid.grid.gui.GuiThaumicGrid;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.lang3.tuple.Pair;

public class MessageThaumicGridItemDelta
implements IMessage,
IMessageHandler<MessageThaumicGridItemDelta, IMessage> {
    @Nullable
    private INetwork network;
    private IStorageTracker<ItemStack> storageTracker;
    private List<Pair<ItemStack, Integer>> deltas;
    @Nullable
    private ItemStack stack;
    private int delta;
    @Nullable
    private GridStackItem gridStack;
    private List<Pair<GridStackItem, Integer>> gridStacks;

    public MessageThaumicGridItemDelta() {
    }

    public MessageThaumicGridItemDelta(@Nullable INetwork network, IStorageTracker<ItemStack> storageTracker, ItemStack stack, int delta) {
        this.network = network;
        this.storageTracker = storageTracker;
        this.stack = stack;
        this.delta = delta;
    }

    public MessageThaumicGridItemDelta(@Nullable INetwork network, IStorageTracker<ItemStack> storageTracker, List<Pair<ItemStack, Integer>> deltas) {
        this.network = network;
        this.storageTracker = storageTracker;
        this.deltas = deltas;
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        if (size == 1) {
            this.gridStack = new GridStackItem(buf);
            this.delta = buf.readInt();
        } else {
            this.gridStacks = new LinkedList<Pair<GridStackItem, Integer>>();
            for (int i = 0; i < size; ++i) {
                this.gridStacks.add((Pair<GridStackItem, Integer>)Pair.of((Object)new GridStackItem(buf), (Object)buf.readInt()));
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        if (this.stack != null) {
            buf.writeInt(1);
            StackUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack, (INetwork)this.network, (boolean)false);
            IStorageTracker.IStorageTrackerEntry entry = this.storageTracker.get((Object)this.stack);
            buf.writeBoolean(entry != null);
            if (entry != null) {
                buf.writeLong(entry.getTime());
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getName());
            }
            buf.writeInt(this.delta);
        } else {
            buf.writeInt(this.deltas.size());
            for (Pair<ItemStack, Integer> delta : this.deltas) {
                StackUtils.writeItemStack((ByteBuf)buf, (ItemStack)((ItemStack)delta.getLeft()), (INetwork)this.network, (boolean)false);
                IStorageTracker.IStorageTrackerEntry entry = this.storageTracker.get(delta.getLeft());
                buf.writeBoolean(entry != null);
                if (entry != null) {
                    buf.writeLong(entry.getTime());
                    ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getName());
                }
                buf.writeInt(((Integer)delta.getRight()).intValue());
            }
        }
    }

    public IMessage onMessage(MessageThaumicGridItemDelta message, MessageContext ctx) {
        GuiBase.executeLater(GuiThaumicGrid.class, grid -> {
            if (message.gridStack != null) {
                grid.getView().postChange((IGridStack)message.gridStack, message.delta);
            } else {
                message.gridStacks.forEach(p -> grid.getView().postChange((IGridStack)p.getLeft(), ((Integer)p.getRight()).intValue()));
            }
            grid.getView().sort();
        });
        return null;
    }
}

