/*
 * Decompiled with CFR 0.152.
 */
package ftblag.thaumicgrid.grid.network;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridTab;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItem;
import com.raoulvdberge.refinedstorage.api.network.item.NetworkItemAction;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.IFilter;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerFilter;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerNetworkNode;
import com.raoulvdberge.refinedstorage.tile.data.TileDataManager;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import ftblag.thaumicgrid.grid.container.inventory.InventoryThaumicCrafting;
import ftblag.thaumicgrid.grid.handler.ItemThaumicGridHandler;
import ftblag.thaumicgrid.grid.network.IThaumicGrid;
import ftblag.thaumicgrid.grid.storage.StorageCacheListenerThaumicGridItem;
import ftblag.thaumicgrid.grid.tile.TileThaumicGrid;
import ftblag.thaumicgrid.utils.TGUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.crafting.ContainerDummy;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.blocks.world.ore.ShardType;
import thaumcraft.common.items.casters.CasterManager;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import thaumcraft.common.world.aura.AuraChunk;
import thaumcraft.common.world.aura.AuraHandler;

public class NetworkNodeThaumicGrid
extends NetworkNode
implements IThaumicGrid {
    public static final String ID = "thaumic_grid";
    public static final String NBT_VIEW_TYPE = "ViewType";
    public static final String NBT_SORTING_DIRECTION = "SortingDirection";
    public static final String NBT_SORTING_TYPE = "SortingType";
    public static final String NBT_SEARCH_BOX_MODE = "SearchBoxMode";
    public static final String NBT_TAB_SELECTED = "TabSelected";
    public static final String NBT_TAB_PAGE = "TabPage";
    public static final String NBT_SIZE = "Size";
    private static final String NBT_PROCESSING_TYPE = "ProcessingType";
    public Container craftingContainer = new Container(){

        public boolean func_75145_c(EntityPlayer player) {
            return false;
        }
    };
    public IRecipe currentRecipe;
    public int auraVisServer = 0;
    public int auraVisClient = 0;
    private InventoryCrafting matrix = new InventoryThaumicCrafting(this, this.craftingContainer);
    private InventoryCraftResult result = new InventoryCraftResult();
    private List<IFilter> filters = new ArrayList<IFilter>();
    private List<IGridTab> tabs = new ArrayList<IGridTab>();
    private ItemHandlerFilter filter = new ItemHandlerFilter(this.filters, this.tabs, (Consumer)new ListenerNetworkNode((INetworkNode)this));
    private int viewType = 0;
    private int sortingDirection = 1;
    private int sortingType = 0;
    private int searchBoxMode = 0;
    private int size = 0;
    private int tabSelected = -1;
    private int tabPage = 0;
    private int processingType = 0;

    public NetworkNodeThaumicGrid(World world, BlockPos pos) {
        super(world, pos);
    }

    public static void onRecipeTransfer(IThaumicGrid grid, EntityPlayer player, ItemStack[][] recipe) {
        boolean found;
        ItemStack[] possibilities;
        int i;
        INetwork network = grid.getNetwork();
        if (network != null && !network.getSecurityManager().hasPermission(Permission.EXTRACT, player)) {
            return;
        }
        for (i = 0; i < 9; ++i) {
            ItemStack slot = grid.getCraftingMatrix().func_70301_a(i);
            if (slot.func_190926_b()) continue;
            if (network != null) {
                if (network.insertItem(slot, slot.func_190916_E(), Action.SIMULATE) != null) {
                    return;
                }
                network.insertItem(slot, slot.func_190916_E(), Action.PERFORM);
            } else if (!player.field_71071_by.func_70441_a(slot.func_77946_l())) {
                return;
            }
            grid.getCraftingMatrix().func_70299_a(i, ItemStack.field_190927_a);
        }
        block1: for (i = 0; i < 9; ++i) {
            if (recipe[i] == null) continue;
            possibilities = recipe[i];
            found = false;
            if (network != null) {
                ItemStack[] itemStackArray = possibilities;
                int n = itemStackArray.length;
                for (int j = 0; j < n; ++j) {
                    ItemStack possibility;
                    ItemStack took = network.extractItem(possibility, 1, 2 | ((possibility = itemStackArray[j]).func_77973_b().func_77645_m() ? 0 : 1), Action.PERFORM);
                    if (took == null) continue;
                    grid.getCraftingMatrix().func_70299_a(i, StackUtils.nullToEmpty((ItemStack)took));
                    found = true;
                    break;
                }
            }
            if (found) continue;
            for (ItemStack possibility : possibilities) {
                for (int j = 0; j < player.field_71071_by.func_70302_i_(); ++j) {
                    if (!API.instance().getComparer().isEqual(possibility, player.field_71071_by.func_70301_a(j), 2 | (possibility.func_77973_b().func_77645_m() ? 0 : 1))) continue;
                    grid.getCraftingMatrix().func_70299_a(i, ItemHandlerHelper.copyStackWithSize((ItemStack)player.field_71071_by.func_70301_a(j), (int)1));
                    player.field_71071_by.func_70298_a(j, 1);
                    found = true;
                    break;
                }
                if (found) continue block1;
            }
        }
        if (recipe.length > 9) {
            block5: for (i = 9; i < recipe.length; ++i) {
                if (recipe[i] == null) continue;
                possibilities = recipe[i];
                found = false;
                if (network != null) {
                    for (ItemStack possibility : possibilities) {
                        int slotTo = -1;
                        for (ShardType st : ShardType.values()) {
                            if (st.getMetadata() >= 6 || TGUtils.getAspect0(possibility) != st.getAspect()) continue;
                            slotTo = 9 + st.getMetadata();
                        }
                        if (slotTo == -1) {
                            throw new Error("Report to this to mod author!");
                        }
                        if (grid.getCraftingMatrix().func_70301_a(slotTo).func_190916_E() >= possibility.func_190916_E()) continue;
                        int sizeOnGrid = grid.getCraftingMatrix().func_70301_a(slotTo).func_190916_E();
                        ItemStack took = network.extractItem(possibility, i > 8 ? possibility.func_190916_E() : 1, 2 | (possibility.func_77973_b().func_77645_m() ? 0 : 1), Action.PERFORM);
                        if (took == null) continue;
                        ItemStack stackTo = StackUtils.nullToEmpty((ItemStack)took);
                        stackTo.func_190920_e(stackTo.func_190916_E() + sizeOnGrid);
                        grid.getCraftingMatrix().func_70299_a(slotTo, stackTo);
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                for (ItemStack possibility : possibilities) {
                    int slotTo = -1;
                    for (ShardType st : ShardType.values()) {
                        if (st.getMetadata() >= 6 || TGUtils.getAspect0(possibility) != st.getAspect()) continue;
                        slotTo = 9 + st.getMetadata();
                    }
                    if (slotTo == -1) {
                        throw new Error("Report to this to mod author!");
                    }
                    if (grid.getCraftingMatrix().func_70301_a(slotTo).func_190916_E() >= possibility.func_190916_E()) continue;
                    int sizeOnGrid = grid.getCraftingMatrix().func_70301_a(slotTo).func_190916_E();
                    for (int j = 0; j < player.field_71071_by.func_70302_i_(); ++j) {
                        if (!API.instance().getComparer().isEqual(possibility, player.field_71071_by.func_70301_a(j), 2 | (possibility.func_77973_b().func_77645_m() ? 0 : 1))) continue;
                        grid.getCraftingMatrix().func_70299_a(slotTo, ItemHandlerHelper.copyStackWithSize((ItemStack)player.field_71071_by.func_70301_a(j), (int)(1 + sizeOnGrid)));
                        player.field_71071_by.func_70298_a(j, 1);
                        found = true;
                        break;
                    }
                    if (found) continue block5;
                }
            }
        }
    }

    public static void onCrafted(IThaumicGrid grid, World world, EntityPlayer player) {
        INetworkItem networkItem;
        NonNullList remainder;
        InventoryCrafting matrix = grid.getCraftingMatrix();
        IArcaneRecipe recipe = ThaumcraftCraftingManager.findMatchingArcaneRecipe((InventoryCrafting)matrix, (EntityPlayer)player);
        InventoryCrafting ic = matrix;
        if (recipe != null) {
            remainder = CraftingManager.func_180303_b((InventoryCrafting)matrix, (World)player.field_70170_p);
        } else {
            ic = new InventoryCrafting((Container)new ContainerDummy(), 3, 3);
            for (int a = 0; a < 9; ++a) {
                ic.func_70299_a(a, matrix.func_70301_a(a));
            }
            TGUtils.setEH(ic, TGUtils.getEH(matrix));
            remainder = CraftingManager.func_180303_b((InventoryCrafting)ic, (World)player.field_70170_p);
        }
        AspectList crystals = null;
        if (recipe != null) {
            int vis = recipe.getVis();
            vis = (int)((float)vis * (1.0f - CasterManager.getTotalVisDiscount((EntityPlayer)player)));
            crystals = recipe.getCrystals();
            if (vis > 0) {
                grid.getAura();
                grid.spendAura(vis);
            }
        }
        INetwork network = grid.getNetwork();
        for (int i = 0; i < 9; ++i) {
            ItemStack slot = ic.func_70301_a(i);
            if (i < remainder.size() && !((ItemStack)remainder.get(i)).func_190926_b()) {
                if (!slot.func_190926_b() && slot.func_190916_E() > 1) {
                    if (!player.field_71071_by.func_70441_a(((ItemStack)remainder.get(i)).func_77946_l())) {
                        ItemStack remainderStack;
                        ItemStack itemStack = remainderStack = network == null ? ((ItemStack)remainder.get(i)).func_77946_l() : network.insertItem(((ItemStack)remainder.get(i)).func_77946_l(), ((ItemStack)remainder.get(i)).func_190916_E(), Action.PERFORM);
                        if (remainderStack != null) {
                            InventoryHelper.func_180173_a((World)player.func_130014_f_(), (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)remainderStack);
                        }
                    }
                    matrix.func_70298_a(i, 1);
                    continue;
                }
                matrix.func_70299_a(i, ((ItemStack)remainder.get(i)).func_77946_l());
                continue;
            }
            if (slot.func_190926_b()) continue;
            if (slot.func_190916_E() == 1 && network != null) {
                matrix.func_70299_a(i, StackUtils.nullToEmpty((ItemStack)network.extractItem(slot, 1, Action.PERFORM)));
                continue;
            }
            matrix.func_70298_a(i, 1);
        }
        if (crystals != null) {
            for (Aspect aspect : crystals.getAspects()) {
                ItemStack cs = ThaumcraftApiHelper.makeCrystal((Aspect)aspect, (int)crystals.getAmount(aspect));
                for (int j = 0; j < 6; ++j) {
                    ItemStack itemstack3 = matrix.func_70301_a(9 + j);
                    if (itemstack3.func_77973_b() != ItemsTC.crystalEssence || !ItemStack.func_77970_a((ItemStack)cs, (ItemStack)itemstack3)) continue;
                    if (itemstack3.func_190916_E() <= cs.func_190916_E() && network != null) {
                        matrix.func_70299_a(9 + j, StackUtils.nullToEmpty((ItemStack)network.extractItem(itemstack3, cs.func_190916_E(), Action.PERFORM)));
                        continue;
                    }
                    matrix.func_70298_a(9 + j, cs.func_190916_E());
                }
            }
        }
        if (network != null && (networkItem = network.getNetworkItemHandler().getItem(player)) != null) {
            networkItem.onAction(NetworkItemAction.ITEM_CRAFTED);
        }
    }

    public static void onCraftedShift(IThaumicGrid grid, EntityPlayer player) {
        player.func_145747_a((ITextComponent)new TextComponentString("Craft with shift temporary not working!"));
    }

    public int getEnergyUsage() {
        return RS.INSTANCE.config.craftingGridUsage;
    }

    @Override
    public IStorageCacheListener createListener(EntityPlayerMP player) {
        return new StorageCacheListenerThaumicGridItem(player, this.network);
    }

    @Override
    @Nullable
    public IStorageCache getStorageCache() {
        return this.network != null ? this.network.getItemStorageCache() : null;
    }

    @Override
    @Nullable
    public IItemGridHandler getItemHandler() {
        return this.network != null ? new ItemThaumicGridHandler(this.network) : null;
    }

    @Override
    public String getGuiTitle() {
        return "gui.thaumicgrid:thaumic_grid";
    }

    @Override
    public IItemHandlerModifiable getFilter() {
        return this.filter;
    }

    @Override
    public List<IFilter> getFilters() {
        return this.filters;
    }

    @Override
    public List<IGridTab> getTabs() {
        return this.tabs;
    }

    @Override
    public InventoryCrafting getCraftingMatrix() {
        return this.matrix;
    }

    @Override
    public InventoryCraftResult getCraftingResult() {
        return this.result;
    }

    @Override
    public void onRecipeTransfer(EntityPlayer player, ItemStack[][] recipe) {
        NetworkNodeThaumicGrid.onRecipeTransfer(this, player, recipe);
    }

    @Override
    public void onClosed(EntityPlayer player) {
    }

    @Override
    public void onCrafted(EntityPlayer player) {
        NetworkNodeThaumicGrid.onCrafted(this, this.world, player);
    }

    @Override
    public void onCraftedShift(EntityPlayer player) {
        NetworkNodeThaumicGrid.onCraftedShift(this, player);
    }

    @Override
    public int getViewType() {
        return this.world.field_72995_K ? (Integer)TileThaumicGrid.VIEW_TYPE.getValue() : this.viewType;
    }

    public void setViewType(int viewType) {
        this.viewType = viewType;
    }

    @Override
    public int getSortingDirection() {
        return this.world.field_72995_K ? (Integer)TileThaumicGrid.SORTING_DIRECTION.getValue() : this.sortingDirection;
    }

    public void setSortingDirection(int sortingDirection) {
        this.sortingDirection = sortingDirection;
    }

    @Override
    public int getSortingType() {
        return this.world.field_72995_K ? (Integer)TileThaumicGrid.SORTING_TYPE.getValue() : this.sortingType;
    }

    public void setSortingType(int sortingType) {
        this.sortingType = sortingType;
    }

    @Override
    public int getSearchBoxMode() {
        return this.world.field_72995_K ? (Integer)TileThaumicGrid.SEARCH_BOX_MODE.getValue() : this.searchBoxMode;
    }

    public void setSearchBoxMode(int searchBoxMode) {
        this.searchBoxMode = searchBoxMode;
    }

    @Override
    public int getSize() {
        return this.world.field_72995_K ? (Integer)TileThaumicGrid.SIZE.getValue() : this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public int getTabSelected() {
        return this.world.field_72995_K ? (Integer)TileThaumicGrid.TAB_SELECTED.getValue() : this.tabSelected;
    }

    public void setTabSelected(int tabSelected) {
        this.tabSelected = tabSelected;
    }

    @Override
    public int getTabPage() {
        return this.world.field_72995_K ? (Integer)TileThaumicGrid.TAB_PAGE.getValue() : Math.min(this.tabPage, this.getTotalTabPages());
    }

    public void setTabPage(int page) {
        this.tabPage = page;
    }

    @Override
    public int getTotalTabPages() {
        return (int)Math.floor((float)Math.max(0, this.tabs.size() - 1) / 6.0f);
    }

    @Override
    public void onViewTypeChanged(int type) {
        TileDataManager.setParameter(TileThaumicGrid.VIEW_TYPE, (Object)type);
    }

    @Override
    public void onSortingTypeChanged(int type) {
        TileDataManager.setParameter(TileThaumicGrid.SORTING_TYPE, (Object)type);
    }

    @Override
    public void onSortingDirectionChanged(int direction) {
        TileDataManager.setParameter(TileThaumicGrid.SORTING_DIRECTION, (Object)direction);
    }

    @Override
    public void onSearchBoxModeChanged(int searchBoxMode) {
        TileDataManager.setParameter(TileThaumicGrid.SEARCH_BOX_MODE, (Object)searchBoxMode);
    }

    @Override
    public void onSizeChanged(int size) {
        TileDataManager.setParameter(TileThaumicGrid.SIZE, (Object)size);
    }

    @Override
    public void onTabSelectionChanged(int tab) {
        TileDataManager.setParameter(TileThaumicGrid.TAB_SELECTED, (Object)tab);
    }

    @Override
    public void onTabPageChanged(int page) {
        if (page >= 0 && page <= this.getTotalTabPages()) {
            TileDataManager.setParameter(TileThaumicGrid.TAB_PAGE, (Object)page);
        }
    }

    public boolean hasConnectivityState() {
        return true;
    }

    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IInventory)this.matrix, (int)0, (NBTTagCompound)tag);
        StackUtils.readItems((IItemHandlerModifiable)this.filter, (int)1, (NBTTagCompound)tag);
        if (tag.func_74764_b(NBT_TAB_SELECTED)) {
            this.tabSelected = tag.func_74762_e(NBT_TAB_SELECTED);
        }
        if (tag.func_74764_b(NBT_TAB_PAGE)) {
            this.tabPage = tag.func_74762_e(NBT_TAB_PAGE);
        }
    }

    public String getId() {
        return ID;
    }

    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IInventory)this.matrix, (int)0, (NBTTagCompound)tag);
        StackUtils.writeItems((IItemHandler)this.filter, (int)1, (NBTTagCompound)tag);
        tag.func_74768_a(NBT_TAB_SELECTED, this.tabSelected);
        tag.func_74768_a(NBT_TAB_PAGE, this.tabPage);
        return tag;
    }

    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_VIEW_TYPE, this.viewType);
        tag.func_74768_a(NBT_SORTING_DIRECTION, this.sortingDirection);
        tag.func_74768_a(NBT_SORTING_TYPE, this.sortingType);
        tag.func_74768_a(NBT_SEARCH_BOX_MODE, this.searchBoxMode);
        tag.func_74768_a(NBT_SIZE, this.size);
        tag.func_74768_a(NBT_PROCESSING_TYPE, this.processingType);
        return tag;
    }

    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_VIEW_TYPE)) {
            this.viewType = tag.func_74762_e(NBT_VIEW_TYPE);
        }
        if (tag.func_74764_b(NBT_SORTING_DIRECTION)) {
            this.sortingDirection = tag.func_74762_e(NBT_SORTING_DIRECTION);
        }
        if (tag.func_74764_b(NBT_SORTING_TYPE)) {
            this.sortingType = tag.func_74762_e(NBT_SORTING_TYPE);
        }
        if (tag.func_74764_b(NBT_SEARCH_BOX_MODE)) {
            this.searchBoxMode = tag.func_74762_e(NBT_SEARCH_BOX_MODE);
        }
        if (tag.func_74764_b(NBT_SIZE)) {
            this.size = tag.func_74762_e(NBT_SIZE);
        }
        if (tag.func_74764_b(NBT_PROCESSING_TYPE)) {
            this.processingType = tag.func_74762_e(NBT_PROCESSING_TYPE);
        }
    }

    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.filter, new InvWrapper((IInventory)this.matrix)});
    }

    @Override
    public void getAura() {
        if (!this.getWorld().field_72995_K) {
            int t = 0;
            if (this.world.func_180495_p(this.getPos().func_177977_b()).func_177230_c() == BlocksTC.arcaneWorkbenchCharger) {
                int sx = this.pos.func_177958_n() >> 4;
                int sz = this.pos.func_177952_p() >> 4;
                for (int xx = -1; xx <= 1; ++xx) {
                    for (int zz = -1; zz <= 1; ++zz) {
                        AuraChunk ac = AuraHandler.getAuraChunk((int)this.world.field_73011_w.getDimension(), (int)(sx + xx), (int)(sz + zz));
                        if (ac == null) continue;
                        t += (int)ac.getVis();
                    }
                }
            } else {
                t = (int)AuraHandler.getVis((World)this.getWorld(), (BlockPos)this.getPos());
            }
            this.auraVisServer = t;
        }
    }

    @Override
    public void spendAura(int vis) {
        block8: {
            if (!this.getWorld().field_72995_K) {
                if (this.world.func_180495_p(this.getPos().func_177977_b()).func_177230_c() == BlocksTC.arcaneWorkbenchCharger) {
                    int q = vis;
                    int z = Math.max(1, vis / 9);
                    int attempts = 0;
                    while (q > 0) {
                        ++attempts;
                        for (int xx = -1; xx <= 1; ++xx) {
                            for (int zz = -1; zz <= 1; ++zz) {
                                if (z > q) {
                                    z = q;
                                }
                                if ((q -= (int)AuraHandler.drainVis((World)this.getWorld(), (BlockPos)this.getPos().func_177982_a(xx * 16, 0, zz * 16), (float)z, (boolean)false)) > 0 && attempts <= 1000) {
                                    continue;
                                }
                                break block8;
                            }
                        }
                    }
                } else {
                    AuraHandler.drainVis((World)this.getWorld(), (BlockPos)this.getPos(), (float)vis, (boolean)false);
                }
            }
        }
    }
}

