/*
 * Decompiled with CFR 0.152.
 */
package ftblag.thaumicgrid.grid.gui.view;

import com.raoulvdberge.refinedstorage.gui.grid.stack.GridStackItem;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import ftblag.thaumicgrid.grid.gui.GuiThaumicGrid;
import ftblag.thaumicgrid.grid.gui.sorting.IThaumicGridSorter;
import ftblag.thaumicgrid.grid.gui.view.ThaumicGridViewBase;
import java.util.List;

public class ThaumicGridViewItem
extends ThaumicGridViewBase {
    public ThaumicGridViewItem(GuiThaumicGrid gui, IThaumicGridSorter defaultSorter, List<IThaumicGridSorter> sorters) {
        super(gui, defaultSorter, sorters);
    }

    public void setStacks(List<IGridStack> stacks) {
        this.map.clear();
        for (IGridStack stack : stacks) {
            if (stack.doesDisplayCraftText() && this.map.containsKey(stack.getHash())) continue;
            this.map.put(stack.getHash(), stack);
        }
    }

    public void postChange(IGridStack stack, int delta) {
        if (!(stack instanceof GridStackItem)) {
            return;
        }
        GridStackItem existing = (GridStackItem)this.map.get(stack.getHash());
        if (existing == null) {
            ((GridStackItem)stack).getStack().func_190920_e(delta);
            this.map.put(stack.getHash(), stack);
        } else {
            if (existing.getStack().func_190916_E() + delta <= 0) {
                if (existing.isCraftable()) {
                    existing.setDisplayCraftText(true);
                } else {
                    this.map.remove(existing.getHash());
                }
            } else if (existing.doesDisplayCraftText()) {
                existing.setDisplayCraftText(false);
                existing.getStack().func_190920_e(delta);
            } else {
                existing.getStack().func_190917_f(delta);
            }
            existing.setTrackerEntry(stack.getTrackerEntry());
        }
    }
}

