/*
 * Decompiled with CFR 0.152.
 */
package ftblag.thaumicgrid.grid.gui.view;

import com.raoulvdberge.refinedstorage.gui.grid.sorting.GridSorterDirection;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.gui.grid.view.IGridView;
import ftblag.thaumicgrid.grid.gui.GuiThaumicGrid;
import ftblag.thaumicgrid.grid.gui.filtering.ThaumicGridFilterParser;
import ftblag.thaumicgrid.grid.gui.sorting.IThaumicGridSorter;
import ftblag.thaumicgrid.grid.network.IThaumicGrid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public abstract class ThaumicGridViewBase
implements IGridView {
    protected Map<Integer, IGridStack> map = new HashMap<Integer, IGridStack>();
    private GuiThaumicGrid gui;
    private boolean canCraft;
    private IThaumicGridSorter defaultSorter;
    private List<IThaumicGridSorter> sorters;
    private List<IGridStack> stacks = new ArrayList<IGridStack>();

    public ThaumicGridViewBase(GuiThaumicGrid gui, IThaumicGridSorter defaultSorter, List<IThaumicGridSorter> sorters) {
        this.gui = gui;
        this.defaultSorter = defaultSorter;
        this.sorters = sorters;
    }

    public List<IGridStack> getStacks() {
        return this.stacks;
    }

    public void sort() {
        ArrayList<IGridStack> stacks = new ArrayList<IGridStack>();
        if (this.gui.getGrid().isActive()) {
            stacks.addAll(this.map.values());
            IThaumicGrid grid = this.gui.getGrid();
            List<Predicate<IGridStack>> filters = ThaumicGridFilterParser.getFilters(grid, this.gui.getSearchField() != null ? this.gui.getSearchField().func_146179_b() : "", grid.getTabSelected() >= 0 && grid.getTabSelected() < grid.getTabs().size() ? grid.getTabs().get(grid.getTabSelected()).getFilters() : grid.getFilters());
            Iterator it = stacks.iterator();
            block0: while (it.hasNext()) {
                IGridStack stack = (IGridStack)it.next();
                for (Predicate<IGridStack> filter : filters) {
                    if (filter.test(stack)) continue;
                    it.remove();
                    continue block0;
                }
            }
            GridSorterDirection sortingDirection = grid.getSortingDirection() == 1 ? GridSorterDirection.DESCENDING : GridSorterDirection.ASCENDING;
            stacks.sort((left, right) -> this.defaultSorter.compare((IGridStack)left, (IGridStack)right, sortingDirection));
            for (IThaumicGridSorter sorter : this.sorters) {
                if (!sorter.isApplicable(grid)) continue;
                stacks.sort((left, right) -> sorter.compare((IGridStack)left, (IGridStack)right, sortingDirection));
            }
        }
        this.stacks = stacks;
        this.gui.updateScrollbar();
    }

    public void setCanCraft(boolean canCraft) {
        this.canCraft = canCraft;
    }

    public boolean canCraft() {
        return this.canCraft;
    }
}

