/*
 * Decompiled with CFR 0.152.
 */
package ftblag.thaumicgrid.grid.gui.filtering;

import com.raoulvdberge.refinedstorage.api.util.IFilter;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterCraftable;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterFilter;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterMod;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterName;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterOr;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterOreDict;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterTooltip;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import ftblag.thaumicgrid.grid.network.IThaumicGrid;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class ThaumicGridFilterParser {
    public static List<Predicate<IGridStack>> getFilters(@Nullable IThaumicGrid grid, String query, List<IFilter> filters) {
        List<Predicate<IGridStack>> gridFilters;
        String[] orParts = query.split("\\|");
        if (orParts.length == 1) {
            gridFilters = ThaumicGridFilterParser.getFilters(query);
        } else {
            LinkedList<List<Predicate<IGridStack>>> orPartFilters = new LinkedList<List<Predicate<IGridStack>>>();
            for (String orPart : orParts) {
                orPartFilters.add(ThaumicGridFilterParser.getFilters(orPart));
            }
            gridFilters = new LinkedList<Predicate<IGridStack>>();
            gridFilters.add((Predicate<IGridStack>)new GridFilterOr(orPartFilters));
        }
        if (grid != null) {
            if (grid.getViewType() == 1) {
                gridFilters.add((Predicate<IGridStack>)new GridFilterCraftable(false));
            } else if (grid.getViewType() == 2) {
                gridFilters.add((Predicate<IGridStack>)new GridFilterCraftable(true));
            }
        }
        if (!filters.isEmpty()) {
            gridFilters.add((Predicate<IGridStack>)new GridFilterFilter(filters));
        }
        return gridFilters;
    }

    private static List<Predicate<IGridStack>> getFilters(String query) {
        LinkedList<Predicate<IGridStack>> gridFilters = new LinkedList<Predicate<IGridStack>>();
        for (String part : query.toLowerCase().trim().split(" ")) {
            if (part.startsWith("@")) {
                gridFilters.add((Predicate<IGridStack>)new GridFilterMod(part.substring(1)));
                continue;
            }
            if (part.startsWith("#")) {
                gridFilters.add((Predicate<IGridStack>)new GridFilterTooltip(part.substring(1)));
                continue;
            }
            if (part.startsWith("$")) {
                gridFilters.add((Predicate<IGridStack>)new GridFilterOreDict(part.substring(1)));
                continue;
            }
            gridFilters.add((Predicate<IGridStack>)new GridFilterName(part));
        }
        return gridFilters;
    }
}

