/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.wires.logic;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.api.wires.IRedstoneEmitter;
import pl.asie.charset.api.wires.IRedstoneReceiver;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.api.wires.WireType;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.stagingapi.ISignalMeterData;
import pl.asie.charset.lib.wires.IWireContainer;
import pl.asie.charset.lib.wires.SignalMeterDataWire;
import pl.asie.charset.lib.wires.Wire;
import pl.asie.charset.lib.wires.WireProvider;
import pl.asie.charset.lib.wires.WireUtils;
import pl.asie.simplelogic.wires.LogicWireUtils;
import pl.asie.simplelogic.wires.SimpleLogicWires;
import pl.asie.simplelogic.wires.logic.PartWireSignalBase;
import pl.asie.simplelogic.wires.logic.PropagationQueue;

public class PartWireNormal
extends PartWireSignalBase
implements IRedstoneEmitter,
IRedstoneReceiver {
    private static final ResourceLocation REDSTONE_PASTE_BLOCK = new ResourceLocation("redstonepaste:redstonepaste");
    private int signalLevel;

    public PartWireNormal(@Nonnull IWireContainer container, @Nonnull WireProvider factory, @Nonnull WireFace location) {
        super(container, factory, location);
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderColor() {
        int signalValue = this.signalLevel >> 8;
        int v = (signalValue > 0 ? 150 : 120) + signalValue * 7;
        return 0xFF000000 | v * 65793;
    }

    @Override
    public void readNBTData(NBTTagCompound nbt, boolean isClient) {
        super.readNBTData(nbt, isClient);
        if (nbt.func_150297_b("s", 99)) {
            this.signalLevel = nbt.func_74765_d("s");
        }
    }

    @Override
    public NBTTagCompound writeNBTData(NBTTagCompound nbt, boolean isClient) {
        super.writeNBTData(nbt, isClient);
        nbt.func_74777_a("s", (short)this.signalLevel);
        return nbt;
    }

    @Override
    protected void onSignalChanged(int color, boolean clearMode) {
        if (this.getContainer().world() != null && this.getContainer().pos() != null && !this.getContainer().world().field_72995_K) {
            PropagationQueue queue = new PropagationQueue(clearMode);
            queue.add(this, -1);
            queue.propagate();
        }
    }

    protected int getWireRedstoneLevel(IBlockAccess world, BlockPos pos, WireFace location) {
        Wire wire = WireUtils.getWire((IBlockAccess)world, (BlockPos)pos, (WireFace)location);
        return wire instanceof PartWireSignalBase ? ((PartWireSignalBase)wire).getSignalLevel() : 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void propagate(int color, PropagationQueue queue) {
        Wire wire;
        if (DEBUG) {
            System.out.println("--- PROPAGATE " + this.getContainer().pos().toString() + " " + this.getLocation().name() + " (" + this.getContainer().world().func_82737_E() + ") ---");
        }
        color = this.getColor();
        boolean[] isWire = new boolean[7];
        int[] neighborLevel = new int[7];
        int maxSignal = 0;
        int oldSignal = this.signalLevel;
        PartWireSignalBase.PROPAGATING = true;
        if (this.getWireType() == WireType.NORMAL && this.getLocation() != WireFace.CENTER) {
            IBlockState state;
            EnumFacing[] facing = this.getLocation().facing;
            BlockPos pos = this.getContainer().pos().func_177972_a((EnumFacing)facing);
            int power = LogicWireUtils.getWeakRedstoneLevel(this, pos, state = this.getContainer().world().func_180495_p(pos), (EnumFacing)facing, this.getLocation());
            if (power < 15) {
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    Block block;
                    if (enumfacing == facing.func_176734_d() || (block = (state = this.getContainer().world().func_180495_p(pos.func_177972_a(enumfacing))).func_177230_c()) instanceof BlockRedstoneWire) continue;
                    int currPower = LogicWireUtils.getStrongRedstoneLevel(this, pos.func_177972_a(enumfacing), state, enumfacing, this.getLocation());
                    if (currPower >= 15) {
                        power = 15;
                        break;
                    }
                    if (currPower <= power) continue;
                    power = currPower;
                }
            }
            if (power > 0) {
                neighborLevel[facing.ordinal()] = Math.min(power, 15) << 8 | 0xFF;
            }
        }
        for (EnumFacing location : WireFace.VALUES) {
            if (!this.connectsInternal((WireFace)location)) continue;
            isWire[location.ordinal()] = true;
            neighborLevel[location.ordinal()] = this.getWireRedstoneLevel((IBlockAccess)this.getContainer().world(), this.getContainer().pos(), (WireFace)location);
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            int n = facing.ordinal();
            if (this.connectsExternal(facing)) {
                BlockPos pos = this.getContainer().pos().func_177972_a(facing);
                Wire wire2 = WireUtils.getWire((IBlockAccess)this.getContainer().world(), (BlockPos)pos, (WireFace)this.getLocation());
                if (wire2 instanceof PartWireSignalBase) {
                    isWire[n] = true;
                    neighborLevel[n] = this.getWireRedstoneLevel((IBlockAccess)this.getContainer().world(), pos, this.getLocation());
                    continue;
                }
                IBlockState state = this.getContainer().world().func_180495_p(pos);
                int power = LogicWireUtils.getWeakRedstoneLevel(this, pos, state, facing, this.getLocation());
                if (state.func_177230_c() instanceof BlockRedstoneWire || state.func_177230_c().getRegistryName().equals((Object)REDSTONE_PASTE_BLOCK)) {
                    isWire[n] = true;
                    --power;
                }
                if (power <= 0) continue;
                neighborLevel[n] = Math.min(power, 15) << 8 | 0xFF;
                continue;
            }
            if (!this.connectsCorner(facing)) continue;
            BlockPos pos = this.getContainer().pos().func_177972_a(facing).func_177972_a(this.getLocation().facing);
            Wire wire3 = WireUtils.getWire((IBlockAccess)this.getContainer().world(), (BlockPos)pos, (WireFace)WireFace.get((EnumFacing)facing.func_176734_d()));
            if (!(wire3 instanceof PartWireSignalBase)) continue;
            isWire[n] = true;
            neighborLevel[n] = this.getWireRedstoneLevel((IBlockAccess)this.getContainer().world(), pos, WireFace.get((EnumFacing)facing.func_176734_d()));
        }
        PartWireSignalBase.PROPAGATING = false;
        int maxSignalNonWire = 0;
        for (int i = 0; i < 7; ++i) {
            if (neighborLevel[i] > maxSignal) {
                maxSignal = neighborLevel[i];
            }
            if (isWire[i] || neighborLevel[i] <= maxSignalNonWire) continue;
            maxSignalNonWire = neighborLevel[i];
        }
        if (DEBUG) {
            System.out.println("Levels: " + Arrays.toString(neighborLevel));
            System.out.println("IsWire: " + Arrays.toString(isWire));
        }
        if (maxSignal > this.signalLevel && !queue.clearMode) {
            this.signalLevel = maxSignal - 1;
            if ((this.signalLevel & 0xFF) == 0 || (this.signalLevel & 0xFF) == 255) {
                this.signalLevel = 0;
            }
        } else {
            this.signalLevel = maxSignalNonWire;
        }
        if (oldSignal == this.signalLevel) {
            return;
        }
        if (DEBUG) {
            System.out.println("Switch: " + oldSignal + " -> " + this.signalLevel + " " + this.getContainer().pos() + " " + this.getContainer().world().func_82737_E());
        }
        if (this.signalLevel == 0) {
            void var11_22;
            PropagationQueue queueToAdd = queue.clearMode ? queue : new PropagationQueue(true);
            WireFace[] wireFaceArray = WireFace.VALUES;
            int n = wireFaceArray.length;
            boolean bl = false;
            while (var11_22 < n) {
                WireFace nLoc = wireFaceArray[var11_22];
                if (this.connectsInternal(nLoc)) {
                    Wire wire4;
                    if (neighborLevel[nLoc.ordinal()] > 0 && (wire4 = WireUtils.getWire((IBlockAccess)this.getContainer().world(), (BlockPos)this.getContainer().pos(), (WireFace)nLoc)) instanceof PartWireSignalBase) {
                        queueToAdd.add((PartWireSignalBase)wire4, color);
                    }
                } else if (nLoc != WireFace.CENTER) {
                    EnumFacing facing = nLoc.facing;
                    if (this.connectsExternal(facing)) {
                        wire = WireUtils.getWire((IBlockAccess)this.getContainer().world(), (BlockPos)this.getContainer().pos().func_177972_a(facing), (WireFace)this.getLocation());
                        if (!(wire instanceof PartWireSignalBase) || neighborLevel[facing.ordinal()] > 0) {
                            this.propagateNotify(facing, queueToAdd, color);
                        }
                    } else if (this.connectsCorner(facing) && neighborLevel[nLoc.ordinal()] > 0) {
                        this.propagateNotifyCorner(this.getLocation().facing, facing, queueToAdd, color);
                    }
                }
                ++var11_22;
            }
            if (queueToAdd != queue) {
                queueToAdd.propagate();
            }
        } else {
            for (WireFace wireFace : WireFace.VALUES) {
                boolean nChanged;
                boolean bl = nChanged = neighborLevel[wireFace.ordinal()] < this.signalLevel - 1 || neighborLevel[wireFace.ordinal()] > this.signalLevel + 1;
                if (this.connectsInternal(wireFace)) {
                    Wire wire5;
                    if (!nChanged || !((wire5 = WireUtils.getWire((IBlockAccess)this.getContainer().world(), (BlockPos)this.getContainer().pos(), (WireFace)wireFace)) instanceof PartWireSignalBase)) continue;
                    queue.add((PartWireSignalBase)wire5, color);
                    continue;
                }
                if (wireFace == WireFace.CENTER) continue;
                EnumFacing facing = wireFace.facing;
                if (this.connectsExternal(facing)) {
                    wire = WireUtils.getWire((IBlockAccess)this.getContainer().world(), (BlockPos)this.getContainer().pos().func_177972_a(facing), (WireFace)this.getLocation());
                    if (wire instanceof PartWireSignalBase && !nChanged) continue;
                    this.propagateNotify(facing, queue, color);
                    continue;
                }
                if (!this.connectsCorner(facing) || !nChanged) continue;
                this.propagateNotifyCorner(this.getLocation().facing, facing, queue, color);
            }
        }
        if (this.getWireType() == WireType.NORMAL) {
            for (WireFace wireFace : EnumFacing.field_82609_l) {
                if (wireFace != this.getLocation().facing && (this.connectsExternal((EnumFacing)wireFace) || this.connectsCorner((EnumFacing)wireFace))) continue;
                TileEntity nt = this.getContainer().world().func_175625_s(this.getContainer().pos().func_177972_a((EnumFacing)wireFace));
                if (nt == null || !nt.hasCapability(Capabilities.REDSTONE_RECEIVER, wireFace.func_176734_d())) {
                    this.neighborChanged(this.getContainer().pos().func_177972_a((EnumFacing)wireFace));
                }
                if (wireFace != this.getLocation().facing) continue;
                EnumFacing facingO = wireFace.func_176734_d();
                for (EnumFacing facing2 : EnumFacing.field_82609_l) {
                    if (facing2 == facingO) continue;
                    this.neighborChanged(this.getContainer().pos().func_177972_a((EnumFacing)wireFace).func_177972_a(facing2));
                }
            }
        }
        if ((oldSignal & 0xF00) != (this.signalLevel & 0xF00)) {
            if (this.getWireType() == WireType.NORMAL || PartWireSignalBase.DEBUG_CLIENT_WIRE_STATE) {
                if (SimpleLogicWires.useTESRs) {
                    this.getContainer().requestNetworkUpdate();
                } else {
                    this.getContainer().requestRenderUpdate();
                }
            }
            if (this.getLocation() != WireFace.CENTER) {
                this.neighborChanged(this.getContainer().pos().func_177972_a(this.getLocation().facing));
            }
        }
    }

    @Override
    public int getSignalLevel() {
        return this.signalLevel;
    }

    @Override
    public int getRedstoneLevel() {
        return this.signalLevel >> 8;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing face) {
        if (capability == Capabilities.REDSTONE_RECEIVER) {
            return this.connects(face);
        }
        if (capability == Capabilities.REDSTONE_EMITTER) {
            return this.connects(face);
        }
        return super.hasCapability(capability, face);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing enumFacing) {
        if (capability == Capabilities.REDSTONE_RECEIVER) {
            return (T)Capabilities.REDSTONE_RECEIVER.cast((Object)this);
        }
        if (capability == Capabilities.REDSTONE_EMITTER) {
            return (T)Capabilities.REDSTONE_EMITTER.cast((Object)this);
        }
        return super.getCapability(capability, enumFacing);
    }

    public String getDisplayName() {
        return I18n.func_74838_a((String)("tile.simplelogic.wire" + (this.getLocation() == WireFace.CENTER ? ".freestanding.name" : ".name")));
    }

    @Deprecated
    public int getRedstoneSignal() {
        return !PROPAGATING ? this.getRedstoneLevel() : 0;
    }

    @Override
    public int getStrongPower(EnumFacing facing) {
        if (!PROPAGATING && this.getSignalFactory().type == WireType.NORMAL && facing != null && this.getLocation().facing == facing.func_176734_d()) {
            return this.getRedstoneLevel();
        }
        return 0;
    }

    public void onRedstoneInputChange() {
        this.scheduleLogicUpdate();
    }

    public void addDebugInformation(List<String> stringList, Side side) {
        if (side == Side.CLIENT && !PartWireSignalBase.DEBUG_CLIENT_WIRE_STATE) {
            return;
        }
        stringList.add(this.getLocation().name() + " R:" + (this.signalLevel >> 8) + " S:" + (this.signalLevel & 0xFF));
    }

    public boolean renderEquals(Wire other) {
        if (this.getWireType() != WireType.NORMAL) {
            return super.renderEquals(other);
        }
        return super.renderEquals(other) && ((PartWireSignalBase)other).getRedstoneLevel() == this.getRedstoneLevel();
    }

    public int renderHashCode() {
        if (this.getWireType() != WireType.NORMAL) {
            return super.renderHashCode();
        }
        return Objects.hash(super.renderHashCode(), this.getRedstoneLevel());
    }

    public ISignalMeterData getSignalMeterData(RayTraceResult result) {
        return new SignalMeterDataWire((byte)this.getRedstoneLevel(), this.getColor());
    }
}

