/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.wires;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import pl.asie.charset.ModCharset;
import pl.asie.charset.api.CharsetAPI;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.stagingapi.ISignalMeterData;
import pl.asie.charset.lib.utils.RegistryUtils;
import pl.asie.charset.lib.wires.BlockWire;
import pl.asie.charset.lib.wires.FastTESRWire;
import pl.asie.charset.lib.wires.FixCharsetWireItemSeparation;
import pl.asie.charset.lib.wires.IWireRenderContainer;
import pl.asie.charset.lib.wires.ItemWire;
import pl.asie.charset.lib.wires.RecipeWireConversion;
import pl.asie.charset.lib.wires.RendererWire;
import pl.asie.charset.lib.wires.SignalMeterDataBundledWire;
import pl.asie.charset.lib.wires.SignalMeterDataWire;
import pl.asie.charset.lib.wires.TileWire;
import pl.asie.charset.lib.wires.WireHighlightHandler;
import pl.asie.charset.lib.wires.WireManager;
import pl.asie.charset.lib.wires.WireProvider;
import pl.asie.charset.lib.wires.WireRenderHandlerDefault;

@CharsetModule(name="lib.wires", description="Wire support module", dependencies={"mod:mcmultipart"}, profile=ModuleProfile.STABLE)
public class CharsetLibWires {
    @CharsetModule.Instance
    public static CharsetLibWires instance;
    public static BlockWire blockWire;
    @SideOnly(value=Side.CLIENT)
    protected static RendererWire rendererWire;
    protected static Set<ResourceLocation> orderedWireLocations;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        blockWire = new BlockWire();
        WireManager.REGISTRY = (ForgeRegistry)new RegistryBuilder().setName(new ResourceLocation("charset:wire")).setIDRange(1, 255).setType(WireProvider.class).add((IForgeRegistry.AddCallback)new IForgeRegistry.AddCallback<WireProvider>(){

            public void onAdd(IForgeRegistryInternal<WireProvider> owner, RegistryManager stage, int id, WireProvider obj, @Nullable WireProvider oldObj) {
                orderedWireLocations.add(obj.getRegistryName());
                obj.generateBoxes();
            }
        }).create();
        ModCharset.dataFixes.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new FixCharsetWireItemSeparation());
    }

    public static Stream<WireProvider> getOrderedWireProviders() {
        return orderedWireLocations.stream().filter(r -> WireManager.REGISTRY.containsKey(r)).map(r -> (WireProvider)WireManager.REGISTRY.getValue(r));
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        for (Item i : ForgeRegistries.ITEMS) {
            if (!(i instanceof ItemWire)) continue;
            RegistryUtils.registerModel(i, 0, "charset:wire");
            RegistryUtils.registerModel(i, 1, "charset:wire");
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        RegistryUtils.register(event.getRegistry(), blockWire, "wire");
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        event.getRegistry().register(new RecipeWireConversion(false).setRegistryName("charset:wire_conversion_to"));
        event.getRegistry().register(new RecipeWireConversion(true).setRegistryName("charset:wire_conversion_from"));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        RegistryUtils.register(TileWire.class, "wire");
        RegistryUtils.register(TileWire.Tickable.class, "wire.tickable");
        CharsetAPI.INSTANCE.findSimpleInstantiatingRegistry(ISignalMeterData.class).register(SignalMeterDataWire.class, SignalMeterDataWire::new);
        CharsetAPI.INSTANCE.findSimpleInstantiatingRegistry(ISignalMeterData.class).register(SignalMeterDataBundledWire.class, SignalMeterDataBundledWire::new);
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        rendererWire = new RendererWire();
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
        ClientRegistry.bindTileEntitySpecialRenderer(TileWire.class, (TileEntitySpecialRenderer)new FastTESRWire());
        ClientRegistry.bindTileEntitySpecialRenderer(TileWire.Tickable.class, (TileEntitySpecialRenderer)new FastTESRWire());
        MinecraftForge.EVENT_BUS.register((Object)new WireHighlightHandler());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    @SideOnly(value=Side.CLIENT)
    public void onTextureStitchPre(TextureStitchEvent.Pre event) {
        for (WireProvider provider : WireManager.REGISTRY) {
            if (rendererWire.getContainer(provider) != null) continue;
            rendererWire.registerContainer(provider, new IWireRenderContainer.Simple(new WireRenderHandlerDefault(provider)));
        }
        rendererWire.reloadTextures(event.getMap());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPostBake(ModelBakeEvent event) {
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("charset:wire", "redstone=false,tickable=false"), (Object)rendererWire);
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("charset:wire", "redstone=true,tickable=false"), (Object)rendererWire);
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("charset:wire", "redstone=false,tickable=true"), (Object)rendererWire);
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("charset:wire", "redstone=true,tickable=true"), (Object)rendererWire);
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("charset:wire", "inventory"), (Object)rendererWire);
    }

    public void registerRenderer(WireProvider provider, IWireRenderContainer container) {
        rendererWire.registerContainer(provider, container);
    }

    static {
        orderedWireLocations = new LinkedHashSet<ResourceLocation>();
    }
}

