/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.capability.audio;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import pl.asie.charset.api.audio.AudioPacket;
import pl.asie.charset.api.audio.IAudioReceiver;

public class AudioReceiverCombiner
implements Function<List<IAudioReceiver>, IAudioReceiver> {
    @Override
    public IAudioReceiver apply(List<IAudioReceiver> iAudioReceivers) {
        return new WrappedReceiver(iAudioReceivers);
    }

    private class WrappedReceiver
    implements IAudioReceiver {
        private final Collection<IAudioReceiver> receivers;

        WrappedReceiver(Collection<IAudioReceiver> receivers) {
            this.receivers = receivers;
        }

        @Override
        public boolean receive(AudioPacket packet) {
            boolean received = false;
            for (IAudioReceiver receiver : this.receivers) {
                received |= receiver.receive(packet);
            }
            return received;
        }
    }
}

