/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.abstractbase.ClientEventBase;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.helper.ConnectionEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public abstract class ClientConnectionEndedEvent
extends ClientEventBase
implements ConnectionEvent {
    public static final int DEFAULT_RECONNECTION_DELAY_MILLIS = 5000;
    private final boolean canReconnect;
    @Nullable
    private final Throwable cause;
    private int reconnectionDelayMillis = 5000;
    private boolean attemptReconnect;

    protected ClientConnectionEndedEvent(@Nonnull Client client, boolean canReconnect, @Nullable Throwable cause) {
        super(client);
        this.canReconnect = canReconnect;
        this.attemptReconnect = canReconnect;
        this.cause = cause;
    }

    @Nonnull
    public Optional<Throwable> getCause() {
        return Optional.ofNullable(this.cause);
    }

    public int getReconnectionDelay() {
        return this.reconnectionDelayMillis;
    }

    public boolean canAttemptReconnect() {
        return this.canReconnect;
    }

    public boolean willAttemptReconnect() {
        return this.canReconnect && this.attemptReconnect;
    }

    public void setAttemptReconnect(boolean reconnecting) {
        this.attemptReconnect = reconnecting;
    }

    public void setReconnectionDelay(int millis) {
        Sanity.truthiness(millis > -1, "Delay cannot be negative");
        this.reconnectionDelayMillis = millis;
    }

    @Override
    @Nonnull
    protected ToStringer toStringer() {
        return super.toStringer().add("canAttemptReconnect", this.canReconnect).add("willAttemptReconnect", this.attemptReconnect).add("reconnectionDelay", this.reconnectionDelayMillis).add("cause", this.cause);
    }
}

