/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.gui;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import net.creeperhost.minetogether.CreeperHost;
import net.creeperhost.minetogether.api.Minigame;
import net.creeperhost.minetogether.aries.Aries;
import net.creeperhost.minetogether.chat.ChatHandler;
import net.creeperhost.minetogether.common.Config;
import net.creeperhost.minetogether.common.Pair;
import net.creeperhost.minetogether.common.WebUtils;
import net.creeperhost.minetogether.gui.GuiGDPR;
import net.creeperhost.minetogether.gui.element.GuiActiveFake;
import net.creeperhost.minetogether.gui.element.GuiTextFieldCompat;
import net.creeperhost.minetogether.gui.element.GuiTextFieldCompatCensor;
import net.creeperhost.minetogether.paul.Callbacks;
import net.creeperhost.minetogether.serverstuffs.CreeperHostServer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.GuiScrollingList;
import org.apache.commons.io.FileUtils;

public class GuiMinigames
extends GuiScreen {
    private static GuiMinigames current;
    private List<Minigame> minigames;
    private List<Minigame> vanillaMinigames;
    private GuiScrollingMinigames minigameScroll;
    private static HashMap<Integer, ResourceLocation> minigameTexturesCache;
    private static HashMap<Integer, Pair<Integer, Integer>> minigameTexturesSize;
    private GuiButton settingsButton;
    private GuiButton spinupButton;
    private static File credentialsFile;
    private static String key;
    private static String secret;
    private boolean credentialsValid = false;
    ExecutorService executor = Executors.newFixedThreadPool(3);
    private String loginFailureMessage = "";
    private static Settings settings;
    private float credit = -1.0f;
    private String creditType = "none";
    private float exchangeRate;
    private float quote = -1.0f;
    private String curPrefix = "";
    private String curSuffix = "";
    private boolean isModded = true;
    private GuiActiveFake moddedButton;
    private GuiActiveFake vanillaButton;
    private GuiScreen parent;
    private GuiButton cancelButton;
    Minigame lastMinigame = null;
    public boolean spinDown = false;
    private int ticks = 0;
    private ItemStack stack = new ItemStack(Items.field_151082_bd, 1);
    private boolean doSpindown = false;

    public GuiMinigames(GuiScreen parent) {
        this.parent = parent;
        current = this;
        State.pushState(State.CHECKING_CREDENTIALS);
        this.loadCredentials();
        this.refreshMinigames();
        this.isModded = true;
    }

    public GuiMinigames(GuiScreen parent, boolean spinDown) {
        this(parent);
        this.spinDown = spinDown;
    }

    private void refreshMinigames() {
        this.executor.submit(() -> {
            ArrayList<Minigame> minigameTemp = Callbacks.getMinigames(true);
            ArrayList<Minigame> tempVanilla = new ArrayList<Minigame>();
            ArrayList<Minigame> tempModded = new ArrayList<Minigame>();
            for (Minigame minigame : minigameTemp) {
                if (minigame.project == 0) {
                    tempVanilla.add(minigame);
                    continue;
                }
                tempModded.add(minigame);
            }
            this.minigames = tempModded;
            this.vanillaMinigames = tempVanilla;
        });
    }

    public void func_73876_c() {
        ++this.ticks;
        Minigame minigame = this.minigameScroll.getMinigame();
        if (this.lastMinigame != minigame) {
            if (minigame == null) {
                this.quote = -1.0f;
            } else {
                this.executor.submit(() -> {
                    try {
                        HashMap<String, String> sendMap = new HashMap<String, String>();
                        sendMap.put("id", String.valueOf(minigame.id));
                        sendMap.put("hash", Callbacks.getPlayerHash(CreeperHost.proxy.getUUID()));
                        sendMap.put("key2", key);
                        sendMap.put("secret2", secret);
                        Aries aries = new Aries(key, secret);
                        Map map = aries.doApiCall("minetogether", "minigamequote", sendMap);
                        this.quote = map.get("status").equals("success") ? Float.valueOf(String.valueOf(map.get("quote"))).floatValue() : -1.0f;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                });
            }
        }
        this.lastMinigame = minigame;
    }

    private void loadingSpin(float partialTicks) {
        int rotateTickMax = 30;
        int throbTickMax = 20;
        int rotateTicks = this.ticks % rotateTickMax;
        int throbTicks = this.ticks % throbTickMax;
        GlStateManager.func_179109_b((float)(this.field_146294_l / 2), (float)(this.field_146295_m / 2 + 20 + 10), (float)0.0f);
        GlStateManager.func_179094_E();
        float scale = 1.0f + (throbTicks >= throbTickMax / 2 ? (float)throbTickMax - ((float)throbTicks + partialTicks) : (float)throbTicks + partialTicks) * (2.0f / (float)throbTickMax);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)(((float)rotateTicks + partialTicks) * (360.0f / (float)rotateTickMax)), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        this.field_146296_j.func_180450_b(this.stack, -8, -8);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    public void func_73866_w_() {
        if (!CreeperHost.instance.gdpr.hasAcceptedGDPR()) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiGDPR(this.parent, () -> new GuiMinigames(this.parent)));
            return;
        }
        super.func_73866_w_();
        GuiScrollingMinigames tempMinigameScroll = new GuiScrollingMinigames(34);
        tempMinigameScroll.update(this.minigameScroll);
        this.minigameScroll = tempMinigameScroll;
        this.settingsButton = new GuiButton(808, this.field_146294_l - 10 - 100, 5, 100, 20, "Login");
        this.field_146292_n.add(this.settingsButton);
        this.spinupButton = new GuiButton(809, this.field_146294_l - 10 - 100, this.field_146295_m - 5 - 20, 100, 20, "Start minigame");
        this.field_146292_n.add(this.spinupButton);
        this.moddedButton = new GuiActiveFake(45067, 10, 30, this.field_146294_l / 2 - 5, 20, "Modded");
        this.field_146292_n.add(this.moddedButton);
        this.vanillaButton = new GuiActiveFake(721077, this.field_146294_l - 10 - (this.field_146294_l / 2 - 10), 30, this.field_146294_l / 2 - 5, 20, "Vanilla");
        this.field_146292_n.add(this.vanillaButton);
        this.cancelButton = new GuiButton(909, 10, this.field_146295_m - 5 - 20, 100, 20, "Cancel");
        this.field_146292_n.add(this.cancelButton);
        this.moddedButton.setActive(this.isModded);
        this.vanillaButton.setActive(!this.isModded);
        State.refreshState();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        if (Config.getInstance().isChatEnabled() && ChatHandler.connectionStatus != ChatHandler.ConnectionStatus.CONNECTED) {
            this.settingsButton.field_146124_l = false;
            this.settingsButton.field_146125_m = false;
            this.moddedButton.field_146124_l = false;
            this.moddedButton.field_146125_m = false;
            this.vanillaButton.field_146124_l = false;
            this.vanillaButton.field_146125_m = false;
            this.spinupButton.field_146124_l = false;
            this.spinupButton.field_146125_m = false;
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"minetogether.minigames.notavailable", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2, -1);
            super.func_73863_a(mouseX, mouseY, partialTicks);
            return;
        }
        if (!this.spinDown) {
            String creditStr;
            this.spinupButton.field_146124_l = this.minigameScroll != null && (State.getCurrentState() == State.CREDENTIALS_OK || State.getCurrentState() == State.CREDENTIALS_INVALID) && this.minigameScroll.getMinigame() != null && this.credit >= this.quote;
            this.minigameScroll.drawScreen(mouseX, mouseY, partialTicks);
            super.func_73863_a(mouseX, mouseY, partialTicks);
            switch (this.creditType) {
                case "credit": {
                    creditStr = (int)this.credit + " trial credit" + (this.credit == 1.0f ? "" : "s");
                    break;
                }
                default: {
                    creditStr = "Retrieving...";
                    break;
                }
                case "currency": {
                    String formattedCredit = new DecimalFormat("0.00##").format(this.credit);
                    creditStr = "CreeperHost credit: " + this.curPrefix + formattedCredit + this.curSuffix;
                }
            }
            this.func_73732_a(this.field_146289_q, "MineTogether Minigames", this.field_146294_l / 2, 5, -1);
            this.func_73731_b(this.field_146289_q, creditStr, 5, 5, -1);
            this.drawStatusString(this.field_146294_l / 2, this.field_146295_m - 40);
            String currencyFormat = String.valueOf((int)this.quote);
            if (this.quote > 0.0f) {
                double exchangedQuote = GuiMinigames.round(this.quote * this.exchangeRate, 2);
                String first = "";
                switch (this.creditType) {
                    case "credit": {
                        first = "Credit" + (this.quote > 1.0f ? "s" : "") + " needed: ";
                        break;
                    }
                    default: {
                        first = "";
                        break;
                    }
                    case "currency": {
                        first = "Estimated cost: ";
                        currencyFormat = new DecimalFormat("0.00##").format(exchangedQuote);
                    }
                }
                String formattedQuote = first + this.curPrefix + currencyFormat + this.curSuffix;
                this.func_73731_b(this.field_146289_q, formattedQuote, 5, this.field_146295_m - 40, -1);
                int stringLen = this.field_146289_q.func_78256_a(formattedQuote);
                if (!this.creditType.equals("credit") && !this.curPrefix.equals("\u00a3") && mouseX >= 5 && mouseX <= 5 + stringLen && mouseY >= this.field_146295_m - 40 && mouseY <= this.field_146295_m - 30) {
                    this.func_146283_a(Arrays.asList("Figure provided based on exchange rate of " + this.exchangeRate), mouseX, mouseY);
                } else if (this.spinupButton.func_146115_a() && this.credit < this.quote) {
                    this.func_146283_a(Arrays.asList("Cannot start minigame as you do not have enough credit"), mouseX, mouseY);
                }
            }
        } else {
            this.drawCenteredSplitString("Spinning down minigame", this.field_146294_l / 2, this.field_146295_m / 2, this.field_146294_l, -1);
            this.loadingSpin(partialTicks);
            if (this.doSpindown) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiMainMenu());
            }
        }
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    protected void drawTextureAt(int p_178012_1_, int p_178012_2_, int texturew, int textureh, int width, int height, ResourceLocation p_178012_3_) {
        this.field_146297_k.func_110434_K().func_110577_a(p_178012_3_);
        GlStateManager.func_179147_l();
        Gui.func_146110_a((int)p_178012_1_, (int)p_178012_2_, (float)0.0f, (float)0.0f, (int)width, (int)height, (float)texturew, (float)textureh);
        GlStateManager.func_179084_k();
    }

    public void func_146284_a(GuiButton button) {
        if (button == this.settingsButton) {
            settings = new Settings();
            Minecraft.func_71410_x().func_147108_a((GuiScreen)settings);
        } else if (button == this.spinupButton && (State.getCurrentState() == State.CREDENTIALS_OK || State.getCurrentState() == State.CREDENTIALS_INVALID) && this.minigameScroll.getMinigame() != null) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new StartMinigame(this.minigameScroll.getMinigame()));
        } else if (button == this.vanillaButton) {
            this.isModded = false;
            this.minigameScroll.clearSelected();
            this.vanillaButton.setActive(true);
            this.moddedButton.setActive(false);
        } else if (button == this.moddedButton) {
            this.isModded = true;
            this.minigameScroll.clearSelected();
            this.moddedButton.setActive(true);
            this.vanillaButton.setActive(false);
        } else if (button == this.cancelButton) {
            this.field_146297_k.func_147108_a(this.parent);
        }
    }

    private boolean areCredentialsValid() {
        Aries aries = new Aries(key, secret);
        Map resp = aries.doApiCall("os", "systemstate");
        return resp.containsKey("status") && resp.get("status").equals("success");
    }

    private Future<Boolean> checkCredentials() {
        return this.executor.submit(() -> {
            try {
                State.pushState(State.CHECKING_CREDENTIALS);
                this.credentialsValid = this.areCredentialsValid();
                try {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("key2", key);
                    map.put("secret2", secret);
                    map.put("hash", Callbacks.getPlayerHash(CreeperHost.proxy.getUUID()));
                    String resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/minigamecredit", new Gson().toJson(map), true, false);
                    Map creditResp = (Map)new Gson().fromJson(resp, Map.class);
                    this.credit = Float.parseFloat(String.valueOf(creditResp.get("credit")));
                    this.creditType = String.valueOf(creditResp.get("responsetype"));
                    if (this.creditType.equals("currency")) {
                        Map creditMap = (Map)creditResp.get("currency");
                        this.exchangeRate = Float.valueOf(String.valueOf(creditMap.get("exchange_rate"))).floatValue();
                        this.curPrefix = String.valueOf(creditMap.get("prefix"));
                        if (this.curPrefix.equals("null")) {
                            this.curPrefix = "";
                        }
                        this.curSuffix = String.valueOf(creditMap.get("suffix"));
                        if (this.curSuffix.equals("null")) {
                            this.curSuffix = "";
                        }
                    } else {
                        this.exchangeRate = 1.0f;
                        this.curPrefix = "";
                        this.curSuffix = "";
                    }
                    State.pushState(this.credentialsValid ? State.CREDENTIALS_OK : State.CREDENTIALS_INVALID);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.credentialsValid;
        });
    }

    private void loadCredentials() {
        if (credentialsFile.exists()) {
            try {
                String creds = FileUtils.readFileToString((File)credentialsFile);
                JsonParser parser = new JsonParser();
                JsonElement el = parser.parse(creds);
                if (el.isJsonObject()) {
                    JsonObject obj = el.getAsJsonObject();
                    key = obj.get("key").getAsString();
                    secret = obj.get("secret").getAsString();
                }
            }
            catch (IOException iOException) {}
        } else {
            credentialsFile.getParentFile().mkdirs();
            State.pushState(State.CREDENTIALS_INVALID);
        }
        this.checkCredentials();
    }

    private void saveCredentials() {
        credentialsFile.getParentFile().mkdirs();
        HashMap<String, String> creds = new HashMap<String, String>();
        creds.put("key", key);
        creds.put("secret", secret);
        try {
            FileUtils.writeStringToFile((File)credentialsFile, (String)new Gson().toJson(creds));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void drawStatusString(int x, int y) {
        int drawColour;
        String drawText;
        State state = State.getCurrentState();
        switch (state) {
            case LOGGING_IN: {
                drawText = "Logging in...";
                drawColour = -1;
                break;
            }
            case LOGIN_FAILURE: {
                drawText = this.loginFailureMessage;
                drawColour = -1;
                break;
            }
            case CREDENTIALS_OK: {
                drawText = "Credentials are stored and are valid";
                drawColour = -16711936;
                break;
            }
            case STARTING_MINIGAME: {
                drawText = "Starting Minigame. This may take up to 60 seconds!";
                drawColour = -1;
                break;
            }
            case MINIGAME_ACTIVE: {
                drawText = "Minigame active - adding to server list";
                drawColour = -16711936;
                break;
            }
            case MINIGAME_FAILED: {
                drawText = "Minigame launch failed.";
                drawColour = -65536;
                break;
            }
            case READY_TO_JOIN: {
                drawText = "Ready to join game - press button to join. You can invite people from the friends menu in the top right after joining!";
                drawColour = -1;
                break;
            }
            case CREDENTIALS_INVALID: {
                drawText = "No credentials found - trial mode";
                drawColour = -65536;
                break;
            }
            case TWOFACTOR_FAILURE: {
                drawText = this.loginFailureMessage;
                drawColour = -65536;
                break;
            }
            case TWOFACTOR_NEEDED: {
                drawText = this.loginFailureMessage;
                drawColour = -1;
                break;
            }
            default: {
                drawText = "Checking credentials...";
                drawColour = -1;
            }
        }
        this.drawCenteredSplitString(drawText, x, y, this.field_146294_l, drawColour);
    }

    private void doSpindown() {
        boolean[] started = new boolean[]{false};
        this.executor.submit(() -> {
            HashMap<String, String> sendMap = new HashMap<String, String>();
            Aries aries = new Aries(key, secret);
            sendMap.put("uuid", CreeperHost.instance.activeMinigame);
            sendMap.put("key2", key);
            sendMap.put("secret2", secret);
            CreeperHost.instance.activeMinigame = null;
            started[0] = true;
            Map map = aries.doApiCall("minetogether", "stopminigame", sendMap);
        });
        while (!started[0]) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.doSpindown = true;
    }

    private void drawCenteredSplitString(String drawText, int x, int y, int width, int drawColour) {
        List strings = this.field_146289_q.func_78271_c(drawText, width);
        for (String str : strings) {
            this.func_73732_a(this.field_146289_q, str, x, y, drawColour);
            y += this.field_146289_q.field_78288_b;
        }
    }

    static {
        minigameTexturesCache = new HashMap();
        minigameTexturesSize = new HashMap();
        credentialsFile = new File("config/minetogether/credentials.json");
        key = "";
        secret = "";
    }

    public static interface IStateHandler {
        public void handleStatePush(State var1);
    }

    public class StartMinigame
    extends GuiScreen
    implements IStateHandler {
        private final Minigame minigame;
        private String failedReason = "";
        private int port;
        private String ip;
        private GuiButton joinServerButton;

        public StartMinigame(Minigame minigame) {
            this.minigame = minigame;
            State.pushState(State.STARTING_MINIGAME);
            GuiMinigames.this.executor.submit(() -> {
                block9: {
                    try {
                        String url = minigame.template;
                        int ram = minigame.ram;
                        Aries aries = new Aries(key, secret);
                        Map creditResp = aries.doApiCall("minetogether", "minigamecredit");
                        if (creditResp.get("status").equals("success")) {
                            String credit = creditResp.get("credit").toString();
                            HashMap<String, String> sendMap = new HashMap<String, String>();
                            sendMap.put("id", String.valueOf(minigame.id));
                            sendMap.put("hash", Callbacks.getPlayerHash(CreeperHost.proxy.getUUID()));
                            sendMap.put("key2", key);
                            sendMap.put("secret2", secret);
                            Map map = aries.doApiCall("minetogether", "startminigame", sendMap);
                            if (map.get("status").equals("success")) {
                                try {
                                    State.pushState(State.MINIGAME_ACTIVE);
                                    this.ip = map.get("ip").toString();
                                    this.port = Double.valueOf(map.get("port").toString()).intValue();
                                    CreeperHostServer.serverOn = true;
                                    CreeperHostServer.startMinetogetherThread(map.get("ip").toString(), "Minigame: " + Minecraft.func_71410_x().func_110432_I().func_111285_a(), Config.getInstance().curseProjectID, this.port, CreeperHostServer.Discoverability.INVITE);
                                    while (true) {
                                        if (CreeperHostServer.isActive) {
                                            State.pushState(State.READY_TO_JOIN);
                                            CreeperHost.instance.curServerId = CreeperHostServer.updateID;
                                            CreeperHost.instance.activeMinigame = String.valueOf(map.get("uuid"));
                                            CreeperHost.instance.minigameID = minigame.id;
                                            CreeperHost.instance.trialMinigame = map.get("type").equals("trial");
                                            break block9;
                                        }
                                        if (CreeperHostServer.failed) {
                                            State.pushState(State.MINIGAME_FAILED);
                                            break block9;
                                        }
                                        Thread.sleep(1000L);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    break block9;
                                }
                            }
                            this.failedReason = (String)map.get("message");
                            State.pushState(State.MINIGAME_FAILED);
                            break block9;
                        }
                        State.pushState(State.UNKNOWN_ERROR);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }

        public void func_73876_c() {
            GuiMinigames.this.ticks++;
        }

        public void func_73866_w_() {
            super.func_73866_w_();
            this.joinServerButton = new GuiButton(800008, this.field_146294_l / 2 - 50, this.field_146295_m / 2 + 20, 100, 20, "Join server");
            this.field_146292_n.add(this.joinServerButton);
            this.joinServerButton.field_146124_l = false;
            this.joinServerButton.field_146125_m = false;
            State.refreshState();
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            this.func_146276_q_();
            if (State.getCurrentState() == State.MINIGAME_FAILED) {
                GuiMinigames.this.drawCenteredSplitString("Minigame failed. Reason: " + this.failedReason, this.field_146294_l / 2, this.field_146295_m / 2, this.field_146294_l, -65536);
            } else {
                GuiMinigames.this.drawStatusString(this.field_146294_l / 2, this.field_146295_m / 2);
            }
            super.func_73863_a(mouseX, mouseY, partialTicks);
            if (State.getCurrentState() != State.READY_TO_JOIN && State.getCurrentState() != State.MINIGAME_FAILED) {
                GuiMinigames.this.loadingSpin(partialTicks);
            }
        }

        @Override
        public void handleStatePush(State state) {
            if (state == State.READY_TO_JOIN) {
                this.joinServerButton.field_146124_l = true;
                this.joinServerButton.field_146125_m = true;
            } else if (state == State.MINIGAME_FAILED) {
                this.joinServerButton.field_146124_l = true;
                this.joinServerButton.field_146125_m = true;
                this.joinServerButton.field_146126_j = "Go back";
            }
        }

        protected void func_146284_a(GuiButton button) throws IOException {
            super.func_146284_a(button);
            if (button == this.joinServerButton) {
                if (State.getCurrentState() == State.READY_TO_JOIN) {
                    CreeperHost.instance.joinTime = System.currentTimeMillis();
                    FMLClientHandler.instance().connectToServerAtStartup(this.ip, this.port);
                } else {
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiMinigames(GuiMinigames.this.parent));
                }
            }
        }
    }

    public class Settings
    extends GuiScreen {
        public GuiTextFieldCompat emailField;
        public GuiLabel emailLabel;
        public GuiTextFieldCompat passwordField;
        public GuiLabel passwordLabel;
        public GuiTextFieldCompat oneCodeField;
        public GuiLabel oneCodeLabel;
        public GuiButton cancelButton;
        public GuiButton loginButton;
        private boolean previous2fa;

        public void func_73866_w_() {
            super.func_73866_w_();
            this.field_146293_o.clear();
            this.emailField = new GuiTextFieldCompat(80856, this.field_146289_q, this.field_146294_l / 2 - 100, this.field_146295_m / 2 - 20, 200, 20);
            this.emailLabel = new GuiLabel(this.field_146289_q, 80856, this.emailField.field_146209_f, this.emailField.field_146210_g - 10, 200, 20, -1);
            this.field_146293_o.add(this.emailLabel);
            this.emailLabel.func_175202_a("Email");
            this.oneCodeField = new GuiTextFieldCompat(808567, this.field_146289_q, this.field_146294_l / 2 - 100, this.emailField.field_146210_g - 10, 200, 20);
            this.oneCodeLabel = new GuiLabel(this.field_146289_q, 80856, this.oneCodeField.field_146209_f, this.oneCodeField.field_146210_g - 10, 200, 20, -1);
            this.field_146293_o.add(this.oneCodeLabel);
            this.oneCodeLabel.func_175202_a("One-time code");
            this.passwordField = new GuiTextFieldCompatCensor(80855, this.field_146289_q, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + 10, 200, 20);
            this.passwordLabel = new GuiLabel(this.field_146289_q, 80856, this.passwordField.field_146209_f, this.passwordField.field_146210_g - 10, 200, 20, -1);
            this.field_146293_o.add(this.passwordLabel);
            this.passwordLabel.func_175202_a("Password");
            this.cancelButton = new GuiButton(8085, this.field_146294_l - 10 - 100, this.field_146295_m - 5 - 20, 100, 20, "Go back");
            this.field_146292_n.add(this.cancelButton);
            this.loginButton = new GuiButton(8089, this.field_146294_l / 2 - 50, this.field_146295_m / 2 + 40, 100, 20, "Save");
            this.field_146292_n.add(this.loginButton);
            State.refreshState();
        }

        protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
            this.emailField.myMouseClicked(mouseX, mouseY, mouseButton);
            this.passwordField.myMouseClicked(mouseX, mouseY, mouseButton);
            this.oneCodeField.myMouseClicked(mouseX, mouseY, mouseButton);
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }

        protected void func_73869_a(char typedChar, int keyCode) throws IOException {
            if (keyCode == 15) {
                if (this.emailField.func_146206_l()) {
                    this.emailField.func_146195_b(false);
                    this.passwordField.func_146195_b(true);
                } else if (this.passwordField.func_146206_l()) {
                    this.passwordField.func_146195_b(false);
                    this.emailField.func_146195_b(true);
                }
            }
            this.emailField.func_146201_a(typedChar, keyCode);
            this.passwordField.func_146201_a(typedChar, keyCode);
            this.oneCodeField.func_146201_a(typedChar, keyCode);
            if (this.oneCodeField.func_146179_b().replaceAll("[^0-9]", "").length() == 6 && String.valueOf(typedChar).replaceAll("[^0-9]", "").equals("")) {
                this.func_146284_a(this.loginButton);
            }
            super.func_73869_a(typedChar, keyCode);
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            this.func_146276_q_();
            this.emailField.func_146194_f();
            this.passwordField.func_146194_f();
            this.oneCodeField.func_146194_f();
            super.func_73863_a(mouseX, mouseY, partialTicks);
            if (State.getCurrentState() == State.CREDENTIALS_OK) {
                GuiMinigames.this.drawCenteredSplitString("You have valid credentials. If you wish to change your credentials, please log in again.", this.field_146294_l / 2, this.field_146295_m / 2 - 30, this.field_146294_l, -1);
            } else {
                GuiMinigames.this.drawCenteredSplitString("If you would like to use your CreeperHost credit balance instead of the free minigame credits, please login with your CreeperHost username and password here.", this.field_146294_l / 2, this.field_146295_m / 2 - 60, this.field_146294_l, -1);
            }
            GuiMinigames.this.drawStatusString(this.field_146294_l / 2, this.field_146295_m - 40);
        }

        protected void func_146284_a(GuiButton button) throws IOException {
            if (button == this.cancelButton) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiMinigames.this);
            } else if (button == this.loginButton) {
                if (State.getCurrentState() == State.CREDENTIALS_OK) {
                    key = "";
                    secret = "";
                    GuiMinigames.this.saveCredentials();
                    GuiMinigames.this.checkCredentials();
                } else {
                    GuiMinigames.this.executor.submit(() -> {
                        block9: {
                            try {
                                HashMap<String, String> credentials = new HashMap<String, String>();
                                credentials.put("email", this.emailField.func_146179_b());
                                credentials.put("password", this.passwordField.func_146179_b());
                                credentials.put("oneCode", this.oneCodeField.func_146179_b().replaceAll("[^0-9]", ""));
                                State.pushState(State.LOGGING_IN);
                                String resp = WebUtils.postWebResponse("https://staging-panel.creeper.host/mt.php", credentials);
                                JsonParser parser = new JsonParser();
                                JsonElement el = parser.parse(resp);
                                if (!el.isJsonObject()) break block9;
                                JsonObject obj = el.getAsJsonObject();
                                if (obj.get("success").getAsBoolean()) {
                                    key = obj.get("key").getAsString();
                                    secret = obj.get("secret").getAsString();
                                    try {
                                        if (((Boolean)GuiMinigames.this.checkCredentials().get()).booleanValue()) {
                                            GuiMinigames.this.saveCredentials();
                                        }
                                    }
                                    catch (InterruptedException interruptedException) {
                                    }
                                    catch (ExecutionException executionException) {
                                        // empty catch block
                                    }
                                    this.emailField.func_146180_a("");
                                    this.passwordField.func_146180_a("");
                                    this.oneCodeField.func_146180_a("");
                                    break block9;
                                }
                                if (obj.has("_2fa") && !obj.get("_2fa").isJsonNull() && obj.get("_2fa").getAsBoolean()) {
                                    if (this.previous2fa) {
                                        GuiMinigames.this.loginFailureMessage = "Invalid code. Please try again or reset it by logging into the CreeperPanel";
                                        State.pushState(State.TWOFACTOR_FAILURE);
                                        return;
                                    }
                                    GuiMinigames.this.loginFailureMessage = "Please enter your two-factor code";
                                    State.pushState(State.TWOFACTOR_NEEDED);
                                    this.oneCodeField.func_146195_b(true);
                                    this.emailField.func_146195_b(false);
                                    this.passwordField.func_146195_b(false);
                                    this.previous2fa = true;
                                    this.oneCodeField.func_146180_a("");
                                    return;
                                }
                                String tempLoginFailure = obj.get("message").isJsonNull() ? "" : obj.get("message").getAsString();
                                GuiMinigames.this.loginFailureMessage = tempLoginFailure.isEmpty() ? "Login failed. Please ensure you have entered your username and password correctly." : tempLoginFailure;
                                State.pushState(State.LOGIN_FAILURE);
                                this.passwordField.func_146180_a("");
                                this.oneCodeField.func_146180_a("");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }
        }
    }

    private class GuiScrollingMinigames
    extends GuiScrollingList {
        public GuiScrollingMinigames(int entryHeight) {
            super(Minecraft.func_71410_x(), GuiMinigames.this.field_146294_l - 20, GuiMinigames.this.field_146295_m - 50, 50, GuiMinigames.this.field_146295_m - 50, 10, entryHeight, GuiMinigames.this.field_146294_l, GuiMinigames.this.field_146295_m);
        }

        protected int getSize() {
            List minigames = GuiMinigames.this.isModded ? GuiMinigames.this.minigames : GuiMinigames.this.vanillaMinigames;
            return minigames == null ? 1 : minigames.size();
        }

        protected void elementClicked(int index, boolean doubleClick) {
            this.selectedIndex = index;
        }

        protected boolean isSelected(int index) {
            return this.selectedIndex == index;
        }

        protected void drawBackground() {
        }

        protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
            List minigames;
            List list = minigames = GuiMinigames.this.isModded ? GuiMinigames.this.minigames : GuiMinigames.this.vanillaMinigames;
            if (minigames == null) {
                GuiMinigames.this.func_73732_a(GuiMinigames.this.field_146289_q, "Loading minigames...", GuiMinigames.this.field_146294_l / 2, slotTop, -1);
            } else {
                ResourceLocation resourceLocation;
                Minigame game = (Minigame)minigames.get(slotIdx);
                if (!minigameTexturesCache.containsKey(game.id)) {
                    resourceLocation = new ResourceLocation("minetogether", "minigame/" + game.id);
                    BufferedImage imageData = null;
                    try {
                        imageData = ImageIO.read(new URL(game.displayIcon));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (imageData != null) {
                        DynamicTexture texture = new DynamicTexture(imageData);
                        GuiMinigames.this.field_146297_k.func_110434_K().func_110579_a(resourceLocation, (ITextureObject)texture);
                        texture.func_110564_a();
                        minigameTexturesCache.put(game.id, resourceLocation);
                        minigameTexturesSize.put(game.id, new Pair<Integer, Integer>(imageData.getWidth(), imageData.getHeight()));
                    } else {
                        minigameTexturesCache.put(game.id, new ResourceLocation("minecraft", "textures/misc/unknown_server.png"));
                        minigameTexturesSize.put(game.id, new Pair<Integer, Integer>(32, 32));
                    }
                }
                resourceLocation = (ResourceLocation)minigameTexturesCache.get(game.id);
                Pair wh = (Pair)minigameTexturesSize.get(game.id);
                GuiMinigames.this.drawTextureAt(13, slotTop + 1, 28, 28, 28, 28, resourceLocation);
                GlStateManager.func_179094_E();
                float scale = 1.5f;
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                int x = GuiMinigames.this.field_146294_l / 2;
                int y = slotTop;
                x = (int)((float)x / scale);
                y = (int)((float)y / scale);
                int gameWidth = (int)((float)GuiMinigames.this.field_146289_q.func_78256_a(((Minigame)minigames.get((int)slotIdx)).displayName) * scale);
                int newX = GuiMinigames.this.field_146294_l / 2 + gameWidth / 2;
                GuiMinigames.this.func_73732_a(GuiMinigames.this.field_146289_q, ((Minigame)minigames.get((int)slotIdx)).displayName, x, y, -1);
                GlStateManager.func_179121_F();
                GuiMinigames.this.func_73731_b(GuiMinigames.this.field_146289_q, " by " + ((Minigame)minigames.get((int)slotIdx)).author, newX, slotTop + 2, -5592406);
                String displayDescription = ((Minigame)minigames.get((int)slotIdx)).displayDescription;
                if (GuiMinigames.this.field_146289_q.func_78256_a(displayDescription) > (GuiMinigames.this.field_146294_l - 96) * 2) {
                    while (GuiMinigames.this.field_146289_q.func_78256_a(displayDescription + "...") > (GuiMinigames.this.field_146294_l - 96) * 2) {
                        displayDescription = displayDescription.substring(0, displayDescription.lastIndexOf(" "));
                    }
                    displayDescription = displayDescription + "...";
                }
                GuiMinigames.this.drawCenteredSplitString(displayDescription, GuiMinigames.this.field_146294_l / 2, slotTop + 12, GuiMinigames.this.field_146294_l - 84, -5592406);
            }
        }

        public Minigame getMinigame() {
            List minigames = GuiMinigames.this.isModded ? GuiMinigames.this.minigames : GuiMinigames.this.vanillaMinigames;
            return this.selectedIndex >= 0 ? (Minigame)minigames.get(this.selectedIndex) : null;
        }

        public void clearSelected() {
            this.selectedIndex = -1;
        }

        private int getSelected() {
            return this.selectedIndex;
        }

        public void update(GuiScrollingMinigames previous) {
            if (previous == null) {
                return;
            }
            this.selectedIndex = previous.getSelected();
        }
    }

    private static enum State {
        LOGGING_IN,
        CHECKING_CREDENTIALS,
        CREDENTIALS_OK,
        CREDENTIALS_INVALID,
        LOGIN_FAILURE,
        TWOFACTOR_NEEDED,
        STARTING_MINIGAME,
        LOGIN_SUCCESS,
        TWOFACTOR_FAILURE,
        MINIGAME_ACTIVE,
        MINIGAME_FAILED,
        NOT_ENOUGH_CREDIT,
        UNKNOWN_ERROR,
        READY_TO_JOIN;

        private static State currentState;

        public static void pushState(State state) {
            if (current.settingsButton == null) {
                return;
            }
            ((GuiMinigames)current).settingsButton.field_146124_l = true;
            switch (state) {
                case LOGGING_IN: {
                    if (settings == null) break;
                    settings.emailField.func_146184_c(false);
                    settings.passwordField.func_146184_c(false);
                    settings.oneCodeField.func_146184_c(false);
                    settings.loginButton.field_146124_l = false;
                    break;
                }
                case CREDENTIALS_OK: {
                    if (settings != null) {
                        settings.emailField.func_146189_e(false);
                        settings.passwordField.func_146189_e(false);
                        settings.oneCodeField.func_146189_e(false);
                        settings.emailField.func_146184_c(false);
                        settings.passwordField.func_146184_c(false);
                        settings.oneCodeField.func_146184_c(false);
                        settings.emailLabel.field_146172_j = false;
                        settings.passwordLabel.field_146172_j = false;
                        settings.oneCodeLabel.field_146172_j = false;
                        settings.loginButton.field_146126_j = "Log in again";
                        settings.loginButton.field_146124_l = true;
                        settings.loginButton.field_146125_m = true;
                    }
                    if (!current.spinDown) break;
                    current.doSpindown();
                    break;
                }
                case CHECKING_CREDENTIALS: {
                    ((GuiMinigames)current).settingsButton.field_146124_l = false;
                    break;
                }
                case LOGIN_FAILURE: 
                case CREDENTIALS_INVALID: {
                    if (settings == null) break;
                    settings.emailField.func_146184_c(true);
                    settings.passwordField.func_146184_c(true);
                    settings.oneCodeField.func_146184_c(false);
                    settings.emailField.func_146189_e(true);
                    settings.passwordField.func_146189_e(true);
                    settings.oneCodeField.func_146189_e(false);
                    settings.emailLabel.field_146172_j = true;
                    settings.passwordLabel.field_146172_j = true;
                    settings.oneCodeLabel.field_146172_j = false;
                    settings.loginButton.field_146126_j = "Log in";
                    settings.loginButton.field_146124_l = true;
                    settings.loginButton.field_146125_m = true;
                    break;
                }
                case TWOFACTOR_NEEDED: {
                    if (settings == null) break;
                    settings.emailField.func_146189_e(false);
                    settings.passwordField.func_146189_e(false);
                    settings.emailField.func_146184_c(false);
                    settings.passwordField.func_146184_c(false);
                    settings.oneCodeField.func_146189_e(true);
                    settings.oneCodeField.func_146184_c(true);
                    settings.emailLabel.field_146172_j = false;
                    settings.passwordLabel.field_146172_j = false;
                    settings.oneCodeLabel.field_146172_j = true;
                    break;
                }
                case TWOFACTOR_FAILURE: {
                    if (settings == null) break;
                    settings.oneCodeField.func_146184_c(true);
                    settings.oneCodeField.func_146189_e(true);
                    settings.oneCodeLabel.field_146172_j = true;
                }
            }
            currentState = state;
            ((GuiMinigames)current).settingsButton.field_146126_j = state == CREDENTIALS_OK ? "Logged in" : "Log in";
            GuiScreen curScreen = Minecraft.func_71410_x().field_71462_r;
            if (curScreen instanceof IStateHandler) {
                ((IStateHandler)curScreen).handleStatePush(state);
            }
        }

        public static State getCurrentState() {
            return currentState;
        }

        public static void refreshState() {
            State.pushState(currentState);
        }

        static {
            currentState = CHECKING_CREDENTIALS;
        }
    }
}

