/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.gui;

import java.io.IOException;
import net.creeperhost.minetogether.Util;
import net.creeperhost.minetogether.api.AvailableResult;
import net.creeperhost.minetogether.api.Order;
import net.creeperhost.minetogether.common.Config;
import net.creeperhost.minetogether.gui.GuiGetServer;
import net.creeperhost.minetogether.gui.element.GuiTextFieldCompat;
import net.creeperhost.minetogether.gui.element.GuiTextFieldValidate;
import net.creeperhost.minetogether.paul.Callbacks;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiSlider;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiCheckBox;

public class GuiGeneralServerInfo
extends GuiGetServer
implements GuiPageButtonList.GuiResponder {
    private static final GuiSlider.FormatHelper SLIDER_FORMATTER = new GuiSlider.FormatHelper(){

        public String func_175318_a(int id, String name, float value) {
            return name + ": " + (int)value;
        }
    };
    private static ResourceLocation lockIcon;
    private GuiTextFieldCompat nameField;
    private GuiSlider slotSlider;
    private long lastKeyTyped;
    private String acceptString = new String(Character.toChars(10004));
    private String denyString = new String(Character.toChars(10006));
    private boolean isAcceptable = false;
    private boolean nameChecked = false;
    private String message = "Name can not be blank";
    private GuiCheckBox pregen;

    public GuiGeneralServerInfo(int stepId, Order order) {
        super(stepId, order);
        lockIcon = new ResourceLocation("creeperhost", "textures/lock.png");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int halfWidth = this.field_146294_l / 2;
        int halfHeight = this.field_146295_m / 2;
        this.nameField = new GuiTextFieldValidate(0, this.field_146289_q, halfWidth - 100, halfHeight - 50, 200, 20, "([A-Za-z0-9]*)");
        this.nameField.func_146203_f(16);
        this.nameField.func_146180_a(this.order.name.isEmpty() ? Util.getDefaultName() : this.order.name);
        this.order.name = this.nameField.func_146179_b().trim();
        String checkboxString = Util.localize("info.pregen", new Object[0]);
        int checkboxWidth = this.field_146289_q.func_78256_a(checkboxString) + 11 + 2;
        this.pregen = new GuiCheckBox(3, halfWidth - checkboxWidth / 2, halfHeight - 8, checkboxString, this.order.pregen);
        if (Config.getInstance().getPregenDiameter() > 0) {
            this.field_146292_n.add(this.pregen);
        }
        this.slotSlider = new GuiSlider((GuiPageButtonList.GuiResponder)this, 1, halfWidth - 100, halfHeight + 15, Util.localize("slider.player_count", new Object[0]), 1.0f, 20.0f, (float)this.order.playerAmount, SLIDER_FORMATTER);
        this.slotSlider.field_146120_f = 200;
        this.field_146292_n.add(this.slotSlider);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.nameField.func_146178_a();
        final String nameToCheck = this.nameField.func_146179_b().trim();
        boolean isEmpty = nameToCheck.isEmpty();
        if (this.lastKeyTyped + 400L < System.currentTimeMillis() && !this.nameChecked) {
            this.nameChecked = true;
            if (isEmpty) {
                this.message = "Name cannot be blank";
                this.isAcceptable = false;
            } else {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        AvailableResult result = Callbacks.getNameAvailable(nameToCheck);
                        GuiGeneralServerInfo.this.isAcceptable = result.getSuccess();
                        GuiGeneralServerInfo.this.message = result.getMessage();
                    }
                };
                Thread thread = new Thread(task);
                thread.start();
            }
        }
        this.buttonNext.field_146124_l = !isEmpty && this.nameChecked && this.isAcceptable;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        String nameFieldOldValue = this.nameField.func_146179_b();
        if (!this.nameField.func_146201_a(typedChar, keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        } else if (!nameFieldOldValue.equals(this.nameField.func_146179_b())) {
            this.nameChecked = false;
            this.message = "Name not yet checked";
            this.order.name = this.nameField.func_146179_b().trim();
            this.lastKeyTyped = System.currentTimeMillis();
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, Util.localize("info.server_name", new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 65, -1);
        int colour = this.nameChecked && this.isAcceptable ? 65280 : 0xFF0000;
        this.field_146297_k.func_110434_K().func_110577_a(lockIcon);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Gui.func_146110_a((int)(this.field_146294_l / 2 - 8), (int)(this.field_146295_m / 2 + 40), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        int strStart = 61;
        this.func_73732_a(this.field_146289_q, Util.localize("secure.line1", new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 + strStart, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, Util.localize("secure.line2", new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 + strStart + 10, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, Util.localize("secure.line3", new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 + strStart + 20, 0xFFFFFF);
        this.nameField.func_146194_f();
        this.func_73732_a(this.field_146289_q, this.message, this.field_146294_l / 2, this.field_146295_m / 2 - 26, colour);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.nameField.myMouseClicked(mouseX, mouseY, mouseButton);
        this.order.pregen = this.pregen.isChecked();
    }

    @Override
    public String getStepName() {
        return Util.localize("gui.general_info", new Object[0]);
    }

    public void func_175321_a(int id, boolean value) {
    }

    public void func_175320_a(int id, float value) {
        this.order.playerAmount = (int)value;
    }

    public void func_175319_a(int id, String value) {
    }
}

