/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import cpw.mods.inventorysorter.ContainerContext;
import cpw.mods.inventorysorter.InventorySorter;
import cpw.mods.inventorysorter.Network;
import cpw.mods.inventorysorter.ScrollWheelHandler;
import cpw.mods.inventorysorter.SortingHandler;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.inventory.Slot;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;

public enum Action {
    SORT(SortingHandler.INSTANCE, "key.inventorysorter.sort", -98, "middleClickSorting", "Middle-click sorting module", true, InventorySorter.INSTANCE::sortingModConflicts),
    ONEITEMIN(ScrollWheelHandler.ONEITEMIN, "key.inventorysorter.itemin", -200, "mouseWheelMoving", "Mouse wheel movement module", true, InventorySorter.INSTANCE::wheelModConflicts),
    ONEITEMOUT(ScrollWheelHandler.ONEITEMOUT, "key.inventorysorter.itemout", -201, "mouseWheelMoving", "Mouse wheel movement module", true, InventorySorter.INSTANCE::wheelModConflicts);

    private final Consumer<ContainerContext> worker;
    private final String keyBindingName;
    private final int defaultKeyCode;
    private final String configName;
    private boolean actionActive;
    private Property property;
    private final String comment;
    private final boolean implemented;
    private final Supplier<Boolean> checkForConflicts;

    private Action(Consumer<ContainerContext> worker, String keyBindingName, int defaultKeyCode, String configName, String comment, boolean implemented, Supplier<Boolean> checkForConflicts) {
        this.worker = worker;
        this.keyBindingName = keyBindingName;
        this.defaultKeyCode = defaultKeyCode;
        this.configName = configName;
        this.comment = comment;
        this.implemented = implemented;
        this.checkForConflicts = checkForConflicts;
    }

    public String getKeyBindingName() {
        return this.keyBindingName;
    }

    public static void configure(Configuration config) {
        for (Action a : Action.values()) {
            boolean shouldBeActive = true;
            if (!config.hasKey("client", a.configName)) {
                shouldBeActive = a.checkForConflicts.get() == false;
            }
            a.property = config.get("client", a.configName, shouldBeActive);
            a.property.setRequiresMcRestart(false);
            a.property.setRequiresWorldRestart(false);
            a.property.setLanguageKey("inventorysorter.gui." + a.configName);
            a.property.setShowInGui(a.implemented);
            a.property.setComment(a.comment);
            a.actionActive = a.property.getBoolean(shouldBeActive);
            if (shouldBeActive) continue;
            InventorySorter.INSTANCE.log.log(Level.INFO, "Module {} disabled due to potential mod conflict, enable manually in configuration screen", (Object)a.name());
        }
    }

    public Network.ActionMessage message(Slot slot) {
        return new Network.ActionMessage(this, slot.field_75222_d);
    }

    public void execute(ContainerContext context) {
        this.worker.accept(context);
    }

    public Property getProperty() {
        return this.property;
    }

    public boolean isActive() {
        return this.actionActive;
    }

    public String getConfigName() {
        return this.configName;
    }

    public int getDefaultKeyCode() {
        return this.defaultKeyCode;
    }
}

