/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.tesslocator.block;

import com.latmod.mods.tesslocator.block.TileTesslocator;
import com.latmod.mods.tesslocator.block.part.AdvancedTesslocatorPart;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTesslocator
extends Block {
    @GameRegistry.ObjectHolder(value="tesslocator:tesslocator")
    public static BlockTesslocator INSTANCE;
    public static final PropertyInteger CON_D;
    public static final PropertyInteger CON_U;
    public static final PropertyInteger CON_N;
    public static final PropertyInteger CON_S;
    public static final PropertyInteger CON_W;
    public static final PropertyInteger CON_E;
    public static final PropertyInteger[] CON;
    public static final AxisAlignedBB[] BOXES;

    public BlockTesslocator() {
        super(Material.field_151573_f, MapColor.field_151679_y);
        this.func_149711_c(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)CON_D, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)CON_U, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)CON_N, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)CON_S, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)CON_W, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)CON_E, (Comparable)Integer.valueOf(0)));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileTesslocator();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, (IProperty[])CON);
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nullable
    @Deprecated
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    private boolean hasParts(TileTesslocator tesslocator) {
        for (int i = 0; i < 6; ++i) {
            if (tesslocator.parts[i] == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    @Deprecated
    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof TileTesslocator)) {
            return super.func_180636_a(state, world, pos, start, end);
        }
        TileTesslocator tile = (TileTesslocator)tileEntity;
        if (!this.hasParts(tile)) {
            return super.func_180636_a(state, world, pos, start, end);
        }
        Vec3d start1 = start.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        Vec3d end1 = end.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        RayTraceResult ray1 = null;
        double dist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < BOXES.length; ++i) {
            double dist1;
            RayTraceResult ray;
            if (tile.parts[i] == null || (ray = BOXES[i].func_72327_a(start1, end1)) == null || !(dist >= (dist1 = ray.field_72307_f.func_72436_e(start1)))) continue;
            dist = dist1;
            ray1 = ray;
            ray1.subHit = i;
        }
        if (ray1 != null) {
            RayTraceResult ray2 = new RayTraceResult(ray1.field_72307_f.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), ray1.field_178784_b, pos);
            ray2.subHit = ray1.subHit;
            return ray2;
        }
        return null;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        RayTraceResult ray = Minecraft.func_71410_x().field_71476_x;
        if (ray != null && ray.subHit >= 0 && ray.subHit < BOXES.length) {
            return BOXES[ray.subHit].func_186670_a(pos);
        }
        return super.func_180640_a(state, worldIn, pos);
    }

    @Deprecated
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileTesslocator) {
            for (int i = 0; i < 6; ++i) {
                if (((TileTesslocator)tileEntity).parts[i] == null) continue;
                state = state.func_177226_a((IProperty)CON[i], (Comparable)Integer.valueOf(((TileTesslocator)tileEntity).parts[i] instanceof AdvancedTesslocatorPart ? 2 : 1));
            }
        }
        return state;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumFacing side;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof TileTesslocator)) {
            return true;
        }
        double dist = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        Vec3d start = player.func_174824_e(1.0f);
        Vec3d look = player.func_70040_Z();
        Vec3d end = start.func_72441_c(look.field_72450_a * dist, look.field_72448_b * dist, look.field_72449_c * dist);
        RayTraceResult ray = this.func_180636_a(state, world, pos, start, end);
        EnumFacing enumFacing = side = ray != null && ray.subHit >= 0 && ray.subHit < 6 ? EnumFacing.func_82600_a((int)ray.subHit) : null;
        if (side != null && ((TileTesslocator)tileEntity).parts[side.func_176745_a()] != null) {
            ((TileTesslocator)tileEntity).parts[side.func_176745_a()].onRightClick(player, hand);
            return true;
        }
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult ray, World world, BlockPos pos, EntityPlayer player) {
        TileEntity tileEntity;
        EnumFacing side;
        EnumFacing enumFacing = side = ray != null && ray.subHit >= 0 && ray.subHit < 6 ? EnumFacing.func_82600_a((int)ray.subHit) : null;
        if (side != null && (tileEntity = world.func_175625_s(pos)) instanceof TileTesslocator) {
            TileTesslocator tile = (TileTesslocator)tileEntity;
            if (tile.parts[side.func_176745_a()] != null) {
                ItemStack stack = new ItemStack(tile.parts[side.func_176745_a()].getType().item.get());
                if (tile.parts[side.func_176745_a()].getType().isAdvanced) {
                    stack.func_77983_a("colors", (NBTBase)new NBTTagByte((byte)((AdvancedTesslocatorPart)tile.parts[side.func_176745_a()]).colors));
                }
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileTesslocator) {
            EnumFacing side;
            TileTesslocator tile = (TileTesslocator)tileEntity;
            double dist = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
            Vec3d start = player.func_174824_e(1.0f);
            Vec3d look = player.func_70040_Z();
            Vec3d end = start.func_72441_c(look.field_72450_a * dist, look.field_72448_b * dist, look.field_72449_c * dist);
            RayTraceResult ray = this.func_180636_a(state, world, pos, start, end);
            EnumFacing enumFacing = side = ray != null && ray.subHit >= 0 && ray.subHit < 6 ? EnumFacing.func_82600_a((int)ray.subHit) : null;
            if (side != null) {
                if (!player.field_71075_bZ.field_75098_d) {
                    tile.parts[side.func_176745_a()].drop(world, pos);
                }
                tile.parts[side.func_176745_a()] = null;
                if (this.hasParts(tile)) {
                    world.func_184138_a(pos, state, state, 11);
                } else {
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
                    return true;
                }
            }
        }
        return false;
    }

    static {
        CON_D = PropertyInteger.func_177719_a((String)"d", (int)0, (int)2);
        CON_U = PropertyInteger.func_177719_a((String)"u", (int)0, (int)2);
        CON_N = PropertyInteger.func_177719_a((String)"n", (int)0, (int)2);
        CON_S = PropertyInteger.func_177719_a((String)"s", (int)0, (int)2);
        CON_W = PropertyInteger.func_177719_a((String)"w", (int)0, (int)2);
        CON_E = PropertyInteger.func_177719_a((String)"e", (int)0, (int)2);
        CON = new PropertyInteger[]{CON_D, CON_U, CON_N, CON_S, CON_W, CON_E};
        BOXES = new AxisAlignedBB[6];
        double h0 = 0.0625;
        double h1 = 1.0 - h0;
        double v0 = 0.125;
        double v1 = 1.0 - v0;
        BlockTesslocator.BOXES[0] = new AxisAlignedBB(h0, 0.0, h0, h1, v0, h1);
        BlockTesslocator.BOXES[1] = new AxisAlignedBB(h0, v1, h0, h1, 1.0, h1);
        BlockTesslocator.BOXES[2] = new AxisAlignedBB(h0, h0, 0.0, h1, h1, v0);
        BlockTesslocator.BOXES[3] = new AxisAlignedBB(h0, h0, v1, h1, h1, 1.0);
        BlockTesslocator.BOXES[4] = new AxisAlignedBB(0.0, h0, h0, v0, h1, h1);
        BlockTesslocator.BOXES[5] = new AxisAlignedBB(v1, h0, h0, 1.0, h1, h1);
    }
}

