/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates.logic;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import pl.asie.simplelogic.gates.logic.GateConnection;
import pl.asie.simplelogic.gates.logic.GateLogic;
import pl.asie.simplelogic.gates.logic.GateRenderState;
import pl.asie.simplelogic.gates.logic.IGateContainer;

public class GateLogicSynchronizer
extends GateLogic {
    private byte pulseLeft;
    private byte pulseRight;

    @Override
    public boolean canBlockSide(EnumFacing side) {
        return side == EnumFacing.SOUTH;
    }

    @Override
    public boolean canInvertSide(EnumFacing side) {
        return side == EnumFacing.NORTH;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag, boolean isClient) {
        tag = super.writeToNBT(tag, isClient);
        tag.func_74774_a("pll", this.pulseLeft);
        tag.func_74774_a("plr", this.pulseRight);
        return tag;
    }

    @Override
    public boolean readFromNBT(NBTTagCompound tag, boolean isClient) {
        byte oldPll = this.pulseLeft;
        byte oldPlr = this.pulseRight;
        this.pulseLeft = tag.func_74771_c("pll");
        this.pulseRight = tag.func_74771_c("plr");
        return super.readFromNBT(tag, isClient) || oldPll != this.pulseLeft || oldPlr != this.pulseRight;
    }

    @Override
    public void onChanged(IGateContainer gate) {
        if (this.getInputValueInside(EnumFacing.SOUTH) > 0) {
            this.pulseRight = 0;
            this.pulseLeft = 0;
        } else {
            byte newPulseLeft = this.getInputValueInside(EnumFacing.WEST);
            byte newPulseRight = this.getInputValueInside(EnumFacing.EAST);
            if (newPulseLeft > this.pulseLeft) {
                this.pulseLeft = newPulseLeft;
            }
            if (newPulseRight > this.pulseRight) {
                this.pulseRight = newPulseRight;
            }
        }
        if (this.updateOutputs(gate)) {
            if (this.pulseRight > 0 && this.pulseLeft > 0) {
                gate.scheduleRedstoneTick();
            }
            gate.markGateChanged(true);
        } else {
            gate.markGateChanged(false);
        }
    }

    @Override
    public boolean tick(IGateContainer gate) {
        if (this.pulseLeft != 0 && this.pulseRight != 0) {
            this.pulseRight = 0;
            this.pulseLeft = 0;
            return true;
        }
        return false;
    }

    @Override
    public GateConnection getType(EnumFacing dir) {
        if (dir == EnumFacing.NORTH) {
            return GateConnection.OUTPUT;
        }
        if (dir == EnumFacing.SOUTH) {
            return GateConnection.INPUT;
        }
        return GateConnection.INPUT_ANALOG;
    }

    @Override
    public GateRenderState getLayerState(int id) {
        switch (id) {
            case 0: {
                return GateRenderState.inputOrDisabled(this, EnumFacing.SOUTH, this.getInputValueInside(EnumFacing.SOUTH));
            }
            case 1: {
                return GateRenderState.input(this.getInputValueInside(EnumFacing.WEST));
            }
            case 2: {
                return GateRenderState.input(this.getInputValueInside(EnumFacing.EAST));
            }
            case 3: {
                return GateRenderState.input(this.pulseLeft);
            }
            case 4: {
                return GateRenderState.input(this.pulseRight);
            }
            case 5: {
                return GateRenderState.input(this.getOutputValueInside(EnumFacing.NORTH));
            }
        }
        return GateRenderState.OFF;
    }

    @Override
    public GateRenderState getTorchState(int id) {
        switch (id) {
            case 0: {
                return GateRenderState.input(this.pulseLeft);
            }
            case 1: {
                return GateRenderState.input(this.pulseRight);
            }
            case 2: {
                return GateRenderState.input(this.getOutputValueInside(EnumFacing.NORTH));
            }
        }
        return GateRenderState.ON;
    }

    @Override
    protected byte calculateOutputInside(EnumFacing side) {
        return this.pulseLeft > 0 && this.pulseRight > 0 ? (byte)Math.max(this.pulseRight, this.pulseLeft) : (byte)0;
    }
}

