/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates.logic;

import java.util.Random;
import net.minecraft.util.EnumFacing;
import pl.asie.simplelogic.gates.logic.GateConnection;
import pl.asie.simplelogic.gates.logic.GateLogic;
import pl.asie.simplelogic.gates.logic.GateRenderState;
import pl.asie.simplelogic.gates.logic.IGateContainer;

public class GateLogicRandomizer
extends GateLogic {
    private static final Random rand = new Random();

    @Override
    public boolean updateOutputs(IGateContainer gate) {
        byte newInput = this.getInputValueInside(EnumFacing.SOUTH);
        if (newInput == 0) {
            return false;
        }
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (facing == EnumFacing.SOUTH) continue;
            int r = newInput <= 8 ? rand.nextInt(16) : (rand.nextBoolean() ? 15 : 0);
            this.outputValues[facing.ordinal() - 2] = (byte)r;
        }
        return true;
    }

    @Override
    public boolean canBlockSide(EnumFacing side) {
        return side != EnumFacing.SOUTH;
    }

    @Override
    public boolean canInvertSide(EnumFacing side) {
        return true;
    }

    @Override
    public GateConnection getType(EnumFacing dir) {
        return dir == EnumFacing.SOUTH ? GateConnection.INPUT_ANALOG : GateConnection.OUTPUT_ANALOG;
    }

    @Override
    public GateRenderState getLayerState(int id) {
        switch (id) {
            case 0: {
                return GateRenderState.input(this.getInputValueInside(EnumFacing.SOUTH));
            }
            case 1: {
                return GateRenderState.inputOrDisabled(this, EnumFacing.WEST, this.getOutputValueInside(EnumFacing.WEST));
            }
            case 2: {
                return GateRenderState.inputOrDisabled(this, EnumFacing.NORTH, this.getOutputValueInside(EnumFacing.NORTH));
            }
            case 3: {
                return GateRenderState.inputOrDisabled(this, EnumFacing.EAST, this.getOutputValueInside(EnumFacing.EAST));
            }
        }
        return null;
    }

    @Override
    public GateRenderState getTorchState(int id) {
        switch (id) {
            case 0: {
                return GateRenderState.input(this.getOutputValueInside(EnumFacing.WEST));
            }
            case 1: {
                return GateRenderState.input(this.getOutputValueInside(EnumFacing.NORTH));
            }
            case 2: {
                return GateRenderState.input(this.getOutputValueInside(EnumFacing.EAST));
            }
        }
        return null;
    }

    @Override
    public byte calculateOutputInside(EnumFacing facing) {
        return 0;
    }
}

