/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates.logic;

import net.minecraft.util.EnumFacing;
import pl.asie.simplelogic.gates.logic.GateConnection;
import pl.asie.simplelogic.gates.logic.GateLogic;
import pl.asie.simplelogic.gates.logic.GateRenderState;

public class GateLogicMultiplexer
extends GateLogic {
    @Override
    public boolean canBlockSide(EnumFacing side) {
        return false;
    }

    @Override
    public GateRenderState getLayerState(int id) {
        boolean isWest = this.getInputValueInside(EnumFacing.SOUTH) != 0;
        boolean westOn = this.getInputValueInside(EnumFacing.WEST) != 0;
        boolean eastOn = this.getInputValueInside(EnumFacing.EAST) != 0;
        switch (id) {
            case 0: {
                return GateRenderState.input(this.getInputValueInside(EnumFacing.SOUTH));
            }
            case 1: {
                return GateRenderState.input(this.getInputValueInside(EnumFacing.WEST));
            }
            case 2: {
                return GateRenderState.input(this.getInputValueInside(EnumFacing.EAST));
            }
            case 3: {
                return GateRenderState.bool(isWest && !westOn);
            }
            case 4: {
                return GateRenderState.bool(!isWest && !eastOn);
            }
            case 5: {
                return GateRenderState.input(this.getInputValueInside(EnumFacing.SOUTH)).invert();
            }
        }
        return GateRenderState.OFF;
    }

    @Override
    public GateRenderState getTorchState(int id) {
        boolean isWest = this.getInputValueInside(EnumFacing.SOUTH) != 0;
        boolean westOn = this.getInputValueInside(EnumFacing.WEST) != 0;
        boolean eastOn = this.getInputValueInside(EnumFacing.EAST) != 0;
        switch (id) {
            case 0: {
                return GateRenderState.input(this.getInputValueInside(EnumFacing.SOUTH)).invert();
            }
            case 1: {
                return !isWest || westOn ? GateRenderState.OFF : GateRenderState.ON;
            }
            case 2: {
                return isWest || eastOn ? GateRenderState.OFF : GateRenderState.ON;
            }
            case 3: {
                return GateRenderState.input(this.getOutputValueInside(EnumFacing.NORTH));
            }
        }
        return GateRenderState.ON;
    }

    @Override
    protected byte calculateOutputInside(EnumFacing side) {
        boolean isWest = this.getInputValueInside(EnumFacing.SOUTH) != 0;
        return isWest ? this.getInputValueInside(EnumFacing.WEST) : this.getInputValueInside(EnumFacing.EAST);
    }

    @Override
    public GateConnection getType(EnumFacing dir) {
        return dir == EnumFacing.NORTH ? GateConnection.OUTPUT_ANALOG : (dir == EnumFacing.SOUTH ? GateConnection.INPUT : GateConnection.INPUT_ANALOG);
    }

    @Override
    public boolean canInvertSide(EnumFacing side) {
        return true;
    }
}

