/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates.logic;

import net.minecraft.util.EnumFacing;
import pl.asie.simplelogic.gates.logic.GateConnection;
import pl.asie.simplelogic.gates.logic.GateLogic;
import pl.asie.simplelogic.gates.logic.GateRenderState;
import pl.asie.simplelogic.gates.logic.IGateContainer;

public class GateLogicBundledTransceiver
extends GateLogic {
    private int inputState = 0;

    @Override
    public boolean tick(IGateContainer gate) {
        this.inputState = (this.getInputValueInside(EnumFacing.WEST) > 0 ? 2 : 0) | (this.getInputValueInside(EnumFacing.EAST) > 0 ? 1 : 0);
        return true;
    }

    @Override
    public void calculateOutputBundled(EnumFacing side, byte[] data) {
        if (this.inputState == 3) {
            byte[] inputNorth = this.getInputValueBundled(EnumFacing.NORTH);
            byte[] inputSouth = this.getInputValueBundled(EnumFacing.SOUTH);
            for (int i = 0; i < 16; ++i) {
                data[i] = (byte)Math.max(inputNorth != null ? inputNorth[i] : (byte)0, inputSouth != null ? inputSouth[i] : 0);
            }
            return;
        }
        byte[] src = null;
        switch (side) {
            case SOUTH: {
                if ((this.inputState & 2) == 0) break;
                src = this.getInputValueBundled(EnumFacing.NORTH);
                break;
            }
            case NORTH: {
                if ((this.inputState & 1) == 0) break;
                src = this.getInputValueBundled(EnumFacing.SOUTH);
                break;
            }
            default: {
                throw new RuntimeException("No bundled input here!");
            }
        }
        if (src == null) {
            for (int i = 0; i < 16; ++i) {
                data[i] = 0;
            }
        } else {
            System.arraycopy(src, 0, data, 0, 16);
        }
    }

    @Override
    public GateRenderState getLayerState(int id) {
        switch (id) {
            case 0: {
                return GateRenderState.inputOrDisabled(this, EnumFacing.WEST, this.getInputValueOutside(EnumFacing.WEST));
            }
            case 1: {
                return GateRenderState.inputOrDisabled(this, EnumFacing.EAST, this.getInputValueOutside(EnumFacing.EAST));
            }
        }
        return GateRenderState.DISABLED;
    }

    @Override
    public GateRenderState getTorchState(int id) {
        switch (id) {
            default: {
                return GateRenderState.OFF;
            }
            case 1: {
                return GateRenderState.input(this.getInputValueOutside(EnumFacing.WEST));
            }
            case 2: 
        }
        return GateRenderState.input(this.getInputValueOutside(EnumFacing.EAST));
    }

    @Override
    public GateConnection getType(EnumFacing dir) {
        if (dir.func_176740_k() == EnumFacing.Axis.Z) {
            return GateConnection.INPUT_OUTPUT_BUNDLED;
        }
        return GateConnection.INPUT;
    }
}

