/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import pl.asie.charset.lib.inventory.ContainerBase;
import pl.asie.charset.lib.inventory.GuiContainerCharset;
import pl.asie.charset.lib.network.Packet;
import pl.asie.simplelogic.gates.PacketTimerChangeTT;
import pl.asie.simplelogic.gates.SimpleLogicGates;
import pl.asie.simplelogic.gates.gui.ContainerGate;
import pl.asie.simplelogic.gates.logic.GateLogicTimer;

public class GuiTimer
extends GuiContainerCharset<ContainerGate> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("simplelogic:textures/gui/timer.png");
    private final List<TinyButton> buttonList = new ArrayList<TinyButton>(12);

    public GuiTimer(ContainerGate container) {
        super((ContainerBase)container, 85, 56);
        this.buttonList.add(new TinyButton(56, 8, 33, -12000));
        this.buttonList.add(new TinyButton(56, 18, 33, -1200));
        this.buttonList.add(new TinyButton(56, 33, 33, -200));
        this.buttonList.add(new TinyButton(56, 43, 33, -20));
        this.buttonList.add(new TinyButton(56, 58, 33, -2));
        this.buttonList.add(new TinyButton(56, 68, 33, -1));
        this.buttonList.add(new TinyButton(65, 8, 13, 12000));
        this.buttonList.add(new TinyButton(65, 18, 13, 1200));
        this.buttonList.add(new TinyButton(65, 33, 13, 200));
        this.buttonList.add(new TinyButton(65, 43, 13, 20));
        this.buttonList.add(new TinyButton(65, 58, 13, 2));
        this.buttonList.add(new TinyButton(65, 68, 13, 1));
    }

    protected void func_146976_a(float partial, int mouseX, int mouseY) {
        super.func_146976_a(partial, mouseX, mouseY);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.xBase, this.yBase, 0, 0, this.field_146999_f, this.field_147000_g);
        GateLogicTimer glt = (GateLogicTimer)((ContainerGate)this.container).gate.logic;
        int[] digits = new int[]{glt.getTicksTotal() / 12000 % 10, glt.getTicksTotal() / 1200 % 10, glt.getTicksTotal() / 200 % 6, glt.getTicksTotal() / 20 % 10, glt.getTicksTotal() / 2 % 10, (glt.getTicksTotal() & 1) * 5};
        for (TinyButton tb : this.buttonList) {
            int texX = tb.pressed ? 9 : 0;
            this.func_73729_b(this.xBase + tb.x, this.yBase + tb.y, texX, tb.texY, 9, 9);
        }
        int ix = 10;
        for (int i = 0; i < 6; ++i) {
            this.field_146297_k.field_71466_p.func_78276_b(Integer.toString(digits[i]), this.xBase + ix, this.yBase + 24, -1);
            ix += (i & 1) == 0 ? 10 : 15;
        }
    }

    public void func_73864_a(int x, int y, int mb) throws IOException {
        super.func_73864_a(x, y, mb);
        if (mb == 0) {
            for (TinyButton button : this.buttonList) {
                int bx = this.xBase + button.x;
                int by = this.yBase + button.y;
                if (x < bx || x >= bx + button.w || y < by || y >= by + button.h) continue;
                button.pressed = true;
            }
        }
    }

    public void func_146286_b(int x, int y, int which) {
        super.func_146286_b(x, y, which);
        if (which >= 0) {
            for (TinyButton button : this.buttonList) {
                if (!button.pressed) continue;
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                GateLogicTimer glt = (GateLogicTimer)((ContainerGate)this.container).gate.logic;
                SimpleLogicGates.packet.sendToServer((Packet)new PacketTimerChangeTT(((ContainerGate)this.container).gate, button.change));
                button.pressed = false;
            }
        }
    }

    public static class TinyButton {
        private final int texY;
        private final int x;
        private final int y;
        private final int w;
        private final int h;
        private final int change;
        private boolean pressed;

        public TinyButton(int texY, int x, int y, int change) {
            this.texY = texY;
            this.x = x;
            this.y = y;
            this.w = 9;
            this.h = 9;
            this.change = change;
        }
    }
}

