/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.common.FMLCommonHandler;
import pl.asie.simplelogic.gates.PartGate;
import pl.asie.simplelogic.gates.gui.ContainerGate;
import pl.asie.simplelogic.gates.logic.GateLogic;
import pl.asie.simplelogic.gates.render.GateCustomRenderer;

public class SimpleLogicGatesClient {
    public static final SimpleLogicGatesClient INSTANCE = new SimpleLogicGatesClient();
    private final Map<Class<? extends GateLogic>, Function<ContainerGate, GuiScreen>> guis = new IdentityHashMap<Class<? extends GateLogic>, Function<ContainerGate, GuiScreen>>();
    private final Map<Class<? extends GateLogic>, GateCustomRenderer> dynamicRenderers = new IdentityHashMap<Class<? extends GateLogic>, GateCustomRenderer>();

    public void registerRenderer(GateCustomRenderer renderer) {
        this.dynamicRenderers.put(renderer.getLogicClass(), renderer);
    }

    public void registerGui(Class<? extends GateLogic> cls, Function<ContainerGate, GuiScreen> func) {
        this.guis.put(cls, func);
    }

    public void openGui(PartGate gate) {
        FMLCommonHandler.instance().showGuiScreen((Object)this.guis.get(gate.logic.getClass()).apply(new ContainerGate(Minecraft.func_71410_x().field_71439_g.field_71071_by, gate)));
    }

    public GateCustomRenderer getRenderer(Class<? extends GateLogic> cl) {
        return this.dynamicRenderers.get(cl);
    }
}

